/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConfigDir {
    public static final String DEFAULT_PATH = "src/main/ml-config";
    private File baseDir;
    private String databasesPath = "databases";
    private String defaultContentDatabaseFilename = "content-database.json";
    private String restApiPath = "rest-api.json";
    private File projectDir;

    public static ConfigDir withProjectDir(File projectDir) {
        File baseDir = projectDir != null ? new File(projectDir, DEFAULT_PATH) : new File(DEFAULT_PATH);
        ConfigDir configDir = new ConfigDir(baseDir);
        configDir.projectDir = projectDir;
        return configDir;
    }

    public ConfigDir() {
        new File(DEFAULT_PATH);
    }

    public ConfigDir(File baseDir) {
        this.setBaseDir(baseDir);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getDatabasesDir() {
        return new File(this.baseDir, this.databasesPath);
    }

    public List<File> getDatabaseResourceDirectories() {
        File dbDir = this.getDatabasesDir();
        if (dbDir != null && dbDir.exists()) {
            File[] dirs = dbDir.listFiles(pathname -> pathname.isDirectory());
            return Arrays.asList(dirs);
        }
        return new ArrayList<File>();
    }

    public File getRestApiFile() {
        return new File(this.baseDir, this.restApiPath);
    }

    public File getRestApiServerFile() {
        return new File(this.getServersDir(), "rest-api-server.json");
    }

    public File getConfigurationsDir() {
        return new File(this.baseDir, "configurations");
    }

    public File getSecurityDir() {
        return new File(this.baseDir, "security");
    }

    public File getAmpsDir() {
        return new File(this.getSecurityDir(), "amps");
    }

    public File getCertificateAuthoritiesDir() {
        return new File(this.getSecurityDir(), "certificate-authorities");
    }

    public File getCertificateTemplatesDir() {
        return new File(this.getSecurityDir(), "certificate-templates");
    }

    public File getExternalSecuritiesDir() {
        return new File(this.getSecurityDir(), "external-security");
    }

    public File getPrivilegesDir() {
        return new File(this.getSecurityDir(), "privileges");
    }

    public File getProtectedCollectionsDir() {
        return new File(this.getSecurityDir(), "protected-collections");
    }

    public File getRolesDir() {
        return new File(this.getSecurityDir(), "roles");
    }

    public File getTriggersDir(String databaseName) {
        if (databaseName == null) {
            return this.getTriggersDir();
        }
        File dir = this.getDatabasesDir();
        File databaseDir = new File(dir, databaseName);
        return new File(databaseDir, "triggers");
    }

    public File getTriggersDir() {
        return new File(this.getBaseDir(), "triggers");
    }

    public File getPartitionsDir() {
        return new File(this.getBaseDir(), "partitions");
    }

    public File getPartitionQueriesDir() {
        return new File(this.getBaseDir(), "partition-queries");
    }

    public File getUsersDir() {
        return new File(this.getSecurityDir(), "users");
    }

    public File getProtectedPathsDir() {
        return new File(this.getSecurityDir(), "protected-paths");
    }

    public File getQueryRolesetsDir() {
        return new File(this.getSecurityDir(), "query-rolesets");
    }

    public File getServersDir() {
        return new File(this.baseDir, "servers");
    }

    public File getForestsDir() {
        return new File(this.baseDir, "forests");
    }

    public File getCpfDir() {
        return new File(this.baseDir, "cpf");
    }

    public File getDomainsDir() {
        return new File(this.getCpfDir(), "domains");
    }

    public File getPipelinesDir() {
        return new File(this.getCpfDir(), "pipelines");
    }

    public File getCpfConfigsDir() {
        return new File(this.getCpfDir(), "cpf-configs");
    }

    public File getClustersDir() {
        return new File(this.baseDir, "clusters");
    }

    public File getAlertDir() {
        return new File(this.baseDir, "alert");
    }

    public File getAlertConfigsDir() {
        return new File(this.getAlertDir(), "configs");
    }

    public File getFlexrepDir() {
        return new File(this.baseDir, "flexrep");
    }

    public File getFlexrepConfigsDir() {
        return new File(this.getFlexrepDir(), "configs");
    }

    public File getFlexrepPullsDir() {
        return new File(this.getFlexrepDir(), "pulls");
    }

    public File getGroupsDir() {
        return new File(this.baseDir, "groups");
    }

    public File getMimetypesDir() {
        return new File(this.baseDir, "mimetypes");
    }

    public File getViewSchemasDir() {
        return new File(this.baseDir, "view-schemas");
    }

    public File getTemporalDir() {
        return new File(this.baseDir, "temporal");
    }

    public File getTemporalAxesDir() {
        return new File(this.getTemporalDir(), "axes");
    }

    public File getTemporalCollectionsDir() {
        return new File(this.getTemporalDir(), "collections");
    }

    public File getTemporalCollectionsLsqtDir() {
        return new File(this.getTemporalCollectionsDir(), "lsqt");
    }

    public File getTasksDir() {
        return new File(this.baseDir, "tasks");
    }

    public File getTaskServersDir() {
        return new File(this.baseDir, "task-servers");
    }

    public void setDatabasesPath(String databasesPath) {
        this.databasesPath = databasesPath;
    }

    public void setRestApiPath(String restApiPath) {
        this.restApiPath = restApiPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getDefaultContentDatabaseFilename() {
        return this.defaultContentDatabaseFilename;
    }

    public void setDefaultContentDatabaseFilename(String contentDatabaseFilename) {
        this.defaultContentDatabaseFilename = contentDatabaseFilename;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public File getSecureCredentialsDir() {
        return new File(this.getSecurityDir(), "secure-credentials");
    }

    public File getCredentialsDir() {
        return new File(this.getSecurityDir(), "credentials");
    }
}

