/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class RestConfig {
    private String host;
    private int port;
    private String username;
    private String password;
    private String scheme = "http";
    private boolean configureSimpleSsl;
    private boolean useDefaultKeystore;
    private String sslProtocol;
    private String trustManagementAlgorithm;
    private SSLContext sslContext;
    private X509HostnameVerifier hostnameVerifier;

    public RestConfig() {
    }

    public RestConfig(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return String.format("[scheme: %s, host: %s, port: %d, username: %s]", this.scheme, this.host, this.port, this.username);
    }

    public URI buildUri(String path) {
        try {
            return new URI(String.format("%s://%s:%d%s", this.getScheme(), this.getHost(), this.getPort(), path.replace(" ", "+")));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Unable to build URI for path: " + path + "; cause: " + ex.getMessage(), ex);
        }
    }

    public String getBaseUrl() {
        return String.format("%s://%s:%d", this.scheme, this.host, this.port);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isConfigureSimpleSsl() {
        return this.configureSimpleSsl;
    }

    public void setConfigureSimpleSsl(boolean configureSimpleSsl) {
        this.configureSimpleSsl = configureSimpleSsl;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getTrustManagementAlgorithm() {
        return this.trustManagementAlgorithm;
    }

    public void setTrustManagementAlgorithm(String trustManagementAlgorithm) {
        this.trustManagementAlgorithm = trustManagementAlgorithm;
    }

    public boolean isUseDefaultKeystore() {
        return this.useDefaultKeystore;
    }

    public void setUseDefaultKeystore(boolean useDefaultKeystore) {
        this.useDefaultKeystore = useDefaultKeystore;
    }
}

