/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class PreviewInterceptor
extends DefaultResponseErrorHandler
implements ClientHttpRequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ManageClient manageClient;
    private ArrayNode results;

    public PreviewInterceptor(ManageClient manageClient) {
        this.manageClient = manageClient;
        this.results = ObjectMapperFactory.getObjectMapper().createArrayNode();
    }

    protected boolean hasError(HttpStatus statusCode) {
        if (HttpStatus.NOT_FOUND.equals((Object)statusCode)) {
            this.logger.info("Received a 404 response, but ignoring while doing a preview");
            return false;
        }
        return super.hasError(statusCode);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        if (HttpMethod.PUT.equals((Object)request.getMethod())) {
            return this.previewPut(request, bytes);
        }
        if (HttpMethod.POST.equals((Object)request.getMethod())) {
            return this.previewPost(request, bytes);
        }
        return execution.execute(request, bytes);
    }

    protected ClientHttpResponse previewPut(HttpRequest request, byte[] bytes) throws IOException {
        this.logger.info("Previewing PUT to: " + request.getURI());
        String payload = new String(bytes).trim();
        if (new PayloadParser().isJsonPayload(payload)) {
            ObjectNode existingResource = this.getExistingResource(request);
            JsonNode diff = this.buildJsonPatch(existingResource, payload);
            this.includeJsonPatchInReport(request, existingResource, diff);
        } else {
            this.logger.info("Payload is XML, preview is not yet supported for XML");
            ObjectNode result = ObjectMapperFactory.getObjectMapper().createObjectNode();
            result.set("message", (JsonNode)new TextNode("Preview not supported for XML resource files, so not performing preview for PUT to: " + request.getURI()));
            this.results.add((JsonNode)result);
        }
        this.logger.info("Previewing, so not sending PUT to: " + request.getURI());
        return this.newFakeResponse();
    }

    protected JsonNode buildJsonPatch(ObjectNode existingResource, String payload) throws IOException {
        ObjectNode payloadResource = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(payload);
        this.modifyPayloadBeforePreview(payloadResource);
        ObjectNode merged = JsonNodeUtil.mergeObjectNodes(existingResource, payloadResource);
        EnumSet<DiffFlags> flags = EnumSet.of(DiffFlags.OMIT_VALUE_ON_REMOVE, DiffFlags.OMIT_MOVE_OPERATION, DiffFlags.OMIT_COPY_OPERATION, DiffFlags.ADD_ORIGINAL_VALUE_ON_REPLACE);
        return JsonDiff.asJson((JsonNode)existingResource, (JsonNode)merged, flags);
    }

    protected void includeJsonPatchInReport(HttpRequest request, ObjectNode existingResource, JsonNode jsonPatch) {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        if (jsonPatch instanceof ArrayNode && jsonPatch.size() > 0) {
            ObjectNode result = mapper.createObjectNode();
            result.set("message", (JsonNode)new TextNode("Will update resource at: " + request.getURI()));
            result.set("existingResource", (JsonNode)existingResource);
            result.set("patch", jsonPatch);
            this.results.add((JsonNode)result);
        } else {
            ObjectNode result = mapper.createObjectNode();
            result.set("message", (JsonNode)new TextNode("No changes for resource at: " + request.getURI()));
            this.results.add((JsonNode)result);
        }
    }

    protected ObjectNode getExistingResource(HttpRequest request) throws IOException {
        String existingJson = this.manageClient.getJson(request.getURI());
        return (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(existingJson);
    }

    protected void modifyPayloadBeforePreview(ObjectNode payload) {
        if (payload.has("password")) {
            payload.remove("password");
        }
        if (payload.has("view-name") && payload.has("schema-name")) {
            payload.remove("schema-name");
        }
    }

    protected ClientHttpResponse previewPost(HttpRequest request, byte[] bytes) throws IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        if (request.getURI() != null && request.getURI().toString().endsWith("/manage/v3")) {
            String message = "Previewing POST calls to /manage/v3 are not yet supported";
            result.set("message", (JsonNode)new TextNode(message));
            this.results.add((JsonNode)result);
            this.logger.info(message);
            return this.newFakeResponse();
        }
        result.set("message", (JsonNode)new TextNode("Will create new resource at: " + request.getURI()));
        String payload = new String(bytes).trim();
        if (new PayloadParser().isJsonPayload(payload)) {
            ObjectNode node = (ObjectNode)mapper.readTree(payload);
            if (node.has("password")) {
                node.remove("password");
            }
            result.set("resource", (JsonNode)node);
        } else {
            result.set("resource", (JsonNode)new TextNode(payload));
        }
        this.results.add((JsonNode)result);
        this.logger.info("Previewing, so not sending POST to: " + request.getURI());
        return this.newFakeResponse();
    }

    protected ClientHttpResponse newFakeResponse() {
        return new ClientHttpResponse(){

            public HttpStatus getStatusCode() {
                return HttpStatus.OK;
            }

            public int getRawStatusCode() {
                return 200;
            }

            public String getStatusText() {
                return null;
            }

            public void close() {
            }

            public InputStream getBody() {
                return new ByteArrayInputStream(new byte[0]);
            }

            public HttpHeaders getHeaders() {
                return new HttpHeaders();
            }
        };
    }

    public ArrayNode getResults() {
        return this.results;
    }
}

