/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.selector;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.selector.MapResourceSelection;
import com.marklogic.mgmt.selector.ResourceSelection;
import com.marklogic.mgmt.selector.ResourceSelector;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class PropertiesResourceSelector
implements ResourceSelector {
    private Properties props;

    public PropertiesResourceSelector(File file) {
        this.props = new Properties();
        try {
            FileReader reader = new FileReader(file);
            this.props.load(reader);
            reader.close();
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    public PropertiesResourceSelector(Properties props) {
        this.props = props;
    }

    @Override
    public ResourceSelection selectResources(ManageClient manageClient) {
        MapResourceSelection selection = new MapResourceSelection();
        for (String prop : this.props.stringPropertyNames()) {
            String[] values;
            for (String value : values = this.props.getProperty(prop).split(",")) {
                selection.select(prop, value);
            }
        }
        return selection;
    }
}

