/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import org.springframework.web.client.ResourceAccessException;

public class ProtectedPathManager
extends AbstractResourceManager {
    public ProtectedPathManager(ManageClient client) {
        super(client);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    public String getResourcesPath() {
        return "/manage/v2/protected-paths";
    }

    @Override
    protected String getResourceName() {
        return "protected-path";
    }

    @Override
    protected String getIdFieldName() {
        return "path-expression";
    }

    @Override
    public String getPropertiesPath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.getResourcesPath() + "/" + this.getIdForPathExpression(resourceNameOrId) + "/properties";
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.getResourcesPath() + "/" + this.getIdForPathExpression(resourceNameOrId);
    }

    @Override
    protected String[] getDeleteResourceParams(String payload) {
        return new String[]{"force", "true"};
    }

    @Override
    public boolean exists(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking for existence of resource: " + resourceNameOrId);
        }
        return this.getAsXml().elementExists(this.format("/node()/*[local-name(.) = 'list-items']/node()[*[local-name(.) = 'nameref'] = '%s']", new Object[]{resourceNameOrId}));
    }

    public String getIdForPathExpression(String pathExpression) {
        return this.getIdForPathExpression(pathExpression, this.getAsXml());
    }

    public String getIdForPathExpression(String pathExpression, Fragment resourcesXml) {
        String xpath = "/node()/*[local-name(.) = 'list-items']/node()[*[local-name(.) = 'nameref'] = '%s']/*[local-name(.) = 'idref']";
        String id = resourcesXml.getElementValue(xpath = String.format(xpath, pathExpression));
        if (id == null) {
            throw new RuntimeException("Could not find a protected path with a path-expression of: " + pathExpression);
        }
        return id;
    }

    @Override
    public ResourcesFragment getAsXml() {
        try {
            return new ResourcesFragment(this.getManageClient().getXmlAsSecurityUser(this.getResourcesPath(), new String[0]));
        }
        catch (ResourceAccessException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unable to get list of protected paths, retrying; cause: " + ex.getMessage());
            }
            return new ResourcesFragment(this.getManageClient().getXmlAsSecurityUser(this.getResourcesPath(), new String[0]));
        }
    }
}

