/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.security.AmpParams;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import java.util.ArrayList;
import org.jdom2.Namespace;
import org.springframework.http.ResponseEntity;

public class AmpManager
extends AbstractResourceManager {
    private String namespace;
    private String documentUri;
    private String modulesDatabase;

    public AmpManager(ManageClient client) {
        super(client);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    public String getResourcePath(String resourceNameOrId) {
        return super.getResourcePath(resourceNameOrId, "namespace", this.namespace, "document-uri", this.documentUri, "modules-database", this.modulesDatabase);
    }

    public String getPropertiesPath(String resourceNameOrId) {
        return super.getPropertiesPath(resourceNameOrId, "namespace", this.namespace, "document-uri", this.documentUri, "modules-database", this.modulesDatabase);
    }

    @Override
    protected String getIdFieldName() {
        return "local-name";
    }

    @Override
    public SaveReceipt save(String payload) {
        String resourceId = this.getResourceId(payload);
        String label = this.getResourceName();
        String path = null;
        ResponseEntity<String> response = null;
        if (this.ampExists(payload)) {
            return this.updateResource(payload, resourceId);
        }
        this.logger.info(this.format("Creating %s: %s", new Object[]{label, resourceId}));
        path = this.getCreateResourcePath(payload);
        response = this.postPayload(this.getManageClient(), path, payload);
        this.logger.info(this.format("Created %s: %s", new Object[]{label, resourceId}));
        return new SaveReceipt(resourceId, payload, path, response);
    }

    public boolean ampExists(String payload) {
        String resourceId = this.getResourceId(payload);
        AmpParams params = this.getAmpParams(payload);
        return this.ampExists(this.getAsXml(), resourceId, params.documentUri, params.namespace, params.modulesDatabase);
    }

    public boolean ampExists(ResourcesFragment resources, String localName, String documentUri, String namespace, String modulesDatabase) {
        Object xpath = "/node()/*[local-name(.) = 'list-items']/node()[(*[local-name(.) = 'nameref'] = '%s' or *[local-name(.) = 'idref'] = '%s') and *[local-name(.) = 'document-uri'] = '%s'";
        xpath = this.format((String)xpath, new Object[]{localName, localName, documentUri});
        if (namespace != null) {
            xpath = (String)xpath + this.format(" and *[local-name(.) = 'namespace'] = '%s'", new Object[]{namespace});
        }
        xpath = modulesDatabase != null ? (String)xpath + this.format(" and *[local-name(.) = 'modules-database'] = '%s'", new Object[]{modulesDatabase}) : (String)xpath + this.format(" and *[local-name(.) = 'modules-database'] = 'filesystem'", new Object[0]);
        xpath = (String)xpath + "]";
        return resources.elementExists((String)xpath);
    }

    @Override
    protected String[] getUpdateResourceParams(String payload) {
        ArrayList<String> params = new ArrayList<String>();
        AmpParams ampParams = this.getAmpParams(payload);
        params.add("document-uri");
        params.add(ampParams.documentUri);
        if (ampParams.namespace != null) {
            params.add("namespace");
            params.add(ampParams.namespace);
        }
        if (ampParams.modulesDatabase != null) {
            params.add("modules-database");
            params.add(ampParams.modulesDatabase);
        }
        return params.toArray(new String[0]);
    }

    @Override
    protected String[] getDeleteResourceParams(String payload) {
        ArrayList<String> params = new ArrayList<String>();
        AmpParams ampParams = this.getAmpParams(payload);
        params.add("document-uri");
        params.add(ampParams.documentUri);
        if (ampParams.namespace != null) {
            params.add("namespace");
            params.add(ampParams.namespace);
        }
        if (ampParams.modulesDatabase != null) {
            params.add("modules-database");
            params.add(ampParams.modulesDatabase);
        }
        return params.toArray(new String[0]);
    }

    public AmpParams getAmpParams(String payload) {
        AmpParams params = new AmpParams();
        if (this.payloadParser.isJsonPayload(payload)) {
            JsonNode node = this.payloadParser.parseJson(payload);
            params.documentUri = node.get("document-uri").asText();
            if (node.has("namespace")) {
                params.namespace = node.get("namespace").asText();
            }
            if (node.has("modules-database")) {
                params.modulesDatabase = node.get("modules-database").asText();
            }
        } else {
            Fragment f = new Fragment(payload, new Namespace[0]);
            params.documentUri = f.getElementValue("/node()/*[local-name(.) = 'document-uri']");
            String val = f.getElementValue("/node()/*[local-name(.) = 'namespace']");
            if (val != null) {
                params.namespace = val;
            }
            if ((val = f.getElementValue("/node()/*[local-name(.) = 'modules-database']")) != null) {
                params.modulesDatabase = val;
            }
        }
        return params;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDocumentUri(String documentUri) {
        this.documentUri = documentUri;
    }

    public void setModulesDatabase(String modulesDatabase) {
        this.modulesDatabase = modulesDatabase;
    }
}

