/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.restapis;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.restapis.RestApiDeletionRequest;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public class RestApiManager
extends LoggingObject {
    private PayloadParser payloadParser = new PayloadParser();
    private ManageClient client;
    private String groupName;

    public RestApiManager(ManageClient client) {
        this(client, "Default");
    }

    public RestApiManager(ManageClient client, String groupName) {
        this.client = client;
        this.groupName = groupName;
    }

    public ResponseEntity<String> createRestApi(String json) {
        return this.createRestApi(this.extractNameFromJson(json), json);
    }

    public ResponseEntity<String> createRestApi(String name, String json) {
        this.logger.info("Checking for existence of REST API with name: " + name);
        if (this.restApiServerExists(name)) {
            this.logger.info("REST API server already exists with name: " + name);
            return null;
        }
        this.logger.info("Creating REST API: " + json);
        ResponseEntity<String> re = this.client.postJson("/v1/rest-apis", json);
        this.logger.info("Created REST API");
        return re;
    }

    public String extractNameFromJson(String json) {
        JsonNode node = this.payloadParser.parseJson(json);
        return node.get("rest-api").get("name").textValue();
    }

    public boolean restApiServerExists(String name) {
        String group = this.groupName != null ? this.groupName : "Default";
        return new ServerManager(this.client, group).exists(name, new String[0]);
    }

    public boolean deleteRestApi(RestApiDeletionRequest request) {
        String serverName;
        ServerManager serverManager = new ServerManager(this.client, request.getGroupName());
        if (serverManager.exists(serverName = request.getServerName(), new String[0])) {
            Object path = this.format("/v1/rest-apis/%s", new Object[]{serverName});
            if (request.isIncludeModules() || request.isIncludeContent()) {
                path = (String)path + "?";
                DatabaseManager databaseManager = new DatabaseManager(this.client);
                String payload = serverManager.getPropertiesAsJson(serverName, new String[0]);
                PayloadParser parser = new PayloadParser();
                if (request.isIncludeModules()) {
                    String modulesDatabase;
                    if (request.isDeleteModulesReplicaForests() && databaseManager.exists(modulesDatabase = parser.getPayloadFieldValue(payload, "modules-database"), new String[0])) {
                        databaseManager.deleteReplicaForests(modulesDatabase);
                    }
                    path = (String)path + "include=modules&";
                }
                if (request.isIncludeContent()) {
                    String contentDatabase;
                    if (request.isDeleteContentReplicaForests() && databaseManager.exists(contentDatabase = parser.getPayloadFieldValue(payload, "content-database"), new String[0])) {
                        databaseManager.deleteReplicaForests(contentDatabase);
                    }
                    path = (String)path + "include=content";
                }
            }
            this.logger.info("Deleting REST API, path: " + (String)path);
            this.client.getRestTemplate().exchange(this.client.buildUri((String)path), HttpMethod.DELETE, null, String.class);
            this.logger.info("Deleted REST API");
            return true;
        }
        this.logger.info(this.format("Server %s does not exist, not deleting", new Object[]{serverName}));
        return false;
    }
}

