/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.databases;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.rest.util.Fragment;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;

public class DatabaseManager
extends AbstractResourceManager {
    public static final String DELETE_FOREST_DATA = "data";
    public static final String DELETE_FOREST_CONFIGURATION = "configuration";
    private String forestDelete = "data";
    private boolean deleteReplicas = true;

    public DatabaseManager(ManageClient manageClient) {
        super(manageClient);
    }

    @Override
    protected ResponseEntity<String> putPayload(ManageClient client, String path, String payload) {
        if (this.payloadParser.isJsonPayload(payload)) {
            payload = this.payloadParser.excludeProperties(payload, this.getIdFieldName());
        }
        return super.putPayload(client, path, payload);
    }

    public void clearDatabase(String databaseIdOrName) {
        this.clearDatabase(databaseIdOrName, true);
    }

    public void clearDatabase(String databaseIdOrName, boolean catchException) {
        try {
            this.invokeOperation(databaseIdOrName, "clear-database");
        }
        catch (Exception e) {
            if (catchException) {
                this.logger.error("Unable to clear database; cause: " + e.getMessage());
            }
            throw e;
        }
    }

    public void mergeDatabase(String databaseIdOrName) {
        this.invokeOperation(databaseIdOrName, "merge-database");
    }

    public void reindexDatabase(String databaseIdOrName) {
        this.invokeOperation(databaseIdOrName, "reindex-database");
    }

    private void invokeOperation(String databaseIdOrName, String operation) {
        String path = this.format("/manage/v2/databases/%s", new Object[]{databaseIdOrName});
        this.logger.info(this.format("Invoking operation %s on database %s", new Object[]{operation, databaseIdOrName}));
        this.getManageClient().postJson(path, this.format("{\"operation\":\"%s\"}", new Object[]{operation}));
        this.logger.info(this.format("Finished invoking operation %s on database %s", new Object[]{operation, databaseIdOrName}));
    }

    @Override
    public String getResourceId(String payload) {
        return super.getResourceId(payload);
    }

    public void detachSubDatabases(String databaseIdOrName) {
        this.logger.info("Detaching sub-databases from database: " + databaseIdOrName);
        this.save(this.format("{\"database-name\":\"%s\", \"subdatabase\": []}", new Object[]{databaseIdOrName}));
        this.logger.info("Finished detaching sub-databases from database: " + databaseIdOrName);
    }

    public void attachSubDatabases(String databaseIdOrName, List<String> subDbNames) {
        Object payload = this.format("{\"database-name\":\"%s\", \"subdatabase\": [", new Object[]{databaseIdOrName});
        for (int index = 0; index < subDbNames.size(); ++index) {
            if (index > 0) {
                payload = (String)payload + ",";
            }
            payload = (String)payload + this.format("{\"database-name\":\"%s\"}", new Object[]{subDbNames.get(index)});
        }
        payload = (String)payload + "]}";
        this.logger.info("Attaching sub-databases to database: " + databaseIdOrName + ", using configured payload: " + (String)payload);
        this.save((String)payload);
        this.logger.info("Finished attaching sub-databases to database: " + databaseIdOrName);
    }

    public List<String> getSubDatabases(String databaseNameOrId) {
        return this.getPropertiesAsXml(databaseNameOrId, new String[0]).getElementValues("/node()/m:subdatabases/m:subdatabase/m:database-name");
    }

    public void deleteByName(String databaseName) {
        String json = this.format("{\"database-name\":\"%s\"}", new Object[]{databaseName});
        this.delete(json, new String[0]);
    }

    public void deleteForestsAndReplicas(String databaseIdOrName) {
        List<String> primaryForestIds = this.getPrimaryForestIds(databaseIdOrName);
        this.detachForests(databaseIdOrName);
        ForestManager forestManager = new ForestManager(this.getManageClient());
        for (String forestId : primaryForestIds) {
            forestManager.delete(forestId, "full", "delete");
        }
    }

    public void detachForests(String databaseIdOrName) {
        this.logger.info("Detaching forests from database: " + databaseIdOrName);
        this.save(this.format("{\"database-name\":\"%s\", \"forest\":[]}", new Object[]{databaseIdOrName}));
        this.logger.info("Finished detaching forests from database: " + databaseIdOrName);
    }

    @Override
    protected void beforeDelete(String resourceId, String path, String ... resourceUrlParams) {
        if (this.deleteReplicas) {
            this.logger.info("Deleting forests and replicas for database: " + resourceId);
            this.deleteForestsAndReplicas(resourceId);
            this.logger.info("Finished deleting forests and replicas for database: " + resourceId);
        }
    }

    public List<String> getForestIds(String databaseNameOrId) {
        Fragment f = this.getAsXml(databaseNameOrId, new String[0]);
        return f.getElementValues("/node()/db:relations/db:relation-group[db:typeref='forests']/db:relation/db:idref");
    }

    public List<String> getForestNames(String databaseNameOrId) {
        Fragment f = this.getAsXml(databaseNameOrId, new String[0]);
        return f.getElementValues("/node()/db:relations/db:relation-group[db:typeref='forests']/db:relation/db:nameref");
    }

    public List<String> getPrimaryForestIds(String databaseNameOrId) {
        if (this.exists(databaseNameOrId, new String[0])) {
            return this.getPropertiesAsXml(databaseNameOrId, new String[0]).getElementValues("/node()/m:forests/m:forest");
        }
        return new ArrayList<String>();
    }

    public void deleteReplicaForests(String databaseNameOrId) {
        this.logger.info(this.format("Deleting replica forests (if any exist) for database %s", new Object[]{databaseNameOrId}));
        ForestManager mgr = new ForestManager(this.getManageClient());
        for (String forestId : this.getPrimaryForestIds(databaseNameOrId)) {
            mgr.deleteReplicas(forestId);
        }
        this.logger.info(this.format("Finished deleting replica forests for database %s", new Object[]{databaseNameOrId}));
    }

    public void setUpdatesAllowedOnPrimaryForests(String databaseNameOrId, String mode) {
        ForestManager mgr = new ForestManager(this.getManageClient());
        for (String forestId : this.getPrimaryForestIds(databaseNameOrId)) {
            mgr.setUpdatesAllowed(forestId, mode);
        }
    }

    @Override
    protected String[] getDeleteResourceParams(String payload) {
        String[] stringArray;
        if (this.forestDelete != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "forest-delete";
            stringArray = stringArray2;
            stringArray2[1] = this.forestDelete;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setForestDelete(String forestDelete) {
        this.forestDelete = forestDelete;
    }

    public String getForestDelete() {
        return this.forestDelete;
    }

    public boolean isDeleteReplicas() {
        return this.deleteReplicas;
    }

    public void setDeleteReplicas(boolean deleteReplicas) {
        this.deleteReplicas = deleteReplicas;
    }
}

