/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.mapper;

import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.server.HttpServer;
import com.marklogic.mgmt.api.server.OdbcServer;
import com.marklogic.mgmt.api.server.Server;
import com.marklogic.mgmt.api.server.XdbcServer;
import com.marklogic.mgmt.mapper.ResourceMapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;

public class DefaultResourceMapper
implements ResourceMapper {
    private API api;
    private Map<Class<?>, JAXBContext> jaxbContextMap;
    private PayloadParser payloadParser = new PayloadParser();

    public DefaultResourceMapper() {
        this.jaxbContextMap = new HashMap();
    }

    public DefaultResourceMapper(API api) {
        this();
        this.api = api;
    }

    @Override
    public <T extends Resource> T readResource(String payload, Class<T> resourceType) {
        try {
            Resource resource;
            if (this.payloadParser.isJsonPayload(payload)) {
                resource = (Resource)this.api.getObjectMapper().readerFor(resourceType).readValue(payload);
            } else {
                JAXBContext context = resourceType.equals(Server.class) ? (payload.contains("xdbc-server-properties") ? this.jaxbContextMap.get(XdbcServer.class) : (payload.contains("odbc-server-properties") ? this.jaxbContextMap.get(OdbcServer.class) : this.jaxbContextMap.get(HttpServer.class))) : this.jaxbContextMap.get(resourceType);
                if (context == null) {
                    context = resourceType.equals(Server.class) ? (payload.contains("xdbc-server-properties") ? JAXBContext.newInstance((Class[])new Class[]{XdbcServer.class}) : (payload.contains("odbc-server-properties") ? JAXBContext.newInstance((Class[])new Class[]{OdbcServer.class}) : JAXBContext.newInstance((Class[])new Class[]{HttpServer.class}))) : JAXBContext.newInstance((Class[])new Class[]{resourceType});
                    this.jaxbContextMap.put(resourceType, context);
                }
                resource = (Resource)context.createUnmarshaller().unmarshal((Reader)new StringReader(payload));
            }
            if (this.api != null) {
                resource.setApi(this.api);
                resource.setObjectMapper(this.api.getObjectMapper());
            }
            return (T)resource;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read resource payload: " + ex.getMessage(), ex);
        }
    }
}

