/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.cma;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.rest.util.MgmtResponseErrorHandler;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;

public class ConfigurationManager
extends AbstractManager {
    public static final String PATH = "/manage/v3";
    private ManageClient manageClient;

    public ConfigurationManager(ManageClient manageClient) {
        this.manageClient = manageClient;
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    public boolean endpointExists() {
        try {
            MgmtResponseErrorHandler.errorLoggingEnabled = false;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Checking to see if Configuration Management API is available at: /manage/v3");
            }
            String emptyPayload = "{}";
            this.submit("{}");
            boolean bl = true;
            return bl;
        }
        catch (HttpClientErrorException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            MgmtResponseErrorHandler.errorLoggingEnabled = true;
        }
    }

    public SaveReceipt save(String payload) {
        String configurationName = this.payloadParser.getPayloadFieldValue(payload, "name", false);
        if (configurationName == null) {
            configurationName = "with unknown name";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Applying configuration " + configurationName);
        }
        SaveReceipt receipt = this.submit(payload);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Applied configuration " + configurationName);
        }
        return receipt;
    }

    public SaveReceipt submit(String payload) {
        ResponseEntity<String> response = this.postPayload(this.manageClient, PATH, payload);
        return new SaveReceipt(null, payload, PATH, response);
    }
}

