/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.mgmt.util.ObjectNodesSorter;
import com.marklogic.mgmt.util.TopologicalSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RoleObjectNodesSorter
implements ObjectNodesSorter {
    @Override
    public List<ObjectNode> sortObjectNodes(List<ObjectNode> objectNodes) {
        List<Role> roles = new ArrayList<Role>();
        ObjectReader reader = ObjectMapperFactory.getObjectMapper().readerFor(Role.class);
        for (ObjectNode node : objectNodes) {
            try {
                roles.add((Role)reader.readValue((JsonNode)node));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read ObjectNode into Role; node: " + node, e);
            }
        }
        roles = this.sortRoles(roles);
        ArrayList<ObjectNode> newList = new ArrayList<ObjectNode>();
        roles.forEach(role -> newList.add(role.toObjectNode()));
        return newList;
    }

    public List<Role> sortRoles(List<Role> roles) {
        int count = roles.size();
        TopologicalSorter sorter = new TopologicalSorter(count);
        ArrayList roleNames = new ArrayList();
        HashMap map = new HashMap();
        roles.forEach(role -> {
            sorter.addVertex(role.getRoleName());
            roleNames.add(role.getRoleName());
            map.put(role.getRoleName(), role);
        });
        for (int i = 0; i < count; ++i) {
            for (String dependency : roles.get(i).getDependentRoleNames()) {
                int index = roleNames.indexOf(dependency);
                if (index == i || index <= -1) continue;
                sorter.addEdge(index, i);
            }
        }
        String[] sortedRoleNames = sorter.sort();
        roles = new ArrayList<Role>();
        for (String name : sortedRoleNames) {
            roles.add((Role)map.get(name));
        }
        return roles;
    }
}

