/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.admin;

import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.PropertySourceFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class DefaultAdminConfigFactory
extends PropertySourceFactory
implements AdminConfigFactory {
    private Map<String, BiConsumer<AdminConfig, String>> propertyConsumerMap;

    public DefaultAdminConfigFactory() {
        this.initialize();
    }

    public DefaultAdminConfigFactory(PropertySource propertySource) {
        super(propertySource);
        this.initialize();
    }

    public void initialize() {
        this.propertyConsumerMap = new LinkedHashMap<String, BiConsumer<AdminConfig, String>>();
        this.propertyConsumerMap.put("mlAdminHost", (config, prop) -> {
            this.logger.info("Admin interface host: " + prop);
            config.setHost((String)prop);
        });
        this.propertyConsumerMap.put("mlHost", (config, prop) -> {
            if (!this.propertyExists("mlAdminHost")) {
                this.logger.info("Admin interface host: " + prop);
                config.setHost((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlAdminPort", (config, prop) -> {
            this.logger.info("Admin interface port: " + prop);
            config.setPort(Integer.parseInt(prop));
        });
        this.propertyConsumerMap.put("mlManageUsername", (config, prop) -> {
            this.logger.info("Admin interface username: " + prop);
            config.setUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlUsername", (config, prop) -> {
            if (!this.propertyExists("mlManageUsername")) {
                this.logger.info("Admin interface username: " + prop);
                config.setUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePassword", (config, prop) -> config.setPassword((String)prop));
        this.propertyConsumerMap.put("mlPassword", (config, prop) -> {
            if (!this.propertyExists("mlManagePassword")) {
                config.setPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlAdminScheme", (config, prop) -> {
            this.logger.info("Admin interface scheme: " + prop);
            config.setScheme((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminSimpleSsl", (config, prop) -> {
            this.logger.info("Use simple SSL for Admin interface: " + prop);
            config.setConfigureSimpleSsl(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAdminSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for Admin app server: " + prop);
            config.setSslProtocol((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for Admin app server: " + prop);
            config.setUseDefaultKeystore(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAdminTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for Admin app server: " + prop);
            config.setTrustManagementAlgorithm((String)prop);
        });
    }

    @Override
    public AdminConfig newAdminConfig() {
        AdminConfig config = new AdminConfig();
        for (String propertyName : this.propertyConsumerMap.keySet()) {
            String value = this.getProperty(propertyName);
            if (value == null) continue;
            this.propertyConsumerMap.get(propertyName).accept(config, value);
        }
        return config;
    }

    public Map<String, BiConsumer<AdminConfig, String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }
}

