/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.admin;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.admin.ActionRequiringRestart;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.RestTemplateUtil;
import java.net.URI;
import org.jdom2.Namespace;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class AdminManager
extends AbstractManager {
    private int waitForRestartCheckInterval = 1000;
    private int waitForRestartLimit = 30;
    private RestTemplate restTemplate;
    private AdminConfig adminConfig;

    public AdminManager() {
        this(new AdminConfig());
    }

    public AdminManager(AdminConfig adminConfig) {
        this.setAdminConfig(adminConfig);
    }

    public void setAdminConfig(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
        this.restTemplate = RestTemplateUtil.newRestTemplate(adminConfig);
    }

    public void init() {
        this.init(null, null);
    }

    public void init(String licenseKey, String licensee) {
        final URI uri = this.adminConfig.buildUri("/admin/v1/init");
        String json = null;
        json = licenseKey != null && licensee != null ? this.format("{\"license-key\":\"%s\", \"licensee\":\"%s\"}", new Object[]{licenseKey, licensee}) : "{}";
        final String payload = json;
        this.logger.info("Initializing MarkLogic at: " + uri);
        this.invokeActionRequiringRestart(new ActionRequiringRestart(){

            @Override
            public boolean execute() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity entity = new HttpEntity((Object)payload, (MultiValueMap)headers);
                try {
                    ResponseEntity response = AdminManager.this.restTemplate.exchange(uri, HttpMethod.POST, entity, String.class);
                    AdminManager.this.logger.info("Initialization response: " + response);
                    return HttpStatus.ACCEPTED.equals((Object)response.getStatusCode());
                }
                catch (HttpClientErrorException hcee) {
                    String body = hcee.getResponseBodyAsString();
                    if (AdminManager.this.logger.isTraceEnabled()) {
                        AdminManager.this.logger.trace("Response body: " + body);
                    }
                    if (body != null && body.contains("MANAGE-ALREADYINIT")) {
                        AdminManager.this.logger.info("MarkLogic has already been initialized");
                        return false;
                    }
                    AdminManager.this.logger.error("Caught error, response body: " + body);
                    throw hcee;
                }
            }
        });
    }

    public void installAdmin() {
        this.installAdmin(null, null);
    }

    public void installAdmin(String username, String password) {
        this.installAdmin(username, password, "public");
    }

    public void installAdmin(String username, String password, String realm) {
        final URI uri = this.adminConfig.buildUri("/admin/v1/instance-admin");
        String json = null;
        json = username != null && password != null ? this.format("{\"admin-username\":\"%s\", \"admin-password\":\"%s\", \"realm\":\"%s\"}", new Object[]{username, password, realm}) : "{}";
        final String payload = json;
        this.logger.info("Installing admin user at: " + uri);
        this.invokeActionRequiringRestart(new ActionRequiringRestart(){

            @Override
            public boolean execute() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity entity = new HttpEntity((Object)payload, (MultiValueMap)headers);
                try {
                    ResponseEntity response = AdminManager.this.restTemplate.exchange(uri, HttpMethod.POST, entity, String.class);
                    AdminManager.this.logger.info("Admin installation response: " + response);
                    return HttpStatus.ACCEPTED.equals((Object)response.getStatusCode());
                }
                catch (HttpClientErrorException hcee) {
                    if (HttpStatus.BAD_REQUEST.equals((Object)hcee.getStatusCode())) {
                        AdminManager.this.logger.warn("Caught 400 error, assuming admin user already installed; response body: " + hcee.getResponseBodyAsString());
                        return false;
                    }
                    throw hcee;
                }
            }
        });
    }

    public void invokeActionRequiringRestart(ActionRequiringRestart action) {
        this.logger.info("Executing action that may require restarting MarkLogic");
        boolean requiresRestart = action.execute();
        if (requiresRestart) {
            this.logger.info("Waiting for MarkLogic to restart...");
            this.waitForRestart();
        }
    }

    public String getLastRestartTimestamp() {
        return (String)this.restTemplate.getForEntity(this.adminConfig.buildUri("/admin/v1/timestamp"), String.class).getBody();
    }

    public void waitForRestart() {
        this.waitForRestartInternal(1);
    }

    private void waitForRestartInternal(int attempt) {
        if (attempt > this.waitForRestartLimit) {
            this.logger.error("Reached limit of " + this.waitForRestartLimit + ", and MarkLogic has not restarted yet; check MarkLogic status");
            return;
        }
        try {
            Thread.sleep(this.waitForRestartCheckInterval);
            this.getLastRestartTimestamp();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Finished waiting for MarkLogic to restart");
            }
        }
        catch (Exception ex) {
            this.logger.info("Waiting for MarkLogic to restart, attempt: " + ++attempt);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Caught exception while waiting for MarkLogic to restart: " + ex.getMessage(), (Throwable)ex);
            }
            this.waitForRestartInternal(attempt);
        }
    }

    public void setSslFipsEnabled(final boolean enabled, final int appServicesPort) {
        final String xquery = "import module namespace admin = 'http://marklogic.com/xdmp/admin' at '/MarkLogic/admin.xqy'; admin:save-configuration(admin:cluster-set-ssl-fips-enabled(admin:get-configuration(), " + enabled + "()))";
        this.invokeActionRequiringRestart(new ActionRequiringRestart(){

            @Override
            public boolean execute() {
                RestTemplate rt = RestTemplateUtil.newRestTemplate(AdminManager.this.adminConfig.getHost(), appServicesPort, AdminManager.this.adminConfig.getUsername(), AdminManager.this.adminConfig.getPassword());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                LinkedMultiValueMap map = new LinkedMultiValueMap();
                map.add((Object)"xquery", (Object)xquery);
                HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
                String url = AdminManager.this.format("http://%s:%d/v1/eval", new Object[]{AdminManager.this.adminConfig.getHost(), appServicesPort});
                if (AdminManager.this.logger.isInfoEnabled()) {
                    AdminManager.this.logger.info("Setting SSL FIPS enabled: " + enabled);
                }
                rt.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
                if (AdminManager.this.logger.isInfoEnabled()) {
                    AdminManager.this.logger.info("Finished setting SSL FIPS enabled: " + enabled);
                }
                return true;
            }
        });
    }

    public Fragment getServerConfig() {
        return new Fragment((String)this.restTemplate.getForObject(this.adminConfig.buildUri("/admin/v1/server-config"), String.class), new Namespace[0]);
    }

    public String getServerVersion() {
        return this.getServerConfig().getElementValue("/m:host/m:version");
    }

    public void setWaitForRestartCheckInterval(int waitForRestartCheckInterval) {
        this.waitForRestartCheckInterval = waitForRestartCheckInterval;
    }

    public void setWaitForRestartLimit(int waitForRestartLimit) {
        this.waitForRestartLimit = waitForRestartLimit;
    }

    public byte[] postJoiningHostConfig(Fragment joiningHostConfig, String group, String zone) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"group", (Object)group);
        if (zone != null && !zone.isEmpty()) {
            map.add((Object)"zone", (Object)zone);
        }
        map.add((Object)"server-config", (Object)joiningHostConfig.getPrettyXml());
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        URI url = this.adminConfig.buildUri("/admin/v1/cluster-config");
        ResponseEntity bytes = this.restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class);
        return (byte[])bytes.getBody();
    }

    public void postClustConfigToJoiningHost(byte[] clusterConfigZipBytes) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-type", "application/zip");
        URI clusterConfigUri = this.adminConfig.buildUri("/admin/v1/cluster-config");
        HttpEntity resourceEntity = new HttpEntity((Object)new ByteArrayResource(clusterConfigZipBytes), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(clusterConfigUri, HttpMethod.POST, resourceEntity, String.class);
        if (response.getStatusCode().value() == 202) {
            this.waitForRestart();
        }
    }

    public void leaveCluster() {
        ResponseEntity response = this.restTemplate.exchange(this.adminConfig.buildUri("/admin/v1/host-config"), HttpMethod.DELETE, null, String.class);
        if (response.getStatusCode().value() == 202) {
            this.waitForRestart();
        }
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

