/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt;

import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.ManageConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.PropertySourceFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.util.StringUtils;

public class DefaultManageConfigFactory
extends PropertySourceFactory
implements ManageConfigFactory {
    private Map<String, BiConsumer<ManageConfig, String>> propertyConsumerMap;

    public DefaultManageConfigFactory() {
        this.initialize();
    }

    public DefaultManageConfigFactory(PropertySource propertySource) {
        super(propertySource);
        this.initialize();
    }

    public void initialize() {
        this.propertyConsumerMap = new LinkedHashMap<String, BiConsumer<ManageConfig, String>>();
        this.propertyConsumerMap.put("mlManageHost", (config, prop) -> {
            this.logger.info("Manage host: " + prop);
            config.setHost((String)prop);
        });
        this.propertyConsumerMap.put("mlHost", (config, prop) -> {
            if (!this.propertyExists("mlManageHost")) {
                this.logger.info("Manage host: " + prop);
                config.setHost((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePort", (config, prop) -> {
            this.logger.info("Manage port: " + prop);
            config.setPort(Integer.parseInt(prop));
        });
        this.propertyConsumerMap.put("mlManageUsername", (config, prop) -> {
            this.logger.info("Manage username: " + prop);
            config.setUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlUsername", (config, prop) -> {
            if (!this.propertyExists("mlManageUsername")) {
                this.logger.info("Manage username: " + prop);
                config.setUsername((String)prop);
            }
            if (!this.propertyExists("mlSecurityUsername") && !this.propertyExists("mlAdminUsername")) {
                this.logger.info("Manage user with security role: " + prop);
                config.setSecurityUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePassword", (config, prop) -> config.setPassword((String)prop));
        this.propertyConsumerMap.put("mlPassword", (config, prop) -> {
            if (!this.propertyExists("mlManagePassword")) {
                config.setPassword((String)prop);
            }
            if (!this.propertyExists("mlSecurityPassword") && !this.propertyExists("mlAdminPassword")) {
                config.setSecurityPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManageScheme", (config, prop) -> {
            this.logger.info("Manage scheme: " + prop);
            config.setScheme((String)prop);
        });
        this.propertyConsumerMap.put("mlManageSimpleSsl", (config, prop) -> {
            this.logger.info("Use simple SSL for Manage app server: " + prop);
            config.setConfigureSimpleSsl(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlManageSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for Manage app server: " + prop);
            config.setSslProtocol((String)prop);
        });
        this.propertyConsumerMap.put("mlManageUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for Manage app server: " + prop);
            config.setUseDefaultKeystore(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlManageTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for Manage app server: " + prop);
            config.setTrustManagementAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlManageCleanJsonPayloads", (config, prop) -> {
            this.logger.info("Cleaning Management API JSON payloads: " + prop);
            config.setCleanJsonPayloads(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAdminUsername", (config, prop) -> {
            this.logger.info("mlAdminUsername is deprecated; please use mlSecurityUsername instead; Manage user with security role: " + prop);
            config.setSecurityUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminPassword", (config, prop) -> {
            this.logger.info("mlAdminPassword is deprecated; please use mlSecurityPassword instead");
            config.setSecurityPassword((String)prop);
        });
        this.propertyConsumerMap.put("mlSecurityUsername", (config, prop) -> {
            this.logger.info("Manage user with security role: " + prop);
            config.setSecurityUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlSecurityPassword", (config, prop) -> config.setSecurityPassword((String)prop));
    }

    @Override
    public ManageConfig newManageConfig() {
        ManageConfig config = new ManageConfig();
        for (String propertyName : this.propertyConsumerMap.keySet()) {
            String value = this.getProperty(propertyName);
            if (value == null) continue;
            this.propertyConsumerMap.get(propertyName).accept(config, value);
        }
        if (!StringUtils.hasText((String)config.getSecurityUsername())) {
            config.setSecurityUsername(config.getUsername());
        }
        if (!StringUtils.hasText((String)config.getSecurityPassword())) {
            config.setSecurityPassword(config.getPassword());
        }
        return config;
    }

    public Map<String, BiConsumer<ManageConfig, String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }
}

