/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.util;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.DefaultAppConfigFactory;
import com.marklogic.appdeployer.command.modules.DefaultModulesLoaderFactory;
import com.marklogic.appdeployer.command.modules.ModulesLoaderFactory;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.mgmt.util.SystemPropertySource;
import java.util.List;

public class ModulesWatcher
extends LoggingObject
implements Runnable {
    private long sleepTime = 1000L;
    private AppConfig appConfig;
    private ModulesLoaderFactory modulesLoaderFactory;

    public ModulesWatcher(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.modulesLoaderFactory = new DefaultModulesLoaderFactory();
    }

    public static void startFromSystemProps() {
        ModulesWatcher mw = new ModulesWatcher(new DefaultAppConfigFactory(new SystemPropertySource()).newAppConfig());
        new Thread(mw).start();
    }

    @Override
    public void run() {
        ModulesLoader loader = this.modulesLoaderFactory.newModulesLoader(this.appConfig);
        if (loader instanceof DefaultModulesLoader) {
            ((DefaultModulesLoader)loader).setCatchExceptions(true);
        }
        DatabaseClient client = this.appConfig.newDatabaseClient();
        List<String> paths = this.appConfig.getModulePaths();
        DefaultModulesFinder finder = new DefaultModulesFinder();
        while (true) {
            for (String modulesPath : paths) {
                loader.loadModules(modulesPath, (ModulesFinder)finder, client);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public ModulesLoaderFactory getModulesLoaderFactory() {
        return this.modulesLoaderFactory;
    }

    public void setModulesLoaderFactory(ModulesLoaderFactory modulesLoaderFactory) {
        this.modulesLoaderFactory = modulesLoaderFactory;
    }
}

