/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.viewschemas;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.viewschemas.ViewManager;
import com.marklogic.mgmt.resource.viewschemas.ViewSchemaManager;
import java.io.File;

public class DeployViewSchemasCommand
extends AbstractResourceCommand {
    private String currentDatabaseIdOrName;
    private ViewSchemaManager currentViewSchemaManager;

    public DeployViewSchemasCommand() {
        this.setDeleteResourcesOnUndo(false);
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_SQL_VIEWS);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployViewSchemas(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployViewSchemas(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployViewSchemas(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentDatabaseIdOrName = databaseIdOrName;
        this.currentViewSchemaManager = new ViewSchemaManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getViewSchemasDir());
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return null;
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentViewSchemaManager;
    }

    @Override
    protected void afterResourceSaved(ResourceManager mgr, CommandContext context, ResourceReference reference, SaveReceipt receipt) {
        if (reference != null) {
            File resourceFile = reference.getLastFile();
            PayloadParser parser = new PayloadParser();
            String viewSchemaName = parser.getPayloadFieldValue(receipt.getPayload(), "view-schema-name");
            File viewDir = new File(resourceFile.getParentFile(), viewSchemaName + "-views");
            if (viewDir.exists()) {
                ViewManager viewMgr = new ViewManager(context.getManageClient(), this.currentDatabaseIdOrName, viewSchemaName);
                for (File viewFile : this.listFilesInDirectory(viewDir)) {
                    this.saveResource((ResourceManager)viewMgr, context, viewFile);
                }
            }
        } else {
            this.logger.info("No ResourceReference provided in afterResourceSaved, so unable to create views associated with view schema");
        }
    }
}

