/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.temporal;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.temporal.TemporalAxesManager;
import java.io.File;

public class DeployTemporalAxesCommand
extends AbstractResourceCommand {
    private TemporalAxesManager currentTemporalAxesManager;

    public DeployTemporalAxesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_TEMPORAL_AXIS);
        this.setDeleteResourcesOnUndo(false);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployTemporalAxes(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployTemporalAxes(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployTemporalAxes(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentTemporalAxesManager = new TemporalAxesManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getTemporalAxesDir());
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return null;
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentTemporalAxesManager;
    }
}

