/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.schemas;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ext.schemasloader.SchemasLoader;
import com.marklogic.client.ext.schemasloader.impl.DefaultSchemasLoader;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import java.io.File;
import java.io.FileFilter;
import java.util.List;

public class LoadSchemasCommand
extends AbstractCommand {
    public LoadSchemasCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_SCHEMAS);
    }

    @Override
    public void execute(CommandContext context) {
        this.loadSchemasFromSchemaPaths(context);
        this.loadSchemasFromDatabaseSpecificPaths(context);
    }

    protected void loadSchemasFromSchemaPaths(CommandContext context) {
        AppConfig config = context.getAppConfig();
        List<String> schemaPaths = config.getSchemaPaths();
        if (schemaPaths != null && !schemaPaths.isEmpty()) {
            for (String path : schemaPaths) {
                this.loadSchemas(path, config.getSchemasDatabaseName(), context);
            }
        }
    }

    protected void loadSchemasFromDatabaseSpecificPaths(CommandContext context) {
        context.getAppConfig().getConfigDirs().forEach(configDir -> configDir.getDatabaseResourceDirectories().forEach(dir -> {
            File schemasDir = new File((File)dir, "schemas");
            if (schemasDir.exists()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, (ConfigDir)configDir, (File)dir);
                this.loadSchemas(schemasDir.getAbsolutePath(), databaseName, context);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSchemas(String schemasPath, String schemasDatabaseName, CommandContext context) {
        block6: {
            this.logger.info(this.format("Loading schemas into database %s from: %s", new Object[]{schemasDatabaseName, schemasPath}));
            DatabaseClient client = this.buildDatabaseClient(schemasDatabaseName, context);
            try {
                SchemasLoader schemasLoader = this.buildSchemasLoader(context, client, schemasDatabaseName);
                schemasLoader.loadSchemas(new String[]{schemasPath});
                this.logger.info("Finished loading schemas from: " + schemasPath);
            }
            catch (FailedRequestException fre) {
                if (fre.getMessage().contains("NOSUCHDB")) {
                    this.logger.warn("Unable to load schemas because no schemas database exists; cause: " + fre.getMessage());
                    break block6;
                }
                throw fre;
            }
            finally {
                client.release();
            }
        }
    }

    protected DatabaseClient buildDatabaseClient(String schemasDatabaseName, CommandContext context) {
        return context.getAppConfig().newAppServicesDatabaseClient(schemasDatabaseName);
    }

    protected SchemasLoader buildSchemasLoader(CommandContext context, DatabaseClient client, String schemasDatabaseName) {
        AppConfig appConfig = context.getAppConfig();
        String tdeValidationDatabase = null;
        if (appConfig.isTdeValidationEnabled()) {
            tdeValidationDatabase = this.findContentDatabaseAssociatedWithSchemasDatabase(context, schemasDatabaseName);
            if (tdeValidationDatabase != null) {
                this.logger.info(this.format("TDE templates loaded into %s will be validated against content database %s", new Object[]{schemasDatabaseName, tdeValidationDatabase}));
            }
        } else {
            this.logger.info("TDE validation is disabled");
        }
        DefaultSchemasLoader schemasLoader = new DefaultSchemasLoader(client, tdeValidationDatabase);
        FileFilter filter = appConfig.getSchemasFileFilter();
        if (filter != null) {
            schemasLoader.addFileFilter(filter);
        }
        if (appConfig.isReplaceTokensInModules()) {
            schemasLoader.setTokenReplacer(appConfig.buildTokenReplacer());
        }
        return schemasLoader;
    }

    protected String findContentDatabaseAssociatedWithSchemasDatabase(CommandContext context, String schemasDatabaseName) {
        String tdeValidationDatabase = null;
        DefaultResourceMapper resourceMapper = new DefaultResourceMapper(new API(context.getManageClient()));
        block2: for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dbDir = configDir.getDatabasesDir();
            if (dbDir == null || !dbDir.exists()) continue;
            for (File f : this.listFilesInDirectory(dbDir)) {
                String payload = this.copyFileToString(f, context);
                try {
                    Database db = resourceMapper.readResource(payload, Database.class);
                    if (!schemasDatabaseName.equals(db.getSchemaDatabase())) continue;
                    tdeValidationDatabase = db.getDatabaseName();
                    continue block2;
                }
                catch (Exception ex) {
                    this.logger.warn("Unexpected error when reading database file to determine database for TDE validation: " + ex.getMessage());
                }
            }
        }
        return tdeValidationDatabase;
    }
}

