/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.rebalancer;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.rebalancer.PartitionManager;
import java.io.File;

public class DeployPartitionsCommand
extends AbstractResourceCommand {
    private PartitionManager currentPartitionManager;

    public DeployPartitionsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_PARTITIONS);
        this.setDeleteResourcesOnUndo(false);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployPartitions(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployPartitions(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentPartitionManager = new PartitionManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getPartitionsDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentPartitionManager;
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getPartitionsDir());
    }
}

