/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.forests.HostCalculator;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.resource.hosts.HostNameProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultHostCalculator
extends LoggingObject
implements HostCalculator {
    private HostNameProvider hostNameProvider;

    public DefaultHostCalculator(HostNameProvider hostNameProvider) {
        this.hostNameProvider = hostNameProvider;
    }

    @Override
    public List<String> calculateHostNames(String databaseName, CommandContext context) {
        List<String> hostNames;
        List<String> hostNamesFromDatabaseHosts;
        List<String> hostNamesFromDatabaseGroups = this.determineHostsNamesBasedOnDatabaseGroups(databaseName, context);
        if (hostNamesFromDatabaseGroups != null) {
            if (hostNamesFromDatabaseGroups.size() > 1 && context.getAppConfig().isDatabaseWithForestsOnOneHost(databaseName)) {
                return hostNamesFromDatabaseGroups.subList(0, 1);
            }
            return hostNamesFromDatabaseGroups;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finding eligible hosts for forests for database: " + databaseName);
        }
        if ((hostNamesFromDatabaseHosts = this.determineHostNamesBasedOnDatabaseHosts(databaseName, context, hostNames = this.hostNameProvider.getHostNames())) != null) {
            return hostNamesFromDatabaseHosts;
        }
        return hostNames;
    }

    protected List<String> determineHostsNamesBasedOnDatabaseGroups(String databaseName, CommandContext context) {
        List<String> selectedGroupNames;
        Map<String, List<String>> databaseGroups = context.getAppConfig().getDatabaseGroups();
        if (databaseGroups != null && (selectedGroupNames = databaseGroups.get(databaseName)) != null) {
            List<String> set;
            ArrayList<String> selectedHostNames = new ArrayList<String>();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests on hosts in groups %s for database '%s'", new Object[]{selectedGroupNames, databaseName}));
            }
            for (String groupName : selectedGroupNames) {
                List<String> groupHostNames = this.hostNameProvider.getGroupHostNames(groupName);
                if (groupHostNames != null && !groupHostNames.isEmpty()) {
                    for (String hostName : groupHostNames) {
                        if (selectedHostNames.contains(hostName)) continue;
                        selectedHostNames.add(hostName);
                    }
                    continue;
                }
                this.logger.warn("No hosts found for group: " + groupName);
            }
            Map<String, List<String>> databaseHosts = context.getAppConfig().getDatabaseHosts();
            if (databaseHosts != null && (set = databaseHosts.get(databaseName)) != null && !set.isEmpty()) {
                this.logger.warn(this.format("Database groups and database hosts were both specified for database '%s'; only database groups are being used, database hosts will be ignored.", new Object[]{databaseName}));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests on hosts %s based on groups %s for database '%s'", new Object[]{selectedHostNames, selectedGroupNames, databaseName}));
            }
            return selectedHostNames;
        }
        return null;
    }

    protected List<String> determineHostNamesBasedOnDatabaseHosts(String databaseName, CommandContext context, List<String> hostNames) {
        List<String> databaseHostNames;
        Map<String, List<String>> databaseHosts = context.getAppConfig().getDatabaseHosts();
        if (databaseHosts != null && (databaseHostNames = databaseHosts.get(databaseName)) != null) {
            ArrayList<String> selectedHostNames = new ArrayList<String>();
            for (String name : databaseHostNames) {
                if (hostNames.contains(name)) {
                    selectedHostNames.add(name);
                    continue;
                }
                this.logger.warn(this.format("Host '%s' for database '%s' is not recognized, ignoring", new Object[]{name, databaseName}));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests for database '%s' on hosts: %s", new Object[]{databaseName, selectedHostNames}));
            }
            return selectedHostNames;
        }
        return null;
    }
}

