/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.flexrep;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.flexrep.TargetManager;
import java.io.File;

public class DeployTargetsCommand
extends AbstractCommand {
    private String targetDirectorySuffix = "-targets";
    private TargetManager mgr;

    public DeployTargetsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FLEXREP_TARGETS);
        this.setStoreResourceIdsAsCustomTokens(true);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployTargets(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployTargets(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployTargets(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        File configsDir = configDir.getFlexrepConfigsDir();
        if (configsDir != null && configsDir.exists()) {
            for (File f : configsDir.listFiles()) {
                if (!f.isDirectory() || !f.getName().endsWith(this.targetDirectorySuffix)) continue;
                this.deployTargetsInDirectory(f, context, databaseIdOrName);
            }
        } else {
            this.logResourceDirectoryNotFound(configsDir);
        }
    }

    protected void deployTargetsInDirectory(File dir, CommandContext context, String databaseIdOrName) {
        String configName = this.extractConfigNameFromDirectory(dir);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deploying flexrep targets with config name '%s' in directory: %s", new Object[]{configName, dir.getAbsolutePath()}));
        }
        this.mgr = new TargetManager(context.getManageClient(), databaseIdOrName, configName);
        for (File f : this.listFilesInDirectory(dir)) {
            SaveReceipt saveReceipt = this.saveResource((ResourceManager)this.mgr, context, f);
        }
    }

    @Override
    protected void storeTokenForResourceId(SaveReceipt receipt, CommandContext context) {
        String targetId = this.mgr.getTargetId(receipt.getResourceId());
        String key = "%%flexrep-targets-id-" + receipt.getResourceId() + "%%";
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Storing token with key '%s' and value '%s'", new Object[]{key, targetId}));
        }
        context.getAppConfig().getCustomTokens().put(key, targetId);
    }

    protected String extractConfigNameFromDirectory(File dir) {
        String name = dir.getName();
        return name.substring(0, name.length() - this.targetDirectorySuffix.length());
    }

    public void setTargetDirectorySuffix(String targetDirectorySuffix) {
        this.targetDirectorySuffix = targetDirectorySuffix;
    }
}

