/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.flexrep;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.flexrep.ConfigManager;
import java.io.File;

public class DeployConfigsCommand
extends AbstractResourceCommand {
    private ConfigManager currentConfigManager;

    public DeployConfigsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FLEXREP_CONFIGS);
        this.setDeleteResourcesOnUndo(false);
        this.setStoreResourceIdsAsCustomTokens(true);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployConfigs(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployConfigs(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployConfigs(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentConfigManager = new ConfigManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getFlexrepConfigsDir());
    }

    @Override
    protected void storeTokenForResourceId(SaveReceipt receipt, CommandContext context) {
        String targetId = this.currentConfigManager.getDomainId(receipt.getResourceId());
        String key = "%%flexrep-domains-id-" + receipt.getResourceId() + "%%";
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Storing token with key '%s' and value '%s'", new Object[]{key, targetId}));
        }
        context.getAppConfig().getCustomTokens().put(key, targetId);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return null;
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentConfigManager;
    }
}

