/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.cli;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.DefaultAppConfigFactory;
import com.marklogic.appdeployer.cli.CommandArray;
import com.marklogic.appdeployer.cli.CommandWrapper;
import com.marklogic.appdeployer.cli.DeployCommand;
import com.marklogic.appdeployer.cli.Options;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandMapBuilder;
import com.marklogic.appdeployer.impl.SimpleAppDeployer;
import com.marklogic.mgmt.DefaultManageConfigFactory;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.admin.DefaultAdminConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.SimplePropertySource;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        JCommander.Builder builder = JCommander.newBuilder().addObject((Object)options);
        Main.addCommandsToBuilder(builder);
        JCommander commander = builder.build();
        commander.setProgramName("java -jar <name of jar>");
        commander.parse(args);
        String parsedCommand = commander.getParsedCommand();
        if (parsedCommand == null) {
            if (options.isPrintProperties()) {
                Main.printProperties();
            } else {
                commander.usage();
            }
        } else {
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
            root.setLevel(Level.toLevel((String)options.getLogLevel()));
            JCommander parsedCommander = (JCommander)commander.getCommands().get(parsedCommand);
            CommandArray commandArray = (CommandArray)parsedCommander.getObjects().get(0);
            PropertySource propertySource = Main.buildPropertySource(options);
            Main.runCommand(commandArray, propertySource, options);
        }
    }

    private static void addCommandsToBuilder(JCommander.Builder builder) {
        CommandMapBuilder commandMapBuilder = new CommandMapBuilder();
        Map<String, List<Command>> commandMap = commandMapBuilder.buildCommandMap();
        TreeMap<Object, CommandArray> orderedCommandMap = new TreeMap<Object, CommandArray>();
        orderedCommandMap.put("mlDeploy", new DeployCommand(commandMap));
        for (String commandGroup : commandMap.keySet()) {
            for (Command command : commandMap.get(commandGroup)) {
                String className = command.getClass().getSimpleName();
                if (className.endsWith("Command")) {
                    className = className.substring(0, className.length() - "Command".length());
                }
                orderedCommandMap.put("ml" + className, new CommandWrapper(command));
            }
        }
        for (String commandName : orderedCommandMap.keySet()) {
            builder.addCommand(commandName, orderedCommandMap.get(commandName), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertySource buildPropertySource(Options options) throws IOException {
        String propertiesFilePath = options.getPropertiesFilePath();
        if (propertiesFilePath != null) {
            Properties props = new Properties();
            if (logger.isInfoEnabled()) {
                logger.info("Reading properties from file path: " + propertiesFilePath);
            }
            try (FileInputStream fis = new FileInputStream(propertiesFilePath);){
                props.load(fis);
            }
            Map<String, String> params = options.getParams();
            if (params != null) {
                for (String key : params.keySet()) {
                    props.setProperty(key, params.get(key));
                }
            }
            return new SimplePropertySource(props);
        }
        return name -> options.getParams().get(name);
    }

    private static void printProperties() {
        System.out.println("\nManage server connection properties");
        for (String name : new TreeSet<String>(new DefaultManageConfigFactory().getPropertyConsumerMap().keySet())) {
            System.out.println(" - " + name);
        }
        System.out.println("\nAdmin server connection properties");
        for (String name : new TreeSet<String>(new DefaultAdminConfigFactory().getPropertyConsumerMap().keySet())) {
            System.out.println(" - " + name);
        }
        System.out.println("\nApplication properties");
        for (String name : new TreeSet<String>(new DefaultAppConfigFactory().getPropertyConsumerMap().keySet())) {
            System.out.println(" - " + name);
        }
    }

    private static void runCommand(CommandArray commandArray, PropertySource propertySource, Options options) {
        AppConfig appConfig = new DefaultAppConfigFactory(propertySource).newAppConfig();
        ManageConfig manageConfig = new DefaultManageConfigFactory(propertySource).newManageConfig();
        ManageClient manageClient = new ManageClient(manageConfig);
        AdminConfig adminConfig = new DefaultAdminConfigFactory(propertySource).newAdminConfig();
        AdminManager adminManager = new AdminManager(adminConfig);
        SimpleAppDeployer deployer = new SimpleAppDeployer(manageClient, adminManager, commandArray.getCommands());
        if (options.isUndo()) {
            deployer.undeploy(appConfig);
        } else {
            deployer.deploy(appConfig);
        }
    }
}

