package com.marklogic.appdeployer.export.triggers;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.impl.AbstractNamedResourceExporter;
import com.marklogic.appdeployer.export.impl.ExportInputs;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.triggers.TriggerManager;

import java.io.File;

public class TriggerExporter extends AbstractNamedResourceExporter {

	private String databaseIdOrName;

	public TriggerExporter(ManageClient manageClient, String databaseIdOrName, String... triggerNames) {
		super(manageClient, triggerNames);
		this.databaseIdOrName = databaseIdOrName;
	}

	@Override
	protected String[] getExportMessages() {
		return new String[]{"Each exported trigger has the 'id' field removed from it, as that field should be generated by MarkLogic."};
	}

	@Override
	protected String beforeResourceWrittenToFile(ExportInputs exportInputs, String payload) {
		return removeJsonKeyFromPayload(payload, "id");
	}

	@Override
	protected ResourceManager newResourceManager(ManageClient manageClient) {
		return new TriggerManager(manageClient, databaseIdOrName);
	}

	@Override
	protected File getResourceDirectory(File baseDir) {
		return new ConfigDir(baseDir).getTriggersDir();
	}

}
