/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.test.unit;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.test.unit.JUnitTestSuite;
import com.marklogic.test.unit.JaxpServiceResponseUnmarshaller;
import com.marklogic.test.unit.ServiceResponseUnmarshaller;
import com.marklogic.test.unit.TestModule;
import com.marklogic.test.unit.TestSuiteResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TestManager
extends ResourceManager {
    public static final String FORMAT_JUNIT = "junit";
    public static final String FORMAT_NONE = "";
    private ServiceResponseUnmarshaller unitTestXmlParser;

    public TestManager(DatabaseClient client) {
        this(client, new JaxpServiceResponseUnmarshaller());
    }

    public TestManager(DatabaseClient client, ServiceResponseUnmarshaller unitTestXmlParser) {
        this.unitTestXmlParser = unitTestXmlParser;
        client.init("marklogic-unit-test", (ResourceManager)this);
    }

    public List<TestModule> list() {
        RequestParameters params = new RequestParameters();
        params.add("func", "list");
        String xml = ((StringHandle)this.getServices().get(params, (AbstractReadHandle)new StringHandle())).get();
        return this.unitTestXmlParser.parseTestList(xml);
    }

    public List<String> listSuites() {
        List<TestModule> testModules = this.list();
        ArrayList<String> suites = new ArrayList<String>();
        for (TestModule testModule : testModules) {
            String suite = testModule.getSuite();
            if (suites.contains(suite)) continue;
            suites.add(suite);
        }
        return suites;
    }

    public TestSuiteResult run(TestModule testModule) {
        return this.run(testModule, true, true, false);
    }

    public TestSuiteResult run(TestModule testModule, boolean runTeardown, boolean runSuiteTeardown, boolean calculateCoverage) {
        RequestParameters params = new RunParameters().withTestNames(testModule.getTest()).withFormat(FORMAT_NONE).withRunSuiteTeardown(runSuiteTeardown).withRunTeardown(runTeardown).withCalculateCoverage(calculateCoverage).toRequestParameters(testModule.getSuite());
        String xml = ((StringHandle)this.getServices().post(params, (AbstractWriteHandle)null, (AbstractReadHandle)new StringHandle())).get();
        return this.unitTestXmlParser.parseTestSuiteResult(xml);
    }

    public List<JUnitTestSuite> runAllSuites() {
        return this.runAllSuites(new RunParameters());
    }

    @Deprecated
    public List<JUnitTestSuite> runAllSuites(boolean runTeardown, boolean runSuiteTeardown, boolean calculateCoverage) {
        List<String> suiteNames = this.listSuites();
        ArrayList<JUnitTestSuite> suites = new ArrayList<JUnitTestSuite>();
        for (String suiteName : suiteNames) {
            suites.add(this.runSuite(suiteName, runTeardown, runSuiteTeardown, calculateCoverage));
        }
        return suites;
    }

    public JUnitTestSuite runSuite(String suite) {
        return this.runSuite(suite, new RunParameters());
    }

    @Deprecated
    public JUnitTestSuite runSuite(String suite, boolean runTeardown, boolean runSuiteTeardown, boolean calculateCoverage) {
        RequestParameters params = new RunParameters().withFormat(FORMAT_JUNIT).withRunSuiteTeardown(runSuiteTeardown).withRunTeardown(runTeardown).withCalculateCoverage(calculateCoverage).toRequestParameters(suite);
        String xml = ((StringHandle)this.getServices().post(params, (AbstractWriteHandle)null, (AbstractReadHandle)new StringHandle())).get();
        return this.unitTestXmlParser.parseJUnitTestSuiteResult(xml);
    }

    public JUnitTestSuite runSuite(String suiteName, RunParameters params) {
        String xml = ((StringHandle)this.getServices().post(params.toRequestParameters(suiteName), (AbstractWriteHandle)null, (AbstractReadHandle)new StringHandle())).get();
        return this.unitTestXmlParser.parseJUnitTestSuiteResult(xml);
    }

    public List<JUnitTestSuite> runAllSuites(RunParameters params) {
        return this.listSuites().stream().map(suite -> this.runSuite((String)suite, params)).collect(Collectors.toList());
    }

    public List<JUnitTestSuite> runSuites(List<String> suiteNames, RunParameters params) {
        return suiteNames.stream().map(suiteName -> this.runSuite((String)suiteName, params)).collect(Collectors.toList());
    }

    public void setUnitTestXmlParser(ServiceResponseUnmarshaller unitTestXmlParser) {
        this.unitTestXmlParser = unitTestXmlParser;
    }

    public static class RunParameters {
        private String[] testNames;
        private boolean runSuiteTeardown = true;
        private boolean runTeardown = true;
        private boolean calculateCoverage = false;
        private String format = "junit";

        public RunParameters() {
        }

        public RunParameters(String ... testNames) {
            this();
            this.withTestNames(testNames);
        }

        public RunParameters withTestNames(String ... testNames) {
            this.testNames = testNames;
            return this;
        }

        public RunParameters withFormat(String format) {
            this.format = format;
            return this;
        }

        public RunParameters withRunSuiteTeardown(boolean runSuiteTeardown) {
            this.runSuiteTeardown = runSuiteTeardown;
            return this;
        }

        public RunParameters withRunTeardown(boolean runTeardown) {
            this.runTeardown = runTeardown;
            return this;
        }

        public RunParameters withCalculateCoverage(boolean calculateCoverage) {
            this.calculateCoverage = calculateCoverage;
            return this;
        }

        public RequestParameters toRequestParameters(String suiteName) {
            RequestParameters params = new RequestParameters();
            params.add("run", "func");
            if (suiteName != null) {
                params.add("suite", suiteName);
            }
            if (this.format != null) {
                params.add("format", this.format);
            }
            if (this.testNames != null) {
                params.add("tests", Stream.of(this.testNames).collect(Collectors.joining(",")));
            }
            params.add("runsuiteteardown", String.valueOf(this.runSuiteTeardown));
            params.add("runteardown", String.valueOf(this.runTeardown));
            params.add("calculatecoverage", String.valueOf(this.calculateCoverage));
            return params;
        }
    }
}

