/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.test.unit;

import com.marklogic.test.unit.JUnitTestCase;
import java.util.ArrayList;
import java.util.List;

public class JUnitTestSuite {
    private String xml;
    private int errors;
    private int failures;
    private String hostname;
    private String name;
    private int tests;
    private double time;
    private List<JUnitTestCase> testCases;

    public JUnitTestSuite(String xml, int errors, int failures, String hostname, String name, int tests, double time) {
        this.xml = xml;
        this.errors = errors;
        this.failures = failures;
        this.hostname = hostname;
        this.name = name;
        this.tests = tests;
        this.time = time;
    }

    public void addTestCase(JUnitTestCase testCase) {
        if (this.testCases == null) {
            this.testCases = new ArrayList<JUnitTestCase>();
        }
        this.testCases.add(testCase);
    }

    public boolean hasTestFailures() {
        if (this.testCases == null) {
            return false;
        }
        for (JUnitTestCase testCase : this.testCases) {
            if (!testCase.hasTestFailures()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("[name: %s, tests: %d, errors: %d, failures: %d, hostname: %s, time: %f, testCases: %s]", this.name, this.tests, this.errors, this.failures, this.hostname, this.time, this.testCases);
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getName() {
        return this.name;
    }

    public int getTests() {
        return this.tests;
    }

    public double getTime() {
        return this.time;
    }

    public List<JUnitTestCase> getTestCases() {
        return this.testCases;
    }

    public String getXml() {
        return this.xml;
    }
}

