<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet extension-element-prefixes="xdmp" xdmp:dialect="1.0-ml" version="1.0" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdmp="http://marklogic.com/xdmp" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:es="http://marklogic.com/entity-services">
  <!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
  <xsl:param name="archiveDirParameter"/>
  <xsl:param name="archiveNameParameter"/>
  <xsl:param name="fileNameParameter"/>
  <xsl:param name="fileDirParameter"/>
  <xsl:variable name="document-uri"><xsl:value-of select="document-uri(/)"/></xsl:variable>
  <!--PHASES-->
  <!--PROLOG-->
  <xsl:output method="xml" omit-xml-declaration="no" standalone="yes" indent="yes" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>
  <!--XSD TYPES FOR XSLT2-->
  <!--KEYS AND FUNCTIONS-->
  <!--DEFAULT RULES-->
  <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
  <!--This mode can be used to generate an ugly though full XPath for locators-->
  <xsl:template match="*|/|object-node()" mode="schematron-select-full-path"><xsl:apply-templates select="." mode="schematron-get-full-path"/></xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-->
  <!--This mode can be used to generate an ugly though full XPath for locators-->
  <xsl:template match="*|/|object-node()" mode="schematron-get-full-path"><xsl:value-of select="xdmp:path(.)"/></xsl:template>
  <xsl:template match="@*" mode="schematron-get-full-path"><xsl:value-of select="xdmp:path(.)"/></xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-2-->
  <!--This mode can be used to generate prefixed XPath for humans-->
  <xsl:template match="node() | @*" mode="schematron-get-full-path-2"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-3-->
  <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
  <xsl:template match="node() | @*" mode="schematron-get-full-path-3"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="parent::*"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>
  <!--MODE: GENERATE-ID-FROM-PATH -->
  <xsl:template match="/" mode="generate-id-from-path"/>
  <xsl:template match="text()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/></xsl:template>
  <xsl:template match="comment()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/></xsl:template>
  <xsl:template match="processing-instruction()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/></xsl:template>
  <xsl:template match="@*" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.@', name())"/></xsl:template>
  <xsl:template match="*" mode="generate-id-from-path" priority="-0.5"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:text>.</xsl:text><xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/></xsl:template>
  <!--MODE: GENERATE-ID-2 -->
  <xsl:template match="/" mode="generate-id-2">U</xsl:template>
  <xsl:template match="*" mode="generate-id-2" priority="2"><xsl:text>U</xsl:text><xsl:number level="multiple" count="*"/></xsl:template>
  <xsl:template match="node()" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>n</xsl:text><xsl:number count="node()"/></xsl:template>
  <xsl:template match="@*" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>_</xsl:text><xsl:value-of select="string-length(local-name(.))"/><xsl:text>_</xsl:text><xsl:value-of select="translate(name(),':','.')"/></xsl:template>
  <!--Strip characters-->
  <xsl:template match="text()|number-node()|boolean-node()|null-node()" priority="-1"/>
  <!--SCHEMA SETUP-->
  <xsl:template match="/"><svrl:schematron-output title="" schemaVersion="" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:comment><xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/></xsl:comment><svrl:ns-prefix-in-attribute-values uri="http://marklogic.com/entity-services" prefix="es"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates select="/" mode="M1"/></svrl:schematron-output></xsl:template>
  <!--SCHEMATRON PATTERNS-->
  <!--PATTERN -->
  <!--RULE -->
  <xsl:template match="es:model|/object-node()" priority="1025" mode="M1"><svrl:fired-rule context="es:model|/object-node()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(es:info|info) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(es:info|info) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-INFOKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Model descriptor must contain exactly one info section.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(es:definitions|definitions) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(es:definitions|definitions) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-DEFINITIONSKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Model descriptor must contain exactly one definitions section.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:info|info" priority="1024" mode="M1"><svrl:fired-rule context="es:info|info" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(es:title|title) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(es:title|title) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-TITLEKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"info" section must be an object and contain exactly one title declaration.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(es:version|version) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(es:version|version) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-VERSIONKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"info" section must be an object and contain exactly one version declaration.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="empty(es:base-uri|baseUri) or matches(es:base-uri|baseUri, '^[a-z]+:')"/>
      <xsl:otherwise><svrl:failed-assert test="empty(es:base-uri|baseUri) or matches(es:base-uri|baseUri, '^[a-z]+:')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-BASEURI</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>If present, baseUri (es:base-uri) must be an absolute URI.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="(title|es:title) castable as xs:NCName"/>
      <xsl:otherwise><svrl:failed-assert test="(title|es:title) castable as xs:NCName" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Title must have no whitespace and must start with a letter.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="definitions|es:definitions" priority="1023" mode="M1"><svrl:fired-rule context="definitions|es:definitions" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(./*) ge 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(./*) ge 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-DEFINITIONS</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>There must be at least one entity type in a model descriptor.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:definitions/node()[es:primary-key]" priority="1022" mode="M1"><svrl:fired-rule context="es:definitions/node()[es:primary-key]" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(./es:primary-key) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(./es:primary-key) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-PRIMARYKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>For each Entity Type ('<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>'), only one primary key allowed.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="object-node()/*[primaryKey]" priority="1021" mode="M1"><svrl:fired-rule context="object-node()/*[primaryKey]" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(./primaryKey) eq 1"/>
      <xsl:otherwise><svrl:failed-assert test="count(./primaryKey) eq 1" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-PRIMARYKEY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>For each Entity Type ('<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>'), only one primary key allowed.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="properties/*" priority="1020" mode="M1"><svrl:fired-rule context="properties/*" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (./*[local-name(.) eq '$ref']) then count(./* except description) eq 1 else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (./*[local-name(.) eq '$ref']) then count(./* except description) eq 1 else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-ONLY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' has $ref as a child, so it cannot have a datatype.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (not(./*[local-name(.) eq '$ref'])) then ./datatype else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (not(./*[local-name(.) eq '$ref'])) then ./datatype else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-DATATYPE-REQUIRED</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' is not a reference, so it must have a datatype.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (exists(./node('$ref'))) then not(xs:string(node-name(.)) = xs:string(../../primaryKey)) else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (exists(./node('$ref'))) then not(xs:string(node-name(.)) = xs:string(../../primaryKey)) else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-NOT-PK</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>: A reference cannot be primary key.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="datatype|node('$ref')"/>
      <xsl:otherwise><svrl:failed-assert test="datatype|node('$ref')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-PROPERTY-IS-OBJECT</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' must be an object with either "datatype" or "$ref" as a key.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not(xs:string(node-name(.)) = root(.)/definitions/*/node-name(.) ! xs:string(.))"/>
      <xsl:otherwise><svrl:failed-assert test="not(xs:string(node-name(.)) = root(.)/definitions/*/node-name(.) ! xs:string(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-PROPERTY-TYPE-CONFLICT</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Type names and property names must be distinct ('<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>').</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:properties/*" priority="1019" mode="M1"><svrl:fired-rule context="es:properties/*" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (empty(./es:ref)) then true() else not(local-name(.) = xs:string(../../es:primary-key))"/>
      <xsl:otherwise><svrl:failed-assert test="if (empty(./es:ref)) then true() else not(local-name(.) = xs:string(../../es:primary-key))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-NOT-PK</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="local-name(.)"/><xsl:text/>:  A reference cannot be primary key.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (exists(./es:ref)) then count(./* except es:description) eq 1 else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (exists(./es:ref)) then count(./* except es:description) eq 1 else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-ONLY</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' has es:ref as a child, so it cannot have a datatype.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (not(./*[local-name(.) eq 'ref'])) then ./es:datatype else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (not(./*[local-name(.) eq 'ref'])) then ./es:datatype else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-DATATYPE-REQUIRED</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' is not a reference, so it must have a datatype.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not(local-name(.) = root(.)/es:model/es:definitions/*/local-name(.))"/>
      <xsl:otherwise><svrl:failed-assert test="not(local-name(.) = root(.)/es:model/es:definitions/*/local-name(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-PROPERTY-TYPE-CONFLICT</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Type names and property names must be distinct ('<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>')</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:ref|text('$ref')" priority="1018" mode="M1"><svrl:fired-rule context="es:ref|text('$ref')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="starts-with(xs:string(.),'#/definitions/') or matches(xs:string(.), '^[a-z]+:')"/>
      <xsl:otherwise><svrl:failed-assert test="starts-with(xs:string(.),'#/definitions/') or matches(xs:string(.), '^[a-z]+:')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-VALUE</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>es:ref (property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>') must start with "#/definitions/" or be an absolute IRI.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="replace(xs:string(.), '.*/', '') castable as xs:NCName"/>
      <xsl:otherwise><svrl:failed-assert test="replace(xs:string(.), '.*/', '') castable as xs:NCName" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-REF-VALUE</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text><xsl:text/><xsl:value-of select="."/><xsl:text/>: ref value must end with a simple name (xs:NCName).</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (starts-with(xs:string(.), '#/definitions/')) then replace(xs:string(.), '#/definitions/', '') = (root(.)/definitions/*/node-name(.) ! xs:string(.), root(.)/es:model/es:definitions/*/local-name(.)) else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (starts-with(xs:string(.), '#/definitions/')) then replace(xs:string(.), '#/definitions/', '') = (root(.)/definitions/*/node-name(.) ! xs:string(.), root(.)/es:model/es:definitions/*/local-name(.)) else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-LOCAL-REF</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Local reference <xsl:text/><xsl:value-of select="."/><xsl:text/> must resolve to local entity type.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (not(contains(xs:string(.), '#/definitions/'))) then matches(xs:string(.), '^[a-z]+:') else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (not(contains(xs:string(.), '#/definitions/'))) then matches(xs:string(.), '^[a-z]+:') else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-ABSOLUTE-REF</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Non-local reference <xsl:text/><xsl:value-of select="."/><xsl:text/> must be a valid URI.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:datatype" priority="1017" mode="M1"><svrl:fired-rule context="es:datatype" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test=". = ('anyURI', 'base64Binary' , 'boolean' , 'byte', 'date', 'dateTime', 'dayTimeDuration', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gMonthDay', 'gYear', 'gYearMonth', 'hexBinary', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'string', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort', 'yearMonthDuration', 'iri', 'array')"/>
      <xsl:otherwise><svrl:failed-assert test=". = ('anyURI', 'base64Binary' , 'boolean' , 'byte', 'date', 'dateTime', 'dayTimeDuration', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gMonthDay', 'gYear', 'gYearMonth', 'hexBinary', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'string', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort', 'yearMonthDuration', 'iri', 'array')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-UNSUPPORTED-DATATYPE</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(..))"/><xsl:text/>' has unsupported datatype: <xsl:text/><xsl:value-of select="."/><xsl:text/>.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (. eq 'array') then exists(../es:items/(es:datatype|es:ref)) else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (. eq 'array') then exists(../es:items/(es:datatype|es:ref)) else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="local-name(..)"/><xsl:text/> is of type "array" and must contain a valid "items" declaration.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (. eq 'array') then not(../es:items/es:datatype = 'array') else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (. eq 'array') then not(../es:items/es:datatype = 'array') else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="local-name(..)"/><xsl:text/> cannot both be an "array" and have items of type "array".</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not( . = ('base64Binary', 'hexBinary', 'duration', 'gMonthDay') and local-name(..) = ../../../(es:range-index|es:path-range-index|es:element-range-index)/text())"/>
      <xsl:otherwise><svrl:failed-assert test="not( . = ('base64Binary', 'hexBinary', 'duration', 'gMonthDay') and local-name(..) = ../../../(es:range-index|es:path-range-index|es:element-range-index)/text())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text><xsl:text/><xsl:value-of select="."/><xsl:text/> in property <xsl:text/><xsl:value-of select="local-name(..)"/><xsl:text/> is unsupported for a range index.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="datatype" priority="1016" mode="M1"><svrl:fired-rule context="datatype" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test=". = ('anyURI', 'base64Binary' , 'boolean' , 'byte', 'date', 'dateTime', 'dayTimeDuration', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gMonthDay', 'gYear', 'gYearMonth', 'hexBinary', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'string', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort', 'yearMonthDuration', 'iri', 'array')"/>
      <xsl:otherwise><svrl:failed-assert test=". = ('anyURI', 'base64Binary' , 'boolean' , 'byte', 'date', 'dateTime', 'dayTimeDuration', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gMonthDay', 'gYear', 'gYearMonth', 'hexBinary', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'string', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort', 'yearMonthDuration', 'iri', 'array')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="id">ES-UNSUPPORTED-DATATYPE</xsl:attribute><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property '<xsl:text/><xsl:value-of select="xs:string(node-name(.))"/><xsl:text/>' has unsupported datatype: <xsl:text/><xsl:value-of select="."/><xsl:text/>.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (. eq 'array') then exists(../items/*[string(node-name(.)) = ('$ref', 'datatype')]) else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (. eq 'array') then exists(../items/*[string(node-name(.)) = ('$ref', 'datatype')]) else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="node-name(.)"/><xsl:text/> is of type "array" and must contain a valid "items" declaration.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="if (. eq 'array') then not(../items/datatype = 'array') else true()"/>
      <xsl:otherwise><svrl:failed-assert test="if (. eq 'array') then not(../items/datatype = 'array') else true()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Property <xsl:text/><xsl:value-of select="node-name(.)"/><xsl:text/> cannot both be an "array" and have items of type "array".</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not( . = ('base64Binary', 'hexBinary', 'duration', 'gMonthDay') and string(node-name(..)) = ../../../(pathRangeIndex|elementRangeIndex|rangeIndex))"/>
      <xsl:otherwise><svrl:failed-assert test="not( . = ('base64Binary', 'hexBinary', 'duration', 'gMonthDay') and string(node-name(..)) = ../../../(pathRangeIndex|elementRangeIndex|rangeIndex))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text><xsl:text/><xsl:value-of select="."/><xsl:text/> in property <xsl:text/><xsl:value-of select="node-name(..)"/><xsl:text/> is unsupported for a range index.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:collation|collation" priority="1015" mode="M1"><svrl:fired-rule context="es:collation|collation" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="xdmp:collation-canonical-uri(.)"/>
      <xsl:otherwise><svrl:failed-assert test="xdmp:collation-canonical-uri(.)" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Collation <xsl:text/><xsl:value-of select="."/><xsl:text/> is not valid.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="primaryKey" priority="1014" mode="M1"><svrl:fired-rule context="primaryKey" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="xs:string(.) = (../properties/*/node-name() ! xs:string(.))"/>
      <xsl:otherwise><svrl:failed-assert test="xs:string(.) = (../properties/*/node-name() ! xs:string(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Primary Key <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="primary-key" priority="1013" mode="M1"><svrl:fired-rule context="primary-key" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="xs:string(.) = (../es:properties/*/local-name())"/>
      <xsl:otherwise><svrl:failed-assert test="xs:string(.) = (../es:properties/*/local-name())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Primary Key <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="required" priority="1012" mode="M1"><svrl:fired-rule context="required" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../../array-node()"/>
      <xsl:otherwise><svrl:failed-assert test="../../array-node()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>value of property 'required' must be an array.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="(.) = (../../properties/*/name())"/>
      <xsl:otherwise><svrl:failed-assert test="(.) = (../../properties/*/name())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"Required" property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="pii" priority="1011" mode="M1"><svrl:fired-rule context="pii" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../../array-node()"/>
      <xsl:otherwise><svrl:failed-assert test="../../array-node()" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>value of property 'pii' must be an array.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="(.) = (../../properties/*/name())"/>
      <xsl:otherwise><svrl:failed-assert test="(.) = (../../properties/*/name())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"pii" property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:required" priority="1010" mode="M1"><svrl:fired-rule context="es:required" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="string(.) = (../es:properties/*/local-name())"/>
      <xsl:otherwise><svrl:failed-assert test="string(.) = (../es:properties/*/local-name())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"Required" property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:pii" priority="1009" mode="M1"><svrl:fired-rule context="es:pii" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="string(.) = (../es:properties/*/local-name())"/>
      <xsl:otherwise><svrl:failed-assert test="string(.) = (../es:properties/*/local-name())" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>"Pii" property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="pathRangeIndex|elementRangeIndex|rangeIndex" priority="1008" mode="M1"><svrl:fired-rule context="pathRangeIndex|elementRangeIndex|rangeIndex" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="(.) = (../../properties/*/name(.))"/>
      <xsl:otherwise><svrl:failed-assert test="(.) = (../../properties/*/name(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Range index property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:range-index|es:path-range-index|es:element-range-index" priority="1007" mode="M1"><svrl:fired-rule context="es:range-index|es:path-range-index|es:element-range-index" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="string(.) = (../es:properties/*/local-name(.))"/>
      <xsl:otherwise><svrl:failed-assert test="string(.) = (../es:properties/*/local-name(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Range index property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="wordLexicon" priority="1006" mode="M1"><svrl:fired-rule context="wordLexicon" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="(.) = (../../properties/*/name(.))"/>
      <xsl:otherwise><svrl:failed-assert test="(.) = (../../properties/*/name(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Word lexicon property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:word-lexicon" priority="1005" mode="M1"><svrl:fired-rule context="es:word-lexicon" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="string(.) = (../es:properties/*/local-name(.))"/>
      <xsl:otherwise><svrl:failed-assert test="string(.) = (../es:properties/*/local-name(.))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Word lexicon property <xsl:text/><xsl:value-of select="."/><xsl:text/> doesn't exist.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="namespace" priority="1004" mode="M1"><svrl:fired-rule context="namespace" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="matches(., '^[a-z]+:')"/>
      <xsl:otherwise><svrl:failed-assert test="matches(., '^[a-z]+:')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Namespace property must be a valid absolute URI.  Value is <xsl:text/><xsl:value-of select="."/><xsl:text/>.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../namespacePrefix"/>
      <xsl:otherwise><svrl:failed-assert test="../namespacePrefix" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>namespace <xsl:text/><xsl:value-of select="."/><xsl:text/> has no namespacePrefix property.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:namespace" priority="1003" mode="M1"><svrl:fired-rule context="es:namespace" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="matches(., '^[a-z]+:')"/>
      <xsl:otherwise><svrl:failed-assert test="matches(., '^[a-z]+:')" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Namespace property must be a valid absolute URI.  Value is <xsl:text/><xsl:value-of select="."/><xsl:text/>.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../es:namespace-prefix"/>
      <xsl:otherwise><svrl:failed-assert test="../es:namespace-prefix" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>namespace <xsl:text/><xsl:value-of select="."/><xsl:text/> has no namespace-prefix property.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="namespacePrefix" priority="1002" mode="M1"><svrl:fired-rule context="namespacePrefix" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../namespace"/>
      <xsl:otherwise><svrl:failed-assert test="../namespace" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>namespacePrefix <xsl:text/><xsl:value-of select="."/><xsl:text/> has no namespace property.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not( matches( string(.), '^(es|json|xsi|xs|xsd|[xX][mM][lL])$' ) )"/>
      <xsl:otherwise><svrl:failed-assert test="not( matches( string(.), '^(es|json|xsi|xs|xsd|[xX][mM][lL])$' ) )" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Namespace prefix <xsl:text/><xsl:value-of select="."/><xsl:text/> is not valid.  It is a reserved pattern.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="es:namespace-prefix" priority="1001" mode="M1"><svrl:fired-rule context="es:namespace-prefix" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="../es:namespace"/>
      <xsl:otherwise><svrl:failed-assert test="../es:namespace" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>namespace-prefix  <xsl:text/><xsl:value-of select="."/><xsl:text/> has no namespace property.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="not( matches( string(.), '^(es|json|xsi|xs|xsd|[xX][mM][lL])$' ) )"/>
      <xsl:otherwise><svrl:failed-assert test="not( matches( string(.), '^(es|json|xsi|xs|xsd|[xX][mM][lL])$' ) )" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Namespace prefix <xsl:text/><xsl:value-of select="."/><xsl:text/> is not valid.  It is a reserved pattern.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="*" mode="M1"/></xsl:template>
  <!--RULE -->
  <xsl:template match="/" priority="1000" mode="M1"><svrl:fired-rule context="/" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"/>

		<!--ASSERT -->
<xsl:choose>
      <xsl:when test="count(distinct-values( .//(namespace|es:namespace)                                                 ! concat(../(namespacePrefix|es:namespace-prefix), .))) eq                        count(distinct-values( .//(namespace|es:namespace ))) and                        count(distinct-values( .//(namespace|es:namespace ))) eq                        count(distinct-values( .//(namespacePrefix|es:namespace-prefix )))"/>
      <xsl:otherwise><svrl:failed-assert test="count(distinct-values( .//(namespace|es:namespace) ! concat(../(namespacePrefix|es:namespace-prefix), .))) eq count(distinct-values( .//(namespace|es:namespace ))) and count(distinct-values( .//(namespace|es:namespace ))) eq count(distinct-values( .//(namespacePrefix|es:namespace-prefix )))" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"><xsl:attribute name="location"><xsl:apply-templates select="." mode="schematron-select-full-path"/></xsl:attribute><svrl:text>Each prefix and namespace pair must be unique.</svrl:text></svrl:failed-assert></xsl:otherwise>
    </xsl:choose><xsl:apply-templates select="element()|object-node()|array-node()" mode="M1"/></xsl:template>
  <xsl:template match="text()" priority="-1" mode="M1"/>
  <xsl:template match="@*|node()" priority="-2" mode="M1"><xsl:apply-templates select="*" mode="M1"/></xsl:template>
</xsl:stylesheet>