(:
 Copyright (c) 2020 MarkLogic Corporation
:)
xquery version "1.0-ml";

module namespace inst = "http://marklogic.com/entity-services-instance";
declare namespace es = "http://marklogic.com/entity-services";
declare namespace tde = "http://marklogic.com/xdmp/tde";
declare namespace xq = "http://www.w3.org/2012/xquery";


import module namespace sem = "http://marklogic.com/semantics" at "/MarkLogic/semantics.xqy";
import module namespace json = "http://marklogic.com/xdmp/json" at "/MarkLogic/json/json.xqy";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

(: declare option xdmp:mapping "false"; :)
declare option xq:require-feature "xdmp:three-one";

declare function inst:instance-from-document(
    $document as document-node()
) as map:map*
{
    let $xml-from-document := inst:instance-xml-from-document($document)
    for $root-instance in $xml-from-document
        return inst:child-instance($root-instance)
};

declare function inst:child-instance(
    $element as element()
) as map:map*
{
    if (empty($element/*))
    then json:object()
            =>map:with("$type", local-name($element))
            =>map:with("$ref", $element/data())
    else
        let $child := json:object()=>map:with("$type", local-name($element))
        let $_ :=
            for $property in $element/*
            return
                if (map:contains($child, local-name($property)))
                then
                    if (map:get($child, local-name($property)) instance of json:array)
                    then json:array-push(map:get($child, local-name($property)),
                            if ($property/element())
                            then inst:child-instance($property/*)
                            else data($property))
                        else
                        let $new-array := json:array()
                        return (
                            json:array-push($new-array, map:get($child, local-name($property))),
                            json:array-push($new-array,
                            if ($property/element())
                            then inst:child-instance($property/*)
                            else data($property)),
                            map:put($child, local-name($property), $new-array)
                        )
                else
                    if ($property[@datatype eq "array"])
                    then
                        map:put($child, local-name($property),
                            json:array()
                            =>json:array-with(
                                if ($property/element())
                                then inst:child-instance($property/element())
                                else data($property))
                            )
                    else
                        map:put($child, local-name($property),
                            if ($property/element())
                            then inst:child-instance($property/element())
                            else data($property))
        return $child
};


declare function inst:instance-xml-from-document(
    $document as document-node()
) as element()*
{
    if ($document/element())
    then $document//es:instance/(* except es:info)
    else
        let $json := inst:instance-json-from-document($document)
        return json:transform-from-json($json,
            json:config("custom")=>map:with("element-namespace",""))
};

declare private function inst:wrap-instance(
    $instance as json:object
) as json:object
{
    let $type := map:get($instance, "$type")
    let $remove-it := map:delete($instance, "$type")
    return json:object()
        =>map:with($type,
            if (map:contains($instance, "$ref"))
            then map:get($instance, "$ref")
            else
                let $value-map := json:object()
                let $_ :=
                    for $k in map:keys($instance)
                    let $v := map:get($instance, $k)
                    return
                    typeswitch ($v)
                    case json:array return

                        if (json:array-size($v) eq 0)
                        then json:object()=>map:with($k, $v)
                        else if ($v[1] instance of json:object)
                        then map:put($value-map, $k, (json:to-array(json:array-values($v) ! inst:wrap-instance(.))))
                        else map:put($value-map, $k, $v)
                    case json:object return
                        map:put($value-map, $k, inst:wrap-instance($v))
                    default return map:put($value-map, $k, $v)
                return $value-map)
};

declare function inst:instance-json-from-document(
    $document as document-node()
) as object-node()*
{
    if ($document/object-node())
    then
        for $n in $document//instance/*
        where fn:node-name($n) ne xs:QName("info")
        return
        object-node { fn:node-name($n) : $n }
    else
    (inst:instance-from-document($document) !
        (inst:wrap-instance(.)=>xdmp:to-json()))/node()
 };


declare function inst:instance-get-attachments(
    $document as document-node()
) as item()*
{
    if (exists($document//es:attachments/node()))
    then $document//es:attachments/node()
    else if (exists($document//array-node("attachments")))
    then $document//attachments
    else ()
};

(: Experimental: mapping support :)

(: Convert from XML form to JSON form :)

declare private function
inst:canonical-child-json(
  $element as element()
) as map:map*
{
  if (empty($element/*))
  then json:object()=>map:with("$ref", $element/data())
  else (
    let $child := json:object()
    let $process-function := function($property) {
      if ($property/element())
      then $property/element() ! (json:object() => map:with(local-name(.), inst:canonical-child-json(.)))
      else if ($property/@xsi:nil)
      then json:null()
      else data($property)
    }
    let $_ :=
      for $property in $element/* 
      return (
        if (map:contains($child, local-name($property))) then (
          (: Already exists: push as array value :)
          if (map:get($child, local-name($property)) instance of json:array)
          then json:array-push(map:get($child, local-name($property)),
            $process-function($property))
          else
            let $new-array := json:array()
            return (
              json:array-push($new-array, map:get($child, local-name($property))),
              json:array-push($new-array,
                $process-function($property)
              ),
              map:put($child, local-name($property), $new-array)
            )
        ) else if ($property[@datatype eq "array"]) then (
          (: Doesn't exist, but known to be an array: add as array item :)
          map:put($child, local-name($property),
            json:array()
              =>json:array-with(
                $process-function($property))
              )
        ) else (
          (: Doesn't exist, not known to be array: as as direct child :)
          map:put($child, local-name($property),
          $process-function($property))
        )
      )
    return $child
  )
};

declare function
inst:canonical-xml(
  $document-xml as document-node()?
) as document-node()
{
  $document-xml
};

declare function
inst:canonical-json(
  $document-xml as document-node()?
) as document-node()
{
  (: We expect only one here, but if not, wrap in an array :)
  let $entities :=
    for $element in $document-xml/*
    let $json-object := json:object()=>
          map:with(local-name($element),inst:canonical-child-json($element))
    return (
      xdmp:to-json($json-object)/node()
    )
  return
    if (exists($entities[2]))
    then document{ array-node{$entities} }
    else document{ $entities }
};
