'use strict';
declareUpdate();

const permissions = [xdmp.permission('rest-extension-user', 'read'), xdmp.permission('rest-extension-user', 'execute'),
  xdmp.permission('rest-reader-internal', 'read'), xdmp.permission('rest-reader-internal', 'execute'),
  xdmp.permission('rest-admin-internal', 'update'), xdmp.permission('application-plugin-registrar', 'read'),
  xdmp.permission('application-plugin-registrar', 'update'), xdmp.permission('application-plugin-registrar', 'execute'),
  xdmp.permission('data-hub-module-writer', 'update')];

for (const uri of cts.uriMatch('/marklogic.rest.*/ml*')) {
  // Don't process SJS, the XQuery will point to original SJS & don't reprocess those already with a colon
  if (!(fn.endsWith(uri, '.sjs') || fn.contains(uri, ':'))) {
    const isXML = fn.endsWith(uri, '.xml');
    const restExtensionName = fn.string(uri).split('/')[2];
    const colonPrefixName = `ml:${fn.lowerCase(restExtensionName.substring(2, 3))}${restExtensionName.substring(3)}`;
    const colonUri = fn.replace(uri, restExtensionName, colonPrefixName);
    const originalDoc = cts.doc(uri);
    const originalDocText = isXML ? xdmp.quote(originalDoc) : fn.string(originalDoc);
    const newDocText = fn.replace(originalDocText, restExtensionName, colonPrefixName);
    xdmp.documentInsert(
      colonUri,
      isXML ? xdmp.unquote(newDocText) :
        // We only want to update the namespace
        new NodeBuilder().addText(fn.replace(originalDocText, `/${restExtensionName}";`, `/${colonPrefixName}";`)).toNode(),
      {permissions}
    );
  }
}
