/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;

public class QueryRolesetUtil {
    private static final Logger logger = LoggerFactory.getLogger(QueryRolesetUtil.class);

    public static void handleSaveException(HttpClientErrorException ex) {
        try {
            JsonNode errorResponse;
            JsonNode error = ObjectMapperFactory.getObjectMapper().readTree(ex.getResponseBodyAsString());
            if (error.has("errorResponse") && (errorResponse = error.get("errorResponse")).has("messageCode")) {
                String messageCode = errorResponse.get("messageCode").asText();
                if ("SEC-PERMDENIED".equals(messageCode)) {
                    logger.error("Received SEC-PERMDENIED error when deploying query roleset; this can be safely ignored if the query roleset already exists in MarkLogic.");
                    return;
                }
                if ("REST-UNSUPPORTEDMETHOD".equals(messageCode)) {
                    logger.info("Received REST-UNSUPPORTEDMETHOD error when updating query roleset; this can be safely ignored when running against MarkLogic version 10.0-4 or higher, which no longer supports updates to query rolesets");
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error when trying to parse error for deploying query rolesets: " + e.getMessage());
        }
        throw ex;
    }
}

