/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.util.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class StepManager
extends LoggingObject {
    private final HubConfig hubConfig;
    private final ObjectMapper mapper = new ObjectMapper();
    String STEP_FILE_EXTENSION = ".step.json";

    public StepManager(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public ObjectNode getLocalStepAsJSON(String stepId) {
        ObjectNode node;
        Path stepPath = this.getStepsPath(stepId).resolve(StepManager.getStepName(stepId) + this.STEP_FILE_EXTENSION);
        String suffix = stepId.substring(stepId.lastIndexOf(45) + 1);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/hub-internal-artifacts/steps/" + suffix + "/" + StepManager.getStepName(stepId) + this.STEP_FILE_EXTENSION);
        if (inputStream == null) {
            try {
                inputStream = FileUtils.openInputStream((File)stepPath.toFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new DataHubProjectException(e.getMessage());
            }
        }
        try {
            node = (ObjectNode)JSONObject.readInput(inputStream);
        }
        catch (IOException e) {
            throw new DataHubProjectException("Unable to read step: " + e.getMessage());
        }
        return node;
    }

    public void saveLocalStep(ObjectNode stepNode) {
        ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
        String stepId = stepNode.get("stepId").asText();
        File stepFile = this.getStepsPath(stepId).resolve(StepManager.getStepName(stepId) + this.STEP_FILE_EXTENSION).toFile();
        try {
            writer.writeValue(stepFile, (Object)stepNode);
            this.logger.warn(this.format("Step '%s' was saved", new Object[]{stepFile}));
        }
        catch (IOException e) {
            this.logger.error(this.format("Step '%s' save failed; cause: %s", new Object[]{stepFile, e.getMessage()}), (Throwable)e);
        }
    }

    public Path getStepsPath(String stepId) {
        String suffix = stepId.substring(stepId.lastIndexOf(45) + 1);
        StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(suffix);
        return this.hubConfig.getHubProject().getStepsPath(stepDefType);
    }

    public static String getStepName(String stepId) {
        return stepId.substring(0, stepId.lastIndexOf(45));
    }
}

