/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.DefaultAppConfigFactory;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubClientConfig;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.dataservices.SystemService;
import com.marklogic.hub.error.DataHubConfigurationException;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.error.InvalidDBOperationError;
import com.marklogic.hub.impl.HubClientImpl;
import com.marklogic.hub.impl.VersionInfo;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.admin.DefaultAdminConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.SimplePropertySource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, getterVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public class HubConfigImpl
extends HubClientConfig
implements HubConfig {
    private static final Pattern pathSeparatorPattern = Pattern.compile("/", 16);
    private HubProject hubProject;
    protected String stagingHttpName;
    protected Integer stagingForestsPerHost;
    protected String finalHttpName;
    protected Integer finalForestsPerHost;
    protected String jobHttpName;
    protected Integer jobForestsPerHost;
    protected Integer modulesForestsPerHost;
    protected Integer stagingTriggersForestsPerHost;
    protected Integer finalTriggersForestsPerHost;
    protected Integer stagingSchemasForestsPerHost;
    protected Integer finalSchemasForestsPerHost;
    private String hubLogLevel;
    private Boolean hubFlattenedTdeView = Boolean.TRUE;
    private Boolean isProvisionedEnvironment;
    protected String customForestPath;
    private String mappingPermissions;
    private String flowPermissions;
    private String stepDefinitionPermissions;
    private String entityModelPermissions;
    private String jobPermissions;
    private ManageClient manageClient;
    private AdminConfig adminConfig;
    private AdminManager adminManager;
    private AppConfig appConfig;
    private static final Logger logger = LoggerFactory.getLogger(HubConfigImpl.class);
    private String envString = "local";

    public HubConfigImpl() {
        this.applyDefaultPropertyValues();
    }

    public HubConfigImpl(HubProject hubProject) {
        this();
        this.hubProject = hubProject;
    }

    @Deprecated
    public static HubConfigImpl withDefaultProperties() {
        return new HubConfigImpl();
    }

    public static HubConfigImpl withProperties(Properties props) {
        HubConfigImpl config = new HubConfigImpl();
        config.applyProperties((PropertySource)new SimplePropertySource(props));
        return config;
    }

    public HubConfigImpl(String host, String mlUsername, String mlPassword) {
        this();
        Properties props = new Properties();
        props.setProperty("mlHost", host);
        props.setProperty("mlUsername", mlUsername);
        props.setProperty("mlPassword", mlPassword);
        this.applyProperties((PropertySource)new SimplePropertySource(props));
    }

    public HubConfigImpl(String host, String mlUsername, String mlPassword, String stagingDbName, String finalDbName) {
        this();
        Properties props = new Properties();
        props.setProperty("mlHost", host);
        props.setProperty("mlUsername", mlUsername);
        props.setProperty("mlPassword", mlPassword);
        props.setProperty("mlStagingDbName", stagingDbName);
        props.setProperty("mlFinalDbName", finalDbName);
        this.applyProperties((PropertySource)new SimplePropertySource(props));
    }

    @Override
    public DatabaseClient newAppServicesModulesClient() {
        return this.appConfig.newAppServicesDatabaseClient(this.getDbName(DatabaseKind.MODULES));
    }

    public void applyProperties(Properties properties) {
        this.applyProperties((PropertySource)new SimplePropertySource(properties));
    }

    public void applyProperties(PropertySource propertySource) {
        this.applyProperties(propertySource, null, null, null);
    }

    public void applyProperties(PropertySource propertySource, AppConfig appConfigToReuse, ManageConfig manageConfigToReuse, AdminConfig adminConfigToReuse) {
        this.appConfig = appConfigToReuse != null ? appConfigToReuse : new DefaultAppConfigFactory(propertySource).newAppConfig();
        this.adminConfig = adminConfigToReuse != null ? adminConfigToReuse : new DefaultAdminConfigFactory(propertySource).newAdminConfig();
        super.applyProperties(arg_0 -> ((PropertySource)propertySource).getProperty(arg_0), manageConfigToReuse);
        this.setAppConfig(this.appConfig, false);
        this.setAdminManager(new AdminManager(this.adminConfig));
        this.setManageClient(new ManageClient(this.getManageConfig()));
    }

    public static Properties getHubPropertiesFromDb(DatabaseClient client) {
        Properties properties = new Properties();
        try {
            JsonNode dhConfig = SystemService.on(client).getDataHubConfig();
            dhConfig.fieldNames().forEachRemaining(key -> properties.setProperty((String)key, dhConfig.get(key).textValue()));
            logger.info("Reading the datahub config for hubcentral from the datahubConfig.json file successful");
        }
        catch (Exception exception) {
            logger.info("Could not find the datahubConfig.json file. Logging the cause for the failure");
            logger.info(exception.getMessage());
        }
        return properties;
    }

    protected HubProject requireHubProject() {
        Assert.notNull((Object)this.hubProject, (String)"A HubProject has not been set, and thus this operation cannot be performed");
        return this.hubProject;
    }

    @Override
    public void createProject(String projectDirString) {
        this.requireHubProject().createProject(projectDirString);
    }

    @Override
    public String getHost() {
        return this.appConfig != null ? this.appConfig.getHost() : super.getHost();
    }

    @Override
    public String getDbName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.getStagingDbName();
                break;
            }
            case FINAL: {
                name = this.getFinalDbName();
                break;
            }
            case JOB: 
            case TRACE: {
                name = this.getJobDbName();
                break;
            }
            case MODULES: 
            case STAGING_MODULES: 
            case FINAL_MODULES: {
                name = super.getModulesDbName();
                break;
            }
            case STAGING_TRIGGERS: {
                name = this.getStagingTriggersDbName();
                break;
            }
            case FINAL_TRIGGERS: {
                name = this.getFinalTriggersDbName();
                break;
            }
            case STAGING_SCHEMAS: {
                name = this.getStagingSchemasDbName();
                break;
            }
            case FINAL_SCHEMAS: {
                name = this.getFinalSchemasDbName();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab database name");
            }
        }
        return name;
    }

    @Override
    public void setDbName(DatabaseKind kind, String dbName) {
        switch (kind) {
            case STAGING: {
                this.setStagingDbName(dbName);
                break;
            }
            case FINAL: {
                this.setFinalDbName(dbName);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobDbName(dbName);
                break;
            }
            case MODULES: 
            case STAGING_MODULES: 
            case FINAL_MODULES: {
                this.setModulesDbName(dbName);
                break;
            }
            case STAGING_TRIGGERS: {
                this.setStagingTriggersDbName(dbName);
                break;
            }
            case FINAL_TRIGGERS: {
                this.setFinalTriggersDbName(dbName);
                break;
            }
            case STAGING_SCHEMAS: {
                this.setStagingSchemasDbName(dbName);
                break;
            }
            case FINAL_SCHEMAS: {
                this.setFinalSchemasDbName(dbName);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set database name");
            }
        }
    }

    @Override
    public String getHttpName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.stagingHttpName;
                break;
            }
            case FINAL: {
                name = this.finalHttpName;
                break;
            }
            case JOB: {
                name = this.jobHttpName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab http name");
            }
        }
        return name;
    }

    @Override
    public void setHttpName(DatabaseKind kind, String httpName) {
        switch (kind) {
            case STAGING: {
                this.stagingHttpName = httpName;
                break;
            }
            case FINAL: {
                this.finalHttpName = httpName;
                break;
            }
            case JOB: 
            case TRACE: {
                this.jobHttpName = httpName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set http name");
            }
        }
    }

    @Override
    public Integer getForestsPerHost(DatabaseKind kind) {
        Integer forests;
        switch (kind) {
            case STAGING: {
                forests = this.stagingForestsPerHost;
                break;
            }
            case FINAL: {
                forests = this.finalForestsPerHost;
                break;
            }
            case JOB: 
            case TRACE: {
                forests = this.jobForestsPerHost;
                break;
            }
            case MODULES: 
            case STAGING_MODULES: 
            case FINAL_MODULES: {
                forests = this.modulesForestsPerHost;
                break;
            }
            case STAGING_TRIGGERS: {
                forests = this.stagingTriggersForestsPerHost;
                break;
            }
            case FINAL_TRIGGERS: {
                forests = this.finalTriggersForestsPerHost;
                break;
            }
            case STAGING_SCHEMAS: {
                forests = this.stagingSchemasForestsPerHost;
                break;
            }
            case FINAL_SCHEMAS: {
                forests = this.finalSchemasForestsPerHost;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab count of forests per host");
            }
        }
        return forests;
    }

    @Override
    public void setForestsPerHost(DatabaseKind kind, Integer forestsPerHost) {
        switch (kind) {
            case STAGING: {
                this.stagingForestsPerHost = forestsPerHost;
                break;
            }
            case FINAL: {
                this.finalForestsPerHost = forestsPerHost;
                break;
            }
            case JOB: 
            case TRACE: {
                this.jobForestsPerHost = forestsPerHost;
                break;
            }
            case MODULES: 
            case STAGING_MODULES: 
            case FINAL_MODULES: {
                this.modulesForestsPerHost = forestsPerHost;
                break;
            }
            case STAGING_TRIGGERS: {
                this.stagingTriggersForestsPerHost = forestsPerHost;
                break;
            }
            case FINAL_TRIGGERS: {
                this.finalTriggersForestsPerHost = forestsPerHost;
                break;
            }
            case STAGING_SCHEMAS: {
                this.stagingSchemasForestsPerHost = forestsPerHost;
                break;
            }
            case FINAL_SCHEMAS: {
                this.finalSchemasForestsPerHost = forestsPerHost;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set count of forests per host");
            }
        }
    }

    @Override
    public Integer getPort(DatabaseKind kind) {
        Integer port;
        switch (kind) {
            case STAGING: {
                port = this.getStagingPort();
                break;
            }
            case FINAL: {
                port = this.getFinalPort();
                break;
            }
            case JOB: 
            case TRACE: {
                port = this.getJobPort();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab app port");
            }
        }
        return port;
    }

    @Override
    public void setPort(DatabaseKind kind, Integer port) {
        switch (kind) {
            case STAGING: {
                this.setStagingPort(port);
                break;
            }
            case FINAL: {
                this.setFinalPort(port);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobPort(port);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set app port");
            }
        }
    }

    @Override
    public SSLContext getSslContext(DatabaseKind kind) {
        SSLContext sslContext;
        switch (kind) {
            case STAGING: {
                sslContext = this.getStagingSslContext();
                break;
            }
            case JOB: 
            case TRACE: {
                sslContext = this.getJobSslContext();
                break;
            }
            case FINAL: {
                sslContext = this.getFinalSslContext();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get ssl context");
            }
        }
        return sslContext;
    }

    @Override
    public void setSslContext(DatabaseKind kind, SSLContext sslContext) {
        switch (kind) {
            case STAGING: {
                this.setStagingSslContext(sslContext);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobSslContext(sslContext);
                break;
            }
            case FINAL: {
                this.setFinalSslContext(sslContext);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set ssl context");
            }
        }
    }

    @Override
    public DatabaseClientFactory.SSLHostnameVerifier getSslHostnameVerifier(DatabaseKind kind) {
        DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier;
        switch (kind) {
            case STAGING: {
                sslHostnameVerifier = this.getStagingSslHostnameVerifier();
                break;
            }
            case JOB: 
            case TRACE: {
                sslHostnameVerifier = this.getJobSslHostnameVerifier();
                break;
            }
            case FINAL: {
                sslHostnameVerifier = this.getFinalSslHostnameVerifier();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get ssl hostname verifier");
            }
        }
        return sslHostnameVerifier;
    }

    @Override
    public void setSslHostnameVerifier(DatabaseKind kind, DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier) {
        switch (kind) {
            case STAGING: {
                this.setStagingSslHostnameVerifier(sslHostnameVerifier);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobSslHostnameVerifier(sslHostnameVerifier);
                break;
            }
            case FINAL: {
                this.setFinalSslHostnameVerifier(sslHostnameVerifier);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set ssl hostname verifier");
            }
        }
    }

    @Override
    public String getAuthMethod(DatabaseKind kind) {
        String authMethod;
        switch (kind) {
            case STAGING: {
                authMethod = this.getStagingAuthMethod();
                break;
            }
            case FINAL: {
                authMethod = this.getFinalAuthMethod();
                break;
            }
            case JOB: 
            case TRACE: {
                authMethod = this.getJobAuthMethod();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get auth method");
            }
        }
        return authMethod;
    }

    @Override
    public void setAuthMethod(DatabaseKind kind, String authMethod) {
        switch (kind) {
            case STAGING: {
                this.setStagingAuthMethod(authMethod);
                break;
            }
            case FINAL: {
                this.setFinalAuthMethod(authMethod);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobAuthMethod(authMethod);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @Override
    public X509TrustManager getTrustManager(DatabaseKind kind) {
        switch (kind) {
            case STAGING: {
                return this.getStagingTrustManager();
            }
            case JOB: {
                return this.getJobTrustManager();
            }
            case FINAL: {
                return this.getFinalTrustManager();
            }
        }
        throw new InvalidDBOperationError(kind, "set auth method");
    }

    @Override
    public void setTrustManager(DatabaseKind kind, X509TrustManager trustManager) {
        switch (kind) {
            case STAGING: {
                this.setStagingTrustManager(trustManager);
                break;
            }
            case JOB: {
                this.setJobTrustManager(trustManager);
                break;
            }
            case FINAL: {
                this.setFinalTrustManager(trustManager);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @Override
    @Deprecated
    public String getScheme(DatabaseKind kind) {
        return null;
    }

    @Override
    @Deprecated
    public void setScheme(DatabaseKind kind, String scheme) {
    }

    @Override
    public boolean getSimpleSsl(DatabaseKind kind) {
        boolean simple;
        switch (kind) {
            case STAGING: {
                simple = this.getStagingSimpleSsl();
                break;
            }
            case JOB: 
            case TRACE: {
                simple = this.getJobSimpleSsl();
                break;
            }
            case FINAL: {
                simple = this.getFinalSimpleSsl();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get simple ssl");
            }
        }
        return simple;
    }

    @Override
    public void setSimpleSsl(DatabaseKind kind, Boolean simpleSsl) {
        switch (kind) {
            case STAGING: {
                this.setStagingSimpleSsl(simpleSsl);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobSimpleSsl(simpleSsl);
                break;
            }
            case FINAL: {
                this.setFinalSimpleSsl(simpleSsl);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set simple ssl");
            }
        }
    }

    @Override
    public String getCertFile(DatabaseKind kind) {
        String certFile;
        switch (kind) {
            case STAGING: {
                certFile = this.getStagingCertFile();
                break;
            }
            case JOB: 
            case TRACE: {
                certFile = this.getJobCertFile();
                break;
            }
            case FINAL: {
                certFile = this.getFinalCertFile();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get cert file");
            }
        }
        return certFile;
    }

    @Override
    public void setCertFile(DatabaseKind kind, String certFile) {
        switch (kind) {
            case STAGING: {
                this.setStagingCertFile(certFile);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobCertFile(certFile);
                break;
            }
            case FINAL: {
                this.setFinalCertFile(certFile);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set certificate file");
            }
        }
    }

    @Override
    public String getCertPassword(DatabaseKind kind) {
        String certPass;
        switch (kind) {
            case STAGING: {
                certPass = this.getStagingCertPassword();
                break;
            }
            case JOB: 
            case TRACE: {
                certPass = this.getJobCertPassword();
                break;
            }
            case FINAL: {
                certPass = this.getFinalCertPassword();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get cert password");
            }
        }
        return certPass;
    }

    @Override
    public void setCertPass(DatabaseKind kind, String certPassword) {
        switch (kind) {
            case STAGING: {
                this.setStagingCertPassword(certPassword);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobCertPassword(certPassword);
                break;
            }
            case FINAL: {
                this.setFinalCertPassword(certPassword);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set certificate password");
            }
        }
    }

    @Override
    public String getExternalName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.getStagingExternalName();
                break;
            }
            case JOB: 
            case TRACE: {
                name = this.getJobExternalName();
                break;
            }
            case FINAL: {
                name = this.getFinalExternalName();
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get external name");
            }
        }
        return name;
    }

    @Override
    public void setExternalName(DatabaseKind kind, String externalName) {
        switch (kind) {
            case STAGING: {
                this.setStagingExternalName(externalName);
                break;
            }
            case JOB: 
            case TRACE: {
                this.setJobExternalName(externalName);
                break;
            }
            case FINAL: {
                this.setFinalExternalName(externalName);
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @JsonIgnore
    public String getMlUsername() {
        return this.getUsername();
    }

    @JsonIgnore
    public String getMlPassword() {
        return this.getPassword();
    }

    public void setHost(String host) {
        super.setHost(host);
        if (this.appConfig != null) {
            this.appConfig.setHost(host);
        } else {
            this.appConfig = new AppConfig();
            this.appConfig.setHost(host);
        }
    }

    public void setMlUsername(String mlUsername) {
        this.setUsername(mlUsername);
    }

    public void setMlPassword(String mlPassword) {
        this.setPassword(mlPassword);
    }

    @Override
    public Boolean getIsProvisionedEnvironment() {
        return this.isProvisionedEnvironment;
    }

    @Override
    public void setIsProvisionedEnvironment(boolean isProvisionedEnvironment) {
        this.isProvisionedEnvironment = isProvisionedEnvironment;
    }

    @Override
    public String getCustomForestPath() {
        return this.customForestPath;
    }

    public void setCustomForestPath(String customForestPath) {
        this.customForestPath = customForestPath;
    }

    @Override
    public String getEntityModelPermissions() {
        return this.entityModelPermissions;
    }

    @Override
    public String getFlowPermissions() {
        return this.flowPermissions;
    }

    @Override
    public String getMappingPermissions() {
        return this.mappingPermissions;
    }

    @Override
    public String getStepDefinitionPermissions() {
        return this.stepDefinitionPermissions;
    }

    public String getJobPermissions() {
        return this.jobPermissions;
    }

    public void setJobPermissions(String jobPermissions) {
        this.jobPermissions = jobPermissions;
    }

    @Override
    @Deprecated
    public String getProjectDir() {
        return this.requireHubProject().getProjectDirString();
    }

    @Override
    @Deprecated
    public void setProjectDir(String projectDir) {
        this.createProject(projectDir);
    }

    public void setEntityModelPermissions(String entityModelPermissions) {
        this.entityModelPermissions = entityModelPermissions;
    }

    public void setFlowPermissions(String flowPermissions) {
        this.flowPermissions = flowPermissions;
    }

    public void setMappingPermissions(String mappingPermissions) {
        this.mappingPermissions = mappingPermissions;
    }

    public void setStepDefinitionPermissions(String stepDefinitionPermissions) {
        this.stepDefinitionPermissions = stepDefinitionPermissions;
    }

    @Override
    @JsonIgnore
    public HubProject getHubProject() {
        return this.hubProject;
    }

    public void setHubProject(HubProject hubProject) {
        this.hubProject = hubProject;
    }

    @Override
    public void initHubProject() {
        if (this.appConfig == null) {
            this.appConfig = new DefaultAppConfigFactory().newAppConfig();
        }
        this.addDhfPropertiesToCustomTokens(this.appConfig);
        this.requireHubProject().init(this.appConfig.getCustomTokens());
    }

    @Override
    @JsonIgnore
    public void refreshProject() {
        this.loadConfigurationFromProperties(null, true);
    }

    public void loadConfigurationFromProperties(Properties userProperties, boolean loadGradleProperties) {
        Properties gradleAndUserProperties = new Properties();
        if (loadGradleProperties) {
            File envPropertiesFile;
            if (logger.isInfoEnabled()) {
                logger.info("Loading properties from gradle.properties");
            }
            File file = this.requireHubProject().getProjectDir().resolve("gradle.properties").toFile();
            this.loadPropertiesFromFile(file, gradleAndUserProperties);
            if (this.envString != null && (envPropertiesFile = this.requireHubProject().getProjectDir().resolve("gradle-" + this.envString + ".properties").toFile()).exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Loading additional properties from {}", (Object)envPropertiesFile.getAbsolutePath());
                }
                this.loadPropertiesFromFile(envPropertiesFile, gradleAndUserProperties);
                this.requireHubProject().setUserModulesDeployTimestampFile(this.envString + "-" + "user-modules-deploy-timestamps.properties");
            }
        }
        if (userProperties != null) {
            gradleAndUserProperties.putAll((Map<?, ?>)userProperties);
        }
        this.applyProperties((PropertySource)new SimplePropertySource(gradleAndUserProperties));
    }

    @JsonIgnore
    public ManageConfig getManageConfig() {
        return super.getManageConfig();
    }

    @Override
    @JsonIgnore
    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public void setManageClient(ManageClient manageClient) {
        this.manageClient = manageClient;
    }

    @JsonIgnore
    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public void setAdminConfig(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
    }

    @Override
    @JsonIgnore
    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public void setAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
    }

    @Override
    public DatabaseClient newAppServicesClient() {
        return this.getAppConfig().newAppServicesDatabaseClient(this.getStagingDbName());
    }

    @Override
    public DatabaseClient newStagingClient() {
        return this.newStagingClient(this.getStagingDbName());
    }

    @Override
    public DatabaseClient newReverseFlowClient() {
        return this.newStagingClient(this.getFinalDbName());
    }

    @Override
    public DatabaseClient newFinalClient() {
        return this.newFinalClient(this.getFinalDbName());
    }

    @Override
    @Deprecated
    public DatabaseClient newTraceDbClient() {
        return this.newJobDbClient();
    }

    @Override
    @JsonIgnore
    public Path getModulesDir() {
        return this.requireHubProject().getModulesDir();
    }

    @JsonIgnore
    public Path getHubProjectDir() {
        return this.requireHubProject().getProjectDir();
    }

    @Override
    @JsonIgnore
    public Path getHubPluginsDir() {
        return this.requireHubProject().getHubPluginsDir();
    }

    @Override
    @JsonIgnore
    public Path getHubEntitiesDir() {
        return this.requireHubProject().getHubEntitiesDir();
    }

    @Override
    @JsonIgnore
    public Path getHubMappingsDir() {
        return this.requireHubProject().getHubMappingsDir();
    }

    @Override
    @JsonIgnore
    public Path getStepDefinitionPath(StepDefinition.StepDefinitionType type) {
        return this.requireHubProject().getStepDefinitionPath(type);
    }

    @Override
    @JsonIgnore
    public Path getHubConfigDir() {
        return this.requireHubProject().getHubConfigDir();
    }

    @Override
    @JsonIgnore
    public Path getHubDatabaseDir() {
        return this.requireHubProject().getHubDatabaseDir();
    }

    @Override
    @JsonIgnore
    public Path getHubServersDir() {
        return this.requireHubProject().getHubServersDir();
    }

    @Override
    @JsonIgnore
    public Path getHubSecurityDir() {
        return this.requireHubProject().getHubSecurityDir();
    }

    @Override
    @JsonIgnore
    public Path getUserSecurityDir() {
        return this.requireHubProject().getUserSecurityDir();
    }

    @Override
    @JsonIgnore
    public Path getUserConfigDir() {
        return this.requireHubProject().getUserConfigDir();
    }

    @Override
    @JsonIgnore
    public Path getUserDatabaseDir() {
        return this.requireHubProject().getUserDatabaseDir();
    }

    @Override
    @JsonIgnore
    public Path getUserSchemasDir() {
        return this.requireHubProject().getUserSchemasDir();
    }

    @Override
    @JsonIgnore
    public Path getEntityDatabaseDir() {
        return this.requireHubProject().getEntityDatabaseDir();
    }

    @Override
    public Path getFlowsDir() {
        return this.requireHubProject().getFlowsDir();
    }

    @Override
    public Path getStepDefinitionsDir() {
        return this.requireHubProject().getStepDefinitionsDir();
    }

    @Override
    @JsonIgnore
    public Path getUserServersDir() {
        return this.requireHubProject().getUserServersDir();
    }

    @Override
    @JsonIgnore
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public void setAppConfig(AppConfig config) {
        this.setAppConfig(config, false);
    }

    @Override
    public void setAppConfig(AppConfig config, boolean skipUpdate) {
        this.appConfig = config;
        if (!skipUpdate) {
            this.updateAppConfig(this.appConfig);
        }
    }

    @Override
    public String getJarVersion() {
        return VersionInfo.getBuildVersion();
    }

    @Override
    public String getHubLogLevel() {
        return this.hubLogLevel;
    }

    protected void addDhfPropertiesToCustomTokens(AppConfig appConfig) {
        Map customTokens = appConfig.getCustomTokens();
        customTokens.put("%%mlHost%%", appConfig.getHost());
        customTokens.put("%%mlAuthentication%%", this.getMlAuthentication());
        customTokens.put("%%mlStagingAppserverName%%", this.stagingHttpName);
        customTokens.put("%%mlStagingPort%%", this.getStagingPort().toString());
        customTokens.put("%%mlStagingBasePath%%", this.getStagingBasePath());
        customTokens.put("%%mlStagingDbName%%", this.getStagingDbName());
        customTokens.put("%%mlStagingForestsPerHost%%", this.stagingForestsPerHost.toString());
        customTokens.put("%%mlStagingAuth%%", this.getStagingAuthMethod());
        customTokens.put("%%mlFinalAppserverName%%", this.finalHttpName);
        customTokens.put("%%mlFinalPort%%", this.getFinalPort().toString());
        customTokens.put("%%mlFinalBasePath%%", this.getFinalBasePath());
        customTokens.put("%%mlFinalDbName%%", this.getFinalDbName());
        customTokens.put("%%mlFinalForestsPerHost%%", this.finalForestsPerHost.toString());
        customTokens.put("%%mlFinalAuth%%", this.getFinalAuthMethod());
        customTokens.put("%%mlJobAppserverName%%", this.jobHttpName);
        customTokens.put("%%mlJobPort%%", this.getJobPort().toString());
        customTokens.put("%%mlJobBasePath%%", this.getJobBasePath());
        customTokens.put("%%mlJobDbName%%", this.getJobDbName());
        customTokens.put("%%mlJobForestsPerHost%%", this.jobForestsPerHost.toString());
        customTokens.put("%%mlJobAuth%%", this.getJobAuthMethod());
        customTokens.put("%%mlModulesDbName%%", this.getModulesDbName());
        customTokens.put("%%mlModulesForestsPerHost%%", this.modulesForestsPerHost.toString());
        customTokens.put("%%mlStagingTriggersDbName%%", this.getStagingTriggersDbName());
        customTokens.put("%%mlStagingTriggersForestsPerHost%%", this.stagingTriggersForestsPerHost.toString());
        customTokens.put("%%mlFinalTriggersDbName%%", this.getFinalTriggersDbName());
        customTokens.put("%%mlFinalTriggersForestsPerHost%%", this.finalTriggersForestsPerHost.toString());
        customTokens.put("%%mlStagingSchemasDbName%%", this.getStagingSchemasDbName());
        customTokens.put("%%mlStagingSchemasForestsPerHost%%", this.stagingSchemasForestsPerHost.toString());
        customTokens.put("%%mlFinalSchemasDbName%%", this.getFinalSchemasDbName());
        customTokens.put("%%mlFinalSchemasForestsPerHost%%", this.finalSchemasForestsPerHost.toString());
        customTokens.put("%%mlJobPermissions%%", this.jobPermissions);
        customTokens.put("%%mlFlowPermissions%%", this.flowPermissions);
        customTokens.put("%%mlEntityModelPermissions%%", this.entityModelPermissions);
        customTokens.put("%%mlStepDefinitionPermissions%%", this.stepDefinitionPermissions);
        customTokens.put("%%mlCustomForestPath%%", this.customForestPath);
        customTokens.put("%%hubMaxStringsInMemory%%", Integer.toString(this.getMaxStringsInMemory()));
        customTokens.put("%%hubCollectorTmpDir%%", StringUtils.isEmpty((CharSequence)this.getCollectorTmpDir()) ? "" : this.getCollectorTmpDir());
        customTokens.put("%%mlHubLogLevel%%", this.hubLogLevel);
        customTokens.put("%%hubFlattenedTdeView%%", String.valueOf(this.hubFlattenedTdeView));
    }

    private void updateAppConfig(AppConfig config) {
        String superHost = super.getHost();
        if (superHost != null) {
            config.setHost(superHost);
        }
        if ("my-app".equals(config.getName())) {
            config.setName("DHF");
        }
        config.setNoRestServer(true);
        this.applyFinalConnectionSettingsToMlGradleDefaultRestSettings(config);
        config.setTriggersDatabaseName(this.getFinalTriggersDbName());
        config.setSchemasDatabaseName(this.getFinalSchemasDbName());
        config.setModulesDatabaseName(this.getModulesDbName());
        config.setContentDatabaseName(this.getFinalDbName());
        config.setReplaceTokensInModules(true);
        config.setUseRoxyTokenPrefix(false);
        config.setModulePermissions(this.getModulePermissions());
        String defaultPath = config.getModuleTimestampsPath();
        if (!FileSystems.getDefault().getSeparator().equals("/")) {
            defaultPath = pathSeparatorPattern.matcher(defaultPath).replaceAll(Matcher.quoteReplacement(FileSystems.getDefault().getSeparator()));
        }
        if (this.envString != null) {
            int index = defaultPath.lastIndexOf(FileSystems.getDefault().getSeparator()) + 1;
            config.setModuleTimestampsPath(defaultPath.substring(0, index) + this.envString + "-" + defaultPath.substring(index));
        } else {
            config.setModuleTimestampsPath(defaultPath);
        }
        Map forestCounts = config.getForestCounts();
        forestCounts.put(this.getJobDbName(), this.jobForestsPerHost);
        forestCounts.put(this.getModulesDbName(), this.modulesForestsPerHost);
        forestCounts.put(this.getStagingDbName(), this.stagingForestsPerHost);
        forestCounts.put(this.getStagingTriggersDbName(), this.stagingTriggersForestsPerHost);
        forestCounts.put(this.getStagingSchemasDbName(), this.stagingSchemasForestsPerHost);
        forestCounts.put(this.getFinalDbName(), this.finalForestsPerHost);
        forestCounts.put(this.getFinalTriggersDbName(), this.finalTriggersForestsPerHost);
        forestCounts.put(this.getFinalSchemasDbName(), this.finalSchemasForestsPerHost);
        config.setForestCounts(forestCounts);
        if (this.hubProject != null) {
            this.initializeConfigDirs(config);
            this.initializeModulePaths(config);
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.getUserSchemasDir().toString());
            config.setSchemaPaths(paths);
        }
        this.addDhfPropertiesToCustomTokens(config);
        String version = this.getJarVersion();
        config.getCustomTokens().put("%%mlHubVersion%%", version);
        this.appConfig = config;
    }

    protected void initializeConfigDirs(AppConfig config) {
        String defaultConfigPath = String.join((CharSequence)File.separator, "src", "main", "ml-config");
        boolean configDirsIsSetToTheMlAppDeployerDefault = config.getConfigDirs().size() == 1 && ((ConfigDir)config.getConfigDirs().get(0)).getBaseDir().toString().endsWith(defaultConfigPath);
        ArrayList<ConfigDir> configDirs = new ArrayList<ConfigDir>();
        if (configDirsIsSetToTheMlAppDeployerDefault) {
            configDirs.add(new ConfigDir(this.getHubConfigDir().toFile()));
            configDirs.add(new ConfigDir(this.getUserConfigDir().toFile()));
            config.setConfigDirs(configDirs);
        } else {
            for (ConfigDir configDir2 : config.getConfigDirs()) {
                File f = this.getHubProject().getProjectDir().resolve(configDir2.getBaseDir().toString()).normalize().toAbsolutePath().toFile();
                configDirs.add(new ConfigDir(f));
            }
            config.setConfigDirs(configDirs);
        }
        if (logger.isInfoEnabled()) {
            config.getConfigDirs().forEach(configDir -> logger.info("Config path: {}", (Object)configDir.getBaseDir().getAbsolutePath()));
        }
    }

    protected void initializeModulePaths(AppConfig config) {
        ArrayList<String> modulePaths = new ArrayList<String>();
        Path projectDir = this.getHubProject().getProjectDir();
        for (String modulePath : config.getModulePaths()) {
            modulePaths.add(projectDir.resolve(modulePath).normalize().toAbsolutePath().toString());
        }
        config.setModulePaths(modulePaths);
        if (logger.isInfoEnabled()) {
            logger.info("Module paths: {}", modulePaths);
        }
    }

    private void applyFinalConnectionSettingsToMlGradleDefaultRestSettings(AppConfig config) {
        if (this.getFinalAuthMethod() != null) {
            String authMethod = this.getMlAuthentication().equalsIgnoreCase("cloud") ? this.getMlAuthentication() : this.getFinalAuthMethod();
            config.setRestSecurityContextType(SecurityContextType.valueOf((String)authMethod.toUpperCase()));
        }
        if (Boolean.TRUE.equals(this.isProvisionedEnvironment)) {
            config.setRestConnectionType(DatabaseClient.ConnectionType.GATEWAY);
            config.setAppServicesConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        Integer finalPort = this.getMlAuthentication().equalsIgnoreCase("cloud") ? 443 : this.getFinalPort();
        config.setRestPort(finalPort);
        config.setCloudApiKey(this.getCloudApiKey());
        config.setRestBasePath(this.getFinalBasePath());
        config.setRestCertFile(this.getFinalCertFile());
        config.setRestCertPassword(this.getFinalCertPassword());
        config.setRestExternalName(this.getFinalExternalName());
        config.setRestSslContext(this.getFinalSslContext());
        config.setRestSslHostnameVerifier(this.getFinalSslHostnameVerifier());
        config.setRestTrustManager(this.getFinalTrustManager());
    }

    @Override
    @JsonIgnore
    public String getInfo() {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new DataHubConfigurationException("Your datahub configuration could not serialize");
        }
    }

    @Override
    @JsonIgnore
    public HubConfig withPropertiesFromEnvironment(String environment) {
        this.envString = environment;
        this.requireHubProject().setUserModulesDeployTimestampFile(this.envString + "-" + "user-modules-deploy-timestamps.properties");
        return this;
    }

    public String toString() {
        return this.getInfo();
    }

    private void loadPropertiesFromFile(File propertiesFile, Properties loadedProperties) {
        try {
            if (propertiesFile.exists()) {
                InputStream is = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);
                loadedProperties.load(is);
                is.close();
            }
        }
        catch (IOException e) {
            throw new DataHubProjectException("No properties file found in project " + this.requireHubProject().getProjectDirString());
        }
    }

    public void applyDefaultPropertyValues() {
        super.applyDefaultPropertyValues();
        this.appConfig = null;
        this.adminConfig = null;
        this.adminManager = null;
        this.manageClient = null;
        this.hubLogLevel = "default";
        this.isProvisionedEnvironment = false;
        this.stagingHttpName = "data-hub-STAGING";
        this.stagingForestsPerHost = 3;
        this.finalHttpName = "data-hub-FINAL";
        this.finalForestsPerHost = 3;
        this.jobHttpName = "data-hub-JOBS";
        this.jobForestsPerHost = 4;
        this.modulesForestsPerHost = 1;
        this.stagingTriggersForestsPerHost = 1;
        this.finalTriggersForestsPerHost = 1;
        this.stagingSchemasForestsPerHost = 1;
        this.finalSchemasForestsPerHost = 1;
        this.customForestPath = "forests";
        this.applyDefaultPermissionPropertyValues();
    }

    public void applyDefaultPermissionPropertyValues() {
        this.entityModelPermissions = "data-hub-entity-model-reader,read,data-hub-entity-model-writer,update";
        this.mappingPermissions = "data-hub-mapping-reader,read,data-hub-mapping-writer,update";
        this.stepDefinitionPermissions = "data-hub-step-definition-reader,read,data-hub-step-definition-writer,update";
        this.flowPermissions = "data-hub-flow-reader,read,data-hub-flow-writer,update";
        this.jobPermissions = "data-hub-job-reader,read,data-hub-job-internal,update";
    }

    protected void initializePropertyConsumerMap() {
        super.initializePropertyConsumerMap();
        this.getPropertyConsumerMap().put("mlHost", this::setHost);
        this.getPropertyConsumerMap().put("mlIsProvisionedEnvironment", prop -> {
            this.isProvisionedEnvironment = Boolean.parseBoolean(prop);
        });
        this.getPropertyConsumerMap().put("mlStagingAppserverName", prop -> {
            this.stagingHttpName = prop;
        });
        this.getPropertyConsumerMap().put("mlStagingForestsPerHost", prop -> {
            this.stagingForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlFinalAppserverName", prop -> {
            this.finalHttpName = prop;
        });
        this.getPropertyConsumerMap().put("mlFinalForestsPerHost", prop -> {
            this.finalForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlJobAppserverName", prop -> {
            this.jobHttpName = prop;
        });
        this.getPropertyConsumerMap().put("mlJobForestsPerHost", prop -> {
            this.jobForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlModulesForestsPerHost", prop -> {
            this.modulesForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlStagingTriggersForestsPerHost", prop -> {
            this.stagingTriggersForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlStagingSchemasForestsPerHost", prop -> {
            this.stagingSchemasForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlFinalTriggersForestsPerHost", prop -> {
            this.finalTriggersForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlFinalSchemasForestsPerHost", prop -> {
            this.finalSchemasForestsPerHost = Integer.parseInt(prop);
        });
        this.getPropertyConsumerMap().put("mlCustomForestPath", prop -> {
            this.customForestPath = prop;
        });
        this.getPropertyConsumerMap().put("mlHubLogLevel", prop -> {
            this.hubLogLevel = prop;
        });
        this.getPropertyConsumerMap().put("hubFlattenedTdeView", prop -> {
            this.hubFlattenedTdeView = Boolean.parseBoolean(prop);
        });
        this.getPropertyConsumerMap().put("mlEntityModelPermissions", prop -> {
            this.entityModelPermissions = prop;
        });
        this.getPropertyConsumerMap().put("mlFlowPermissions", prop -> {
            this.flowPermissions = prop;
        });
        this.getPropertyConsumerMap().put("mlJobPermissions", prop -> {
            this.jobPermissions = prop;
        });
        this.getPropertyConsumerMap().put("mlMappingPermissions", prop -> {
            this.mappingPermissions = prop;
        });
        this.getPropertyConsumerMap().put("mlStepDefinitionPermissions", prop -> {
            this.stepDefinitionPermissions = prop;
        });
        this.getPropertyConsumerMap().remove("hubDhs");
        this.getPropertyConsumerMap().put("hubDhs", prop -> {
            if (Boolean.parseBoolean(prop)) {
                this.configureForDhs();
            }
        });
        this.getPropertyConsumerMap().remove("hubSsl");
        this.getPropertyConsumerMap().put("hubSsl", prop -> {
            if (Boolean.parseBoolean(prop)) {
                this.enableSimpleSsl();
            } else {
                this.disableSimpleSsl();
            }
        });
    }

    public void configureForDhs() {
        super.configureForDhs();
        this.isProvisionedEnvironment = true;
        this.appConfig.setAppServicesPort(Integer.valueOf(8010));
        this.appConfig.setAppServicesSecurityContextType(SecurityContextType.BASIC);
    }

    public void enableSimpleSsl() {
        super.enableSimpleSsl();
        this.appConfig.setSimpleSslConfig();
        this.appConfig.setAppServicesSimpleSslConfig();
    }

    public void disableSimpleSsl() {
        super.disableSimpleSsl();
        this.appConfig.setRestSslContext(null);
        this.appConfig.setRestSslHostnameVerifier(null);
        this.appConfig.setRestTrustManager(null);
        this.appConfig.setAppServicesSslContext(null);
        this.appConfig.setAppServicesSslHostnameVerifier(null);
        this.appConfig.setAppServicesTrustManager(null);
    }

    @Override
    public HubClient newHubClient() {
        return new HubClientImpl((HubClientConfig)this);
    }
}

