/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.MappingManager;
import com.marklogic.hub.StepDefinitionManager;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.dataservices.FlowService;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.impl.FlowImpl;
import com.marklogic.hub.impl.MappingManagerImpl;
import com.marklogic.hub.impl.StepDefinitionManagerImpl;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.util.json.JSONObject;
import com.marklogic.hub.util.json.JSONStreamWriter;
import com.marklogic.hub.util.json.JSONUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class FlowManagerImpl
extends LoggingObject
implements FlowManager {
    private static final Pattern flowExtension = Pattern.compile("(.+)\\.flow\\.json");
    @Autowired
    private HubConfig hubConfig;
    private HubClient hubClient;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private StepDefinitionManager stepDefinitionManager;
    private JsonNode flowScaffolding = null;

    public FlowManagerImpl() {
    }

    public FlowManagerImpl(HubConfig hubConfig) {
        this(hubConfig, new MappingManagerImpl(hubConfig), new StepDefinitionManagerImpl(hubConfig));
    }

    public FlowManagerImpl(HubClient hubClient) {
        this.hubClient = hubClient;
    }

    public FlowManagerImpl(HubConfig hubConfig, MappingManager mappingManager) {
        this.hubConfig = hubConfig;
        this.mappingManager = mappingManager;
    }

    public FlowManagerImpl(HubConfig hubConfig, MappingManager mappingManager, StepDefinitionManager stepDefinitionManager) {
        this.hubConfig = hubConfig;
        this.mappingManager = mappingManager;
        this.stepDefinitionManager = stepDefinitionManager;
    }

    @Override
    public HubConfig getHubConfig() {
        return this.hubConfig;
    }

    @Override
    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    @Override
    public Flow getFlow(String flowName) {
        Flow flow;
        if (StringUtils.isEmpty((CharSequence)flowName)) {
            throw new IllegalArgumentException("Cannot get flow; no flow name provided");
        }
        try {
            JsonNode jsonFlow = this.getFlowService().getFlow(flowName);
            flow = new FlowImpl().deserialize(jsonFlow);
        }
        catch (FailedRequestException ex) {
            if (HttpStatus.valueOf((int)ex.getServerStatusCode()) == HttpStatus.NOT_FOUND) {
                flow = null;
            }
            throw new RuntimeException("Unable to retrieve flow with name: " + flowName, ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to retrieve flow with name: " + flowName, ex);
        }
        return flow;
    }

    @Override
    public Flow getLocalFlow(String flowName) {
        ObjectNode node = this.getLocalFlowAsJSON(flowName);
        if (node != null) {
            Flow newFlow = this.createFlowFromJSON((JsonNode)node);
            if (newFlow != null && !newFlow.getName().isEmpty()) {
                return newFlow;
            }
            throw new DataHubProjectException(flowName + " is not a valid flow");
        }
        return null;
    }

    public ObjectNode getLocalFlowAsJSON(String flowName) {
        ObjectNode node;
        Path flowPath = Paths.get(this.hubConfig.getFlowsDir().toString(), flowName + ".flow.json");
        InputStream inputStream = this.getClass().getResourceAsStream("/hub-internal-artifacts/flows/" + flowName + ".flow.json");
        if (inputStream == null) {
            try {
                inputStream = FileUtils.openInputStream((File)flowPath.toFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new DataHubProjectException(e.getMessage());
            }
        }
        try {
            node = (ObjectNode)JSONObject.readInput(inputStream);
        }
        catch (IOException e) {
            throw new DataHubProjectException("Unable to read flow: " + e.getMessage());
        }
        return node;
    }

    @Override
    public Flow getFullFlow(String flowName) {
        try {
            JsonNode jsonFlow = this.getFlowService().getFullFlow(flowName);
            return new FlowImpl().deserialize(jsonFlow);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to retrieve flow with name: " + flowName + "; cause: " + ex.getMessage(), ex);
        }
    }

    @Override
    public String getFlowAsJSON(String flowName) {
        try {
            return JSONObject.writeValueAsString(this.getFlow(flowName));
        }
        catch (JsonProcessingException e) {
            throw new DataHubProjectException("Unable to serialize flow object.");
        }
    }

    @Override
    public List<Flow> getFlows() {
        List<String> flowNames = this.getLocalFlowNames();
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (String flowName : flowNames) {
            Flow flow = this.getFlow(flowName);
            if (flow == null) {
                flow = this.getLocalFlow(flowName);
            }
            flows.add(flow);
        }
        flows.sort(Comparator.comparing(Flow::getName));
        return flows;
    }

    @Override
    public List<String> getLocalFlowNames() {
        File flowsDir = this.hubConfig.getFlowsDir().toFile();
        if (!flowsDir.exists()) {
            return new ArrayList<String>();
        }
        List files = (List)FileUtils.listFiles((File)flowsDir, (String[])new String[]{"flow.json"}, (boolean)false);
        List<String> flowNames = files.stream().map(f -> flowExtension.matcher(f.getName()).replaceAll("$1")).collect(Collectors.toList());
        return flowNames;
    }

    @Override
    public List<String> getFlowNames() {
        ArrayList<String> flowNames = new ArrayList<String>();
        this.getArtifactService().getList("flow").elements().forEachRemaining(flow -> {
            if (flow.has("name")) {
                flowNames.add(flow.get("name").asText());
            }
        });
        return flowNames;
    }

    @Override
    public Flow createFlow(String flowName) {
        Flow flow = this.createFlowFromJSON(this.getFlowScaffolding());
        flow.setName(flowName);
        return flow;
    }

    @Override
    public Flow createFlowFromJSON(String json) {
        JsonNode node;
        try {
            node = JSONObject.readInput(json);
        }
        catch (JsonParseException e) {
            throw new DataHubProjectException("Unable to parse flow json string : " + e.getMessage());
        }
        catch (JsonMappingException e1) {
            throw new DataHubProjectException("Unable to parse flow json string : " + e1.getMessage());
        }
        catch (IOException e2) {
            throw new DataHubProjectException("Unable to parse flow json string : " + e2.getMessage());
        }
        return this.createFlowFromJSON(node);
    }

    @Override
    public Flow createFlowFromJSON(JsonNode json) {
        FlowImpl flow = new FlowImpl();
        flow.deserialize(json);
        return flow;
    }

    @Override
    public void deleteFlow(String flowName) {
        File flowFile = Paths.get(this.hubConfig.getFlowsDir().toString(), flowName + ".flow.json").toFile();
        if (flowFile.exists()) {
            try {
                FileUtils.forceDelete((File)flowFile);
            }
            catch (IOException e) {
                throw new DataHubProjectException("Could not delete flow " + flowName);
            }
        } else {
            throw new DataHubProjectException("The specified flow doesn't exist.");
        }
        try {
            this.getFlowService().deleteFlow(flowName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to delete flow; cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteStep(Flow flow, String key) {
        Step removedStep = FlowManagerImpl.removeStepFromFlow(flow, key);
        this.saveFlow(flow);
        this.deleteRelatedStepArtifacts(flow, removedStep);
    }

    public static Step removeStepFromFlow(Flow flow, String key) {
        Map<String, Step> stepMap = flow.getSteps();
        int stepOrder = Integer.parseInt(key);
        Step removedStep = null;
        if (stepOrder == stepMap.size()) {
            removedStep = stepMap.remove(key);
        } else {
            LinkedHashMap<String, Step> newStepMap = new LinkedHashMap<String, Step>();
            int[] newStepOrder = new int[]{1};
            int[] stepIndex = new int[]{1};
            for (Step step : stepMap.values()) {
                if (stepIndex[0] != stepOrder) {
                    int n = newStepOrder[0];
                    newStepOrder[0] = n + 1;
                    newStepMap.put(String.valueOf(n), step);
                } else {
                    removedStep = step;
                }
                stepIndex[0] = stepIndex[0] + 1;
            }
            stepMap = newStepMap;
        }
        flow.setSteps(stepMap);
        return removedStep;
    }

    @Override
    public void saveLocalFlow(Flow flow) {
        File file = this.getFileForLocalFlow(flow.getName());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JSONStreamWriter writer = new JSONStreamWriter(fileOutputStream);
            writer.write(flow);
        }
        catch (Exception ex) {
            throw new DataHubProjectException("Could not save flow to project filesystem; cause: " + ex.getMessage(), ex);
        }
    }

    public void saveLocalFlow(JsonNode flow) {
        File file = this.getFileForLocalFlow(flow.get("name").asText());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JSONStreamWriter writer = new JSONStreamWriter(fileOutputStream);
            writer.write(flow);
        }
        catch (Exception ex) {
            throw new DataHubProjectException("Could not save flow to project filesystem; cause: " + ex.getMessage(), ex);
        }
    }

    public File getFileForLocalFlow(String flowName) {
        File flowsDir = this.hubConfig.getFlowsDir().toFile();
        if (!flowsDir.exists()) {
            flowsDir.mkdirs();
        }
        String flowFileName = flowName + ".flow.json";
        return Paths.get(this.hubConfig.getFlowsDir().toString(), flowFileName).toFile();
    }

    @Override
    public void saveFlow(Flow flow) {
        this.saveLocalFlow(flow);
        try {
            this.getArtifactService().setArtifact("flow", flow.getName(), JSONUtils.convertArtifactToJson(flow), "");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create flow; cause: " + e.getMessage(), e);
        }
    }

    public Pair<File, String> addStepToFlow(String flowName, String stepName, String stepType) {
        JsonNode flow;
        StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(stepType);
        Assert.notNull((Object)((Object)stepDefType), (String)("Unrecognized step type: " + stepType));
        File flowFile = this.hubConfig.getFlowsDir().resolve(flowName + ".flow.json").toFile();
        try {
            DatabaseClient stagingClient = this.hubConfig.newHubClient().getStagingClient();
            FlowService flowService = FlowService.on(stagingClient);
            flow = flowService.addStepToFlow(flowName, stepName, stepType);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to add step '" + stepName + "' to flow'" + flowName + "'; cause: " + e.getMessage(), e);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(flowFile, (Object)flow);
            return Pair.of((Object)flowFile, (Object)("Added step '" + stepName + "' to flow '" + flowName + "' in staging and final databases."));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write flow to file: " + flowFile.getAbsolutePath() + "; cause: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isFlowExisted(String flowName) {
        File flowFile = Paths.get(this.hubConfig.getFlowsDir().toString(), flowName + ".flow.json").toFile();
        return flowFile.exists();
    }

    protected ArtifactService getArtifactService() {
        return ArtifactService.on(this.hubClient != null ? this.hubClient.getStagingClient() : this.hubConfig.newStagingClient(null));
    }

    protected FlowService getFlowService() {
        return FlowService.on(this.hubClient != null ? this.hubClient.getStagingClient() : this.hubConfig.newStagingClient(null));
    }

    @Override
    @Deprecated
    public Map<String, Step> getSteps(Flow flow) {
        return flow.getSteps();
    }

    @Override
    @Deprecated
    public Step getStep(Flow flow, String stepNum) {
        return flow.getStep(stepNum);
    }

    @Override
    @Deprecated
    public void setSteps(Flow flow, Map<String, Step> stepMap) {
        flow.setSteps(stepMap);
    }

    protected void deleteRelatedStepArtifacts(Flow flow, Step removedStep) {
        if (removedStep == null) {
            return;
        }
        StepDefinition.StepDefinitionType stepTypeOfRemovedStep = StepDefinition.StepDefinitionType.getStepDefinitionType(removedStep.getStepDefinitionType().toString());
        if (removedStep.isMappingStep() && !this.mappingIsReferencedByAFlow(removedStep) && !this.isCustomMapping(removedStep)) {
            this.deleteMappingArtifacts(flow, removedStep);
        } else if (!removedStep.isCustomStep() && !this.stepIsReferencedByAFlow(removedStep.getName(), stepTypeOfRemovedStep)) {
            this.deleteStepDefinitionArtifacts(removedStep, stepTypeOfRemovedStep);
        } else if (removedStep.isCustomStep() && !this.stepIsReferencedByAFlow(removedStep.getName(), StepDefinition.StepDefinitionType.CUSTOM)) {
            this.deleteStepDefinitionArtifacts(removedStep, stepTypeOfRemovedStep);
        }
    }

    protected boolean stepIsReferencedByAFlow(String stepName, StepDefinition.StepDefinitionType stepType) {
        for (Flow flow : this.getLocalFlows()) {
            for (Step step : flow.getSteps().values()) {
                if (!stepType.equals((Object)step.getStepDefinitionType()) || !stepName.equals(step.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean mappingIsReferencedByAFlow(Step removedStep) {
        String mappingName = removedStep.getMappingName();
        if (mappingName == null) {
            return false;
        }
        for (Flow flow : this.getFlows()) {
            for (Step step : flow.getSteps().values()) {
                if (!mappingName.equals(step.getMappingName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCustomMapping(Step removedStep) {
        String modulePath = "/custom-modules/mapping/" + removedStep.getStepDefinitionName() + "/main.mjs";
        return this.stepDefinitionManager.getStepDefinition(removedStep.getStepDefinitionName(), StepDefinition.StepDefinitionType.MAPPING).getModulePath().equals(modulePath);
    }

    protected void deleteMappingArtifacts(Flow flow, Step removedStep) {
        this.logger.info("Deleting mapping as it's no longer referenced by any flows: " + removedStep.getName());
        String mappingName = removedStep.getMappingName();
        this.mappingManager.deleteMapping(mappingName);
        this.deleteDocumentsInDirectory(this.format("/mappings/%s/", new Object[]{mappingName}));
    }

    protected void deleteStepDefinitionArtifacts(Step removedStep, StepDefinition.StepDefinitionType stepTypeOfRemovedStep) {
        this.logger.info("Deleting custom step as it's no longer referenced by any flows: " + removedStep.getName() + ". The module associated with this step will not be deleted in case other modules refer to it.");
        StepDefinition stepDef = StepDefinition.create(removedStep.getName(), stepTypeOfRemovedStep);
        this.stepDefinitionManager.deleteStepDefinition(stepDef);
        this.deleteDocumentsInDirectory(this.format("/step-definitions/%s/%s/", new Object[]{stepDef.getType().toString(), stepDef.getName()}));
    }

    protected void deleteDocumentsInDirectory(String directory) {
        String query = this.format("declareUpdate(); cts.uris(null, null, cts.directoryQuery('%s', 'infinity')).toArray().forEach(uri => xdmp.documentDelete(uri))", new Object[]{directory});
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deleting documents in directory '%s' in staging database", new Object[]{directory}));
        }
        DatabaseClient stagingClient = this.hubConfig.newStagingClient();
        stagingClient.newServerEval().javascript(query).evalAs(String.class);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deleting documents in directory '%s' in final database", new Object[]{directory}));
        }
        DatabaseClient finalClient = this.hubConfig.newFinalClient();
        finalClient.newServerEval().javascript(query).evalAs(String.class);
    }

    private JsonNode getFlowScaffolding() {
        if (this.flowScaffolding != null) {
            return this.flowScaffolding;
        }
        String flowScaffoldingSrcFile = "scaffolding/flowName.flow.json";
        InputStream inputStream = FlowManagerImpl.class.getClassLoader().getResourceAsStream(flowScaffoldingSrcFile);
        try {
            this.flowScaffolding = JSONObject.readInput(inputStream);
            return this.flowScaffolding;
        }
        catch (IOException e) {
            throw new DataHubProjectException("Unable to parse flow json string : " + e.getMessage());
        }
    }

    @Override
    public List<Flow> getLocalFlows() {
        List<String> flowNames = this.getLocalFlowNames();
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (String flow : flowNames) {
            flows.add(this.getLocalFlow(flow));
        }
        return flows;
    }

    @Override
    public List<ObjectNode> getLocalFlowsAsJSON() {
        List<String> flowNames = this.getLocalFlowNames();
        ArrayList<ObjectNode> flows = new ArrayList<ObjectNode>();
        for (String flow : flowNames) {
            flows.add(this.getLocalFlowAsJSON(flow));
        }
        return flows;
    }
}

