/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.marklogic.hub.step.RunStepResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RunFlowResponse {
    String jobId;
    String endTime;
    String flowName;
    String jobStatus;
    String startTime;
    String lastAttemptedStep;
    String lastCompletedStep;
    String user;
    Map<String, RunStepResponse> stepResponses;
    List<Map<String, Object>> flowErrors;

    public RunFlowResponse(String jobId) {
        this.jobId = jobId;
    }

    public RunFlowResponse() {
    }

    public String toJson() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to serialize to JSON, cause: " + ex.getMessage(), ex);
        }
    }

    @JsonProperty(value="flow")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    @JsonProperty(value="timeStarted")
    public String getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="timeEnded")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getLastAttemptedStep() {
        return this.lastAttemptedStep;
    }

    public void setLastAttemptedStep(String lastAttemptedStep) {
        this.lastAttemptedStep = lastAttemptedStep;
    }

    public String getLastCompletedStep() {
        return this.lastCompletedStep;
    }

    public void setLastCompletedStep(String lastCompletedStep) {
        this.lastCompletedStep = lastCompletedStep;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Map<String, RunStepResponse> getStepResponses() {
        return this.stepResponses;
    }

    public void setStepResponses(Map<String, RunStepResponse> stepResponses) {
        this.stepResponses = stepResponses;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String toString() {
        String stepRes = ((Map)Optional.ofNullable(this.stepResponses).orElse(new HashMap())).keySet().stream().map(key -> key + "=" + this.stepResponses.get(key)).collect(Collectors.joining(", ", "{", "}"));
        return String.format("{flowName: %s, jobId: %s, jobStatus: %s, startTime: %s, endTime: %s, stepResponses: %s}", this.flowName, this.jobId, Optional.ofNullable(this.jobStatus).orElse(""), Optional.ofNullable(this.startTime).orElse(""), Optional.ofNullable(this.endTime).orElse(""), stepRes);
    }
}

