/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.ext.modulesloader.Modules;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.EntityDefModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.MappingDefModulesFinder;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.dataservices.ConceptService;
import com.marklogic.hub.dataservices.ModelsService;
import com.marklogic.hub.dataservices.StepService;
import com.marklogic.hub.deploy.commands.AbstractCacheClearingCommand;
import com.marklogic.hub.deploy.commands.LoadHubArtifactsCommand;
import com.marklogic.hub.hubcentral.HubCentralManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class LoadUserArtifactsCommand
extends AbstractCacheClearingCommand {
    private static final Pattern stepExtension = Pattern.compile(".step.json", 16);
    @Autowired
    HubConfig hubConfig;
    private ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private TokenReplacer tokenReplacer;

    public LoadUserArtifactsCommand() {
        this.setExecuteSortOrder(LoadHubArtifactsCommand.SORT_ORDER + 1);
    }

    public LoadUserArtifactsCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    static boolean isArtifactDir(Path dir, Path startPath) {
        String dirStr = dir.toString();
        String startPathStr = Pattern.quote(startPath.toString());
        String regex = startPathStr + "[/\\\\][^/\\\\]+$";
        return dirStr.matches(regex);
    }

    public void execute(CommandContext context) {
        this.tokenReplacer = context.getAppConfig().buildTokenReplacer();
        this.loadUserArtifacts();
    }

    public void loadUserArtifacts() {
        HubClient hubClient = this.hubConfig.newHubClient();
        try {
            long start = System.currentTimeMillis();
            this.loadModels(hubClient);
            this.logger.info("Loaded models, time: {}ms", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            this.loadLegacyMappings(hubClient);
            this.loadFlows(hubClient);
            this.loadStepDefinitions(hubClient);
            this.loadSteps(hubClient);
            this.loadExclusionLists(hubClient);
            this.loadHubCentralConfig(hubClient);
            this.loadHubCentralConcepts(hubClient);
            this.logger.info("Loaded flows, mappings, step definitions, steps, exclusion lists, hubcentral config, and concepts. time: {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load user artifacts, cause: " + e.getMessage(), e);
        }
    }

    private void loadModels(HubClient hubClient) {
        File modelsDir = this.hubConfig.getHubEntitiesDir().toFile();
        EntityDefModulesFinder modulesFinder = new EntityDefModulesFinder();
        this.logger.info("Loading models from directory {}", (Object)modelsDir);
        HashMap models = new HashMap();
        modulesFinder.findModules(modelsDir.toString()).getAssets().forEach(r -> {
            try {
                this.logger.info("Loading model from file: {}", (Object)r.getFilename());
                JsonNode model = this.readArtifact(r.getFile());
                models.put(this.getModelUri(model), model);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read model file: " + r.getFilename() + "; cause: " + e.getMessage(), e);
            }
        });
        if (!models.isEmpty()) {
            ModelsService modelsService = ModelsService.on(hubClient.getStagingClient());
            Map<String, List<JsonNode>> grouped = models.values().stream().collect(Collectors.groupingBy(model -> {
                String uri = this.getModelUri((JsonNode)model);
                ArrayList<String> references = new ArrayList<String>();
                references.add(uri);
                HashSet<String> visited = new HashSet<String>(references);
                references.addAll(model.findValuesAsText("relatedEntityType"));
                this.addAllConnectedReferences(models, references, visited);
                references.sort(String::compareTo);
                this.logger.info("Referenced models related to uri ({}): {}", (Object)uri, references);
                return (String)references.get(0);
            }));
            Stream<List<JsonNode>> sorted = grouped.values().stream().sorted((l1, l2) -> l2.size() - l1.size());
            HashSet alreadySaved = new HashSet();
            sorted.forEach(value -> {
                ArrayNode modelsArray = this.objectMapper.createArrayNode();
                value.forEach(jsonNode -> {
                    if (alreadySaved.contains(jsonNode)) {
                        return;
                    }
                    alreadySaved.add(jsonNode);
                    modelsArray.add(jsonNode);
                });
                if (modelsArray.size() > 0) {
                    modelsService.saveModels((JsonNode)modelsArray);
                    this.logger.info("Number of models saved: {}", (Object)modelsArray.size());
                }
            });
            alreadySaved.clear();
            this.clearCache(this.hubConfig, hubClient);
        }
    }

    private String getModelUri(JsonNode model) {
        JsonNode info = model.path("info");
        return info.path("baseUri").asText() + info.path("title").asText() + "-" + info.path("version").asText() + "/" + info.path("title").asText();
    }

    private void addAllConnectedReferences(Map<String, JsonNode> models, List<String> references, Set<String> visited) {
        ArrayList<String> existingReferences = new ArrayList<String>(references);
        existingReferences.stream().forEach(reference -> {
            if (!visited.contains(reference)) {
                visited.add((String)reference);
                JsonNode model = (JsonNode)models.get(reference);
                if (model != null) {
                    references.addAll(model.findValuesAsText("relatedEntityType"));
                    this.addAllConnectedReferences(models, references, visited);
                }
            }
        });
    }

    private void loadLegacyMappings(HubClient hubClient) throws IOException {
        final Path mappingsPath = this.hubConfig.getHubMappingsDir();
        if (mappingsPath.toFile().exists()) {
            JSONDocumentManager finalDocMgr = hubClient.getFinalClient().newJSONDocumentManager();
            JSONDocumentManager stagingDocMgr = hubClient.getStagingClient().newJSONDocumentManager();
            final DocumentWriteSet stagingMappingDocumentWriteSet = stagingDocMgr.newWriteSet();
            final DocumentWriteSet finalMappingDocumentWriteSet = finalDocMgr.newWriteSet();
            final ResourceToURI mappingResourceToURI = new ResourceToURI(){

                @Override
                public String toURI(Resource r) throws IOException {
                    return "/mappings/" + r.getFile().getParentFile().getName() + "/" + r.getFilename();
                }
            };
            final MappingDefModulesFinder mappingDefModulesFinder = new MappingDefModulesFinder();
            Files.walkFileTree(mappingsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (LoadUserArtifactsCommand.isArtifactDir(dir, mappingsPath.toAbsolutePath())) {
                        LoadUserArtifactsCommand.this.executeWalk(dir, (ModulesFinder)mappingDefModulesFinder, mappingResourceToURI, LoadUserArtifactsCommand.this.buildMetadata(LoadUserArtifactsCommand.this.hubConfig.getMappingPermissions(), "http://marklogic.com/data-hub/mappings", "hub-artifact"), stagingMappingDocumentWriteSet, finalMappingDocumentWriteSet);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!stagingMappingDocumentWriteSet.isEmpty()) {
                stagingDocMgr.write(stagingMappingDocumentWriteSet);
                finalDocMgr.write(finalMappingDocumentWriteSet);
            }
        }
    }

    void executeWalk(Path dir, ModulesFinder modulesFinder, ResourceToURI resourceToURI, DocumentMetadataHandle metadata, DocumentWriteSet ... writeSets) throws IOException {
        Modules modules = modulesFinder.findModules(dir.toString());
        for (Resource r : modules.getAssets()) {
            this.addResourceToWriteSets(r, resourceToURI.toURI(r), metadata, writeSets);
        }
    }

    protected DocumentMetadataHandle buildMetadata(String permissions, String ... collection) {
        DocumentMetadataHandle meta = new DocumentMetadataHandle();
        meta.getCollections().addAll(collection);
        meta.getPermissions().addFromDelimitedString(permissions);
        return meta;
    }

    private void addResourceToWriteSets(Resource r, String docId, DocumentMetadataHandle meta, DocumentWriteSet ... writeSets) throws IOException {
        JsonNode json = this.readArtifact(r.getFile());
        if (json instanceof ObjectNode && json.has("language")) {
            json = this.replaceLanguageWithLang((ObjectNode)json);
            try {
                this.objectMapper.writeValue(r.getFile(), (Object)json);
            }
            catch (Exception ex) {
                this.logger.warn("Unable to replace 'language' with 'lang' in artifact file: {}. You should replace 'language' with 'lang' yourself in this file. Error cause: {}", new Object[]{r.getFile().getAbsolutePath(), ex.getMessage(), ex});
            }
        }
        for (DocumentWriteSet writeSet : writeSets) {
            writeSet.add(docId, (DocumentMetadataWriteHandle)meta, (AbstractWriteHandle)new JacksonHandle(json));
        }
    }

    private void loadSteps(HubClient hubClient) {
        Path stepsPath = this.hubConfig.getHubProject().getStepsPath();
        if (stepsPath.toFile().exists()) {
            StepService stepService = StepService.on(hubClient.getStagingClient());
            File[] stepTypeDirectories = stepsPath.toFile().listFiles(File::isDirectory);
            if (stepTypeDirectories == null) {
                return;
            }
            for (File stepTypeDir : stepTypeDirectories) {
                String stepType = stepTypeDir.getName();
                File[] stepFiles = stepTypeDir.listFiles((d, name) -> name.endsWith(".step.json"));
                if (stepFiles == null) continue;
                for (File stepFile : stepFiles) {
                    JsonNode step = this.readArtifact(stepFile);
                    if (!step.has("name")) {
                        throw new RuntimeException("Unable to load step from file: " + stepFile + "; no 'name' property found");
                    }
                    String stepName = step.get("name").asText();
                    this.logger.info(this.format("Loading step of type '%s' with name '%s'", new Object[]{stepType, stepName}));
                    stepService.saveStep(stepType, step, true, false);
                }
            }
        }
    }

    private void loadFlows(HubClient hubClient) {
        Path flowsPath = this.hubConfig.getHubProject().getFlowsDir();
        if (flowsPath.toFile().exists()) {
            ArtifactService service = ArtifactService.on(hubClient.getStagingClient());
            File[] flowFiles = flowsPath.toFile().listFiles(f -> f.isFile() && f.getName().endsWith(".flow.json"));
            if (flowFiles == null) {
                return;
            }
            for (File file : flowFiles) {
                JsonNode flow = this.readArtifact(file);
                if (!flow.has("name")) {
                    throw new RuntimeException("Unable to load flow from file: " + file + "; no 'name' property found");
                }
                String flowName = flow.get("name").asText();
                this.logger.info(this.format("Loading flow with name '%s'", new Object[]{flowName}));
                service.setArtifact("flow", flowName, flow, "");
            }
        }
    }

    private void loadExclusionLists(HubClient hubClient) {
        Path listsPath = this.hubConfig.getHubProject().getProjectDir().resolve("exclusionLists");
        if (listsPath.toFile().exists()) {
            ArtifactService service = ArtifactService.on(hubClient.getStagingClient());
            for (File file : Objects.requireNonNull(listsPath.toFile().listFiles(f -> f.isFile() && f.getName().endsWith(".exclusionList.json")))) {
                JsonNode exclusionList = this.readArtifact(file);
                if (!exclusionList.has("name")) {
                    throw new RuntimeException("Unable to load exclusion list from file: " + file + "; no 'name' property found");
                }
                String listName = exclusionList.get("name").asText();
                this.logger.info(this.format("Loading exclusion list with name '%s'", new Object[]{listName}));
                service.setArtifact("exclusionList", listName, exclusionList, "/exclusionLists/");
            }
        }
    }

    private void loadHubCentralConfig(HubClient hubClient) {
        Path configPath = this.hubConfig.getHubProject().getHubCentralConfigPath();
        if (configPath.toFile().exists()) {
            File[] configFiles = configPath.toFile().listFiles(File::isFile);
            if (configFiles == null) {
                return;
            }
            for (File file : configFiles) {
                JsonNode hubCentralConfig = this.readArtifact(file);
                String docUri = "/config/".concat(file.getName());
                HubCentralManager.deployHubCentralConfig(hubClient, hubCentralConfig, docUri);
            }
        }
    }

    private void loadHubCentralConcepts(HubClient hubClient) {
        Path configPath = this.hubConfig.getHubProject().getHubCentralConceptsPath();
        ArrayNode conceptsArray = this.objectMapper.createArrayNode();
        if (configPath.toFile().exists()) {
            File[] conceptFiles = configPath.toFile().listFiles(f -> f.isFile() && f.getName().endsWith(".concept.json"));
            if (conceptFiles == null) {
                return;
            }
            for (File file : conceptFiles) {
                conceptsArray.add(this.readArtifact(file));
            }
        }
        if (!conceptsArray.isEmpty()) {
            ConceptService.on(hubClient.getStagingClient()).saveConceptModels((JsonNode)conceptsArray);
            this.clearCache(this.hubConfig, hubClient);
        }
    }

    private void loadStepDefinitions(HubClient hubClient) {
        Path stepDefsPath = this.hubConfig.getHubProject().getStepDefinitionsDir();
        if (stepDefsPath.toFile().exists()) {
            ArtifactService service = ArtifactService.on(hubClient.getStagingClient());
            File[] typeDirectories = stepDefsPath.toFile().listFiles(File::isDirectory);
            if (typeDirectories == null) {
                return;
            }
            for (File typeDir : typeDirectories) {
                String stepDefType = typeDir.getName();
                File[] definitionDirectories = typeDir.listFiles(File::isDirectory);
                if (definitionDirectories == null) continue;
                for (File defDir : definitionDirectories) {
                    String[] fileNames = defDir.list();
                    if (fileNames == null) continue;
                    for (String stepDefFileName : fileNames) {
                        File stepDefFile = new File(defDir, stepDefFileName);
                        if (stepDefFile.exists()) {
                            JsonNode stepDef = this.readArtifact(stepDefFile);
                            if (!stepDef.has("name")) {
                                throw new RuntimeException("Unable to load step definition from file: " + stepDefFile + "; no 'name' property was found");
                            }
                            String stepDefName = stepDef.get("name").asText();
                            this.logger.info(this.format("Loading step definition with type '%s' and name '%s'", new Object[]{stepDefType, stepDefName}));
                            service.setArtifact("stepDefinition", stepDefName, stepDef, stepExtension.matcher(stepDefFileName).replaceAll(""));
                            continue;
                        }
                        this.logger.warn(this.format("Found step definition directory '%s', but did not find expected step definition file: '%s'", new Object[]{defDir.getAbsolutePath(), stepDefFile.getName()}));
                    }
                }
            }
        }
    }

    protected ObjectNode replaceLanguageWithLang(ObjectNode object) {
        ObjectNode newObject = this.objectMapper.createObjectNode();
        newObject.put("lang", object.get("language").asText());
        Iterator fieldNames = object.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("language".equals(fieldName)) continue;
            newObject.set(fieldName, object.get(fieldName));
        }
        return newObject;
    }

    private JsonNode readArtifact(File file) {
        JsonNode jsonNode;
        try {
            String artifact = this.tokenReplacer.replaceTokens(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            jsonNode = this.objectMapper.readTree(artifact);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read file " + file.getName() + " + as JSON; cause: " + e.getMessage(), e);
        }
        return jsonNode;
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static abstract class ResourceToURI {
        ResourceToURI() {
        }

        public abstract String toURI(Resource var1) throws IOException;
    }
}

