/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.SystemService;
import com.marklogic.hub.deploy.util.CloudUtil;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.impl.VersionInfo;
import org.apache.commons.lang3.StringUtils;

public class FinishHubDeploymentCommand
extends AbstractCommand {
    private final HubConfigImpl hubConfig;
    private final CloudUtil cloudUtil;

    public FinishHubDeploymentCommand(HubConfig hubConfig) {
        this.hubConfig = (HubConfigImpl)hubConfig;
        this.setExecuteSortOrder(Integer.MAX_VALUE);
        this.cloudUtil = new CloudUtil(this.hubConfig);
    }

    public void execute(CommandContext context) {
        SystemService.on(this.hubConfig.newHubClient().getStagingClient()).finishHubDeployment();
        if (StringUtils.equals((CharSequence)"cloud", (CharSequence)this.hubConfig.getMlAuthentication())) {
            this.cloudUtil.jsonPostRequest("/api/service/finishDataHubInstallation", this.getDataHubStatus());
        }
    }

    private String getDataHubStatus() {
        VersionInfo versionInfo = VersionInfo.newVersionInfo(this.hubConfig.newHubClient());
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode dataHubStatus = mapper.createObjectNode();
        dataHubStatus.put("adminPath", this.hubConfig.getAdminConfig().getBasePath());
        dataHubStatus.put("dataHubVersion", versionInfo.getHubVersion());
        return dataHubStatus.toString();
    }
}

