/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.ResourceUtil;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployHubDatabaseCommand
extends DeployDatabaseCommand {
    private static final Pattern databasePostfix = Pattern.compile("-database", 16);
    private static final Logger staticLogger = LoggerFactory.getLogger(DeployHubDatabaseCommand.class);
    private final HubConfig hubConfig;
    private final String databaseFilename;
    private final File databaseFile;
    private boolean mergeEntityConfigFiles = true;
    private boolean mergeExistingArrayProperties = false;
    private boolean removeSchemaAndTriggersDatabaseSettings = false;

    public DeployHubDatabaseCommand(HubConfig hubConfig, File databaseFile, String databaseFilename) {
        super(databaseFilename);
        if (databaseFile != null) {
            super.setDatabaseFile(databaseFile);
        }
        this.databaseFile = databaseFile;
        this.hubConfig = hubConfig;
        this.databaseFilename = databaseFilename;
        if (databaseFilename != null) {
            this.setForestFilename(databasePostfix.matcher(databaseFilename).replaceAll("-forest"));
        }
    }

    public void execute(CommandContext context) {
        if (this.databaseFile != null && this.logger.isInfoEnabled()) {
            this.logger.info("Processing file: {}", (Object)this.databaseFile);
        }
        super.execute(context);
    }

    protected String getPayload(CommandContext context) {
        String payload = super.getPayload(context);
        try {
            return payload != null ? this.preparePayloadBeforeSubmitting(context, payload) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String preparePayloadBeforeSubmitting(CommandContext context, String payload) throws IOException {
        ObjectNode payloadNode = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(payload);
        if (this.mergeEntityConfigFiles) {
            payloadNode = this.mergePayloadWithEntityConfigFileIfItExists(context, payloadNode);
        }
        if (this.mergeExistingArrayProperties) {
            payloadNode = this.mergeExistingArrayProperties(context, payloadNode);
        }
        DeployHubDatabaseCommand.mergeNamespacesInUse(context, payloadNode);
        this.removeSchemaAndTriggersDatabaseSettings(payloadNode);
        if (payloadNode.has("language") && "zxx".equalsIgnoreCase(payloadNode.path("language").asText())) {
            this.logger.warn("Removing 'language' property because it has a value of 'zxx'; complete payload: {}", (Object)payload);
            payloadNode.remove("language");
        }
        return payloadNode.toString();
    }

    private ObjectNode mergeExistingArrayProperties(CommandContext context, ObjectNode propertiesToSave) {
        if (!propertiesToSave.has("database-name") || propertiesToSave.path("database-name").asText("%%").startsWith("%%")) {
            this.logger.warn("Database payload unexpectedly does not have 'database-name' property; will not merge existing array properties: {}", (Object)propertiesToSave);
            return propertiesToSave;
        }
        String dbName = propertiesToSave.get("database-name").asText();
        try {
            String json = new DatabaseManager(context.getManageClient()).getPropertiesAsJson(dbName, new String[0]);
            ObjectNode existingProperties = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(json);
            return ResourceUtil.mergeExistingArrayProperties(propertiesToSave, existingProperties);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.format("Unexpected error when trying to merge existing array properties for database '%s'; cause: " + ex.getMessage(), new Object[]{dbName}), ex);
        }
    }

    protected ObjectNode mergePayloadWithEntityConfigFileIfItExists(CommandContext context, ObjectNode payloadNode) throws IOException {
        if (this.databaseFilename != null) {
            File entityDatabaseDir = this.hubConfig.getEntityDatabaseDir().toFile();
            File hubInternalDatabaseDir = this.hubConfig.getHubConfigDir().resolve("databases").toFile();
            File mlConfigDatabaseDir = this.hubConfig.getUserDatabaseDir().toFile();
            Stream<ObjectNode> nodesStream = Stream.of(entityDatabaseDir, hubInternalDatabaseDir, mlConfigDatabaseDir).map(dir -> {
                File dirDatabaseFile = new File((File)dir, this.databaseFilename);
                if (dirDatabaseFile.exists()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Merging in file: {}", (Object)dirDatabaseFile.getAbsolutePath());
                    }
                    String entityConfigPayload = this.readResourceFromFile(context, dirDatabaseFile);
                    ObjectNode entityConfigNode = null;
                    try {
                        entityConfigNode = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(entityConfigPayload);
                    }
                    catch (JsonProcessingException e) {
                        this.logger.warn("Unable to parse entity config file: {}", (Object)dirDatabaseFile.getAbsolutePath(), (Object)e);
                    }
                    return entityConfigNode;
                }
                return null;
            }).filter(Objects::nonNull);
            ObjectNode[] nodes = nodesStream.collect(Collectors.toList()).toArray(new ObjectNode[0]);
            return nodes.length > 1 ? JsonNodeUtil.mergeObjectNodes((ObjectNode[])nodes) : payloadNode;
        }
        return payloadNode;
    }

    private void removeSchemaAndTriggersDatabaseSettings(ObjectNode payload) {
        if (this.removeSchemaAndTriggersDatabaseSettings) {
            payload.remove("schema-database");
            payload.remove("triggers-database");
        }
    }

    public static void mergeNamespacesInUse(CommandContext context, ObjectNode propertiesToSave) {
        ObjectNode existingProperties;
        String dbName = propertiesToSave.get("database-name").asText();
        try {
            String json = new DatabaseManager(context.getManageClient()).getPropertiesAsJson(dbName, new String[0]);
            existingProperties = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(json);
        }
        catch (Exception ex) {
            staticLogger.debug("Unable to retrieve existing JSON to merge path-namespaces. Cause: {}", (Object)ex.getMessage());
            return;
        }
        ArrayNode existingNamespacesArray = existingProperties.withArray("path-namespace");
        ArrayNode newNamespacesArray = propertiesToSave.withArray("path-namespace");
        Iterator it = existingNamespacesArray.elements();
        while (it.hasNext()) {
            JsonNode existingNode = (JsonNode)it.next();
            boolean hasNamespace = false;
            Iterator it2 = newNamespacesArray.elements();
            while (it2.hasNext()) {
                JsonNode newNode = (JsonNode)it2.next();
                if (!existingNode.path("prefix").equals((Object)newNode.path("prefix"))) continue;
                hasNamespace = true;
                break;
            }
            if (hasNamespace) continue;
            newNamespacesArray.add(existingNode);
        }
    }

    public void setMergeEntityConfigFiles(boolean mergeEntityConfigFiles) {
        this.mergeEntityConfigFiles = mergeEntityConfigFiles;
    }

    public void setRemoveSchemaAndTriggersDatabaseSettings(boolean removeSchemaAndTriggersDatabaseSettings) {
        this.removeSchemaAndTriggersDatabaseSettings = removeSchemaAndTriggersDatabaseSettings;
    }

    public boolean isRemoveSchemaAndTriggersDatabaseSettings() {
        return this.removeSchemaAndTriggersDatabaseSettings;
    }

    public void setMergeExistingArrayProperties(boolean mergeExistingArrayProperties) {
        this.mergeExistingArrayProperties = mergeExistingArrayProperties;
    }
}

