/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.CmaConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.alert.DeployAlertActionsCommand;
import com.marklogic.appdeployer.command.alert.DeployAlertConfigsCommand;
import com.marklogic.appdeployer.command.alert.DeployAlertRulesCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.databases.DeployOtherDatabasesCommand;
import com.marklogic.appdeployer.command.schemas.LoadSchemasCommand;
import com.marklogic.appdeployer.command.security.DeployPrivilegesCommand;
import com.marklogic.appdeployer.command.security.DeployProtectedPathsCommand;
import com.marklogic.appdeployer.command.security.DeployRolesCommand;
import com.marklogic.appdeployer.command.tasks.DeployScheduledTasksCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalAxesCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalCollectionsCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalCollectionsLSQTCommand;
import com.marklogic.appdeployer.command.triggers.DeployTriggersCommand;
import com.marklogic.appdeployer.impl.SimpleAppDeployer;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.MarkLogicVersion;
import com.marklogic.hub.deploy.commands.DeployHubAmpsCommand;
import com.marklogic.hub.deploy.commands.DeployHubQueryRolesetsCommand;
import com.marklogic.hub.deploy.commands.GenerateFunctionMetadataCommand;
import com.marklogic.hub.deploy.commands.HubDeployDatabaseCommandFactory;
import com.marklogic.hub.deploy.commands.LoadUserArtifactsCommand;
import com.marklogic.hub.deploy.commands.LoadUserModulesCommand;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.impl.VersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HubDeployer
extends LoggingObject {
    public void deployAsDeveloper(HubConfigImpl hubConfig) {
        this.deployWithCommands(hubConfig, HubDeployer.buildCommandsForDeveloper(hubConfig));
    }

    public void deployAsSecurityAdmin(HubConfigImpl hubConfig) {
        this.deployWithCommands(hubConfig, HubDeployer.buildCommandsForSecurityAdmin());
    }

    public void deployToReplica(HubConfig hubConfig) {
        this.deployWithCommands(hubConfig, HubDeployer.buildCommandsForReplica(hubConfig));
    }

    private void deployWithCommands(HubConfig hubConfig, List<Command> commands) {
        HubDeployer.throwExceptionIfMarkLogicVersionIsInvalid(hubConfig);
        this.prepareAppConfigForDeployingToDhs(hubConfig);
        SimpleAppDeployer deployer = new SimpleAppDeployer(hubConfig.getManageClient(), hubConfig.getAdminManager(), new Command[0]);
        deployer.setCommands(commands);
        deployer.deploy(hubConfig.getAppConfig());
    }

    public static void throwExceptionIfMarkLogicVersionIsInvalid(HubConfig hubConfig) {
        MarkLogicVersion mlVersion = new MarkLogicVersion(hubConfig.getManageClient());
        if (!mlVersion.supportsDataHubFramework()) {
            throw new RuntimeException(String.format("Cannot proceed as this version of Data Hub does not support the detected version of MarkLogic:\nMarkLogic host: %s\nMarkLogic version: %s\nData Hub client version: %s\nPlease see https://docs.marklogic.com/datahub/refs/version-compatibility.html for information on the minimum required MarkLogic version.", hubConfig.getHost(), mlVersion.getVersionString(), VersionInfo.getBuildVersion()));
        }
    }

    protected void prepareAppConfigForDeployingToDhs(HubConfig hubConfig) {
        AppConfig appConfig = hubConfig.getAppConfig();
        appConfig.setModuleTimestampsPath(null);
        appConfig.setCreateForests(false);
        HubDeployer.removeHubInternalConfigFromConfigDirs(appConfig);
        HubDeployer.addEntityConfigToConfigDirs(hubConfig.getHubProject(), appConfig);
        if (hubConfig.getIsProvisionedEnvironment().booleanValue()) {
            String authMethod;
            HubDeployer.setKnownValuesForDhsDeployment(hubConfig);
            int port = hubConfig.getPort(DatabaseKind.STAGING);
            this.logger.info("Setting App-Services port to: " + port);
            appConfig.setAppServicesPort(Integer.valueOf(port));
            if (hubConfig.getSimpleSsl(DatabaseKind.STAGING)) {
                this.logger.info("Enabling simple SSL for App-Services");
                appConfig.setAppServicesSimpleSslConfig();
            }
            if ((authMethod = hubConfig.getAuthMethod(DatabaseKind.STAGING)) != null) {
                this.logger.info("Setting security context type for App-Services to: " + authMethod);
                appConfig.setAppServicesSecurityContextType(SecurityContextType.valueOf((String)authMethod.toUpperCase()));
            }
        }
        appConfig.setCmaConfig(new CmaConfig(false));
        appConfig.getCmaConfig().setDeployProtectedPaths(true);
    }

    protected static void removeHubInternalConfigFromConfigDirs(AppConfig appConfig) {
        ArrayList safeConfigDirs = new ArrayList();
        appConfig.getConfigDirs().forEach(configDir -> {
            String path = configDir.getBaseDir().getAbsolutePath();
            if (!path.toLowerCase().endsWith("hub-internal-config")) {
                safeConfigDirs.add(configDir);
            }
        });
        appConfig.setConfigDirs(safeConfigDirs);
    }

    protected static void addEntityConfigToConfigDirs(HubProject hubProject, AppConfig appConfig) {
        File entityConfigDir = hubProject.getEntityConfigDir().toFile();
        if (entityConfigDir.exists()) {
            File f = hubProject.getProjectDir().resolve(entityConfigDir.toString()).normalize().toAbsolutePath().toFile();
            appConfig.getConfigDirs().add(new ConfigDir(f));
        }
    }

    protected static void setKnownValuesForDhsDeployment(HubConfig hubConfig) {
        hubConfig.setHttpName(DatabaseKind.STAGING, "data-hub-STAGING");
        hubConfig.setHttpName(DatabaseKind.FINAL, "data-hub-FINAL");
        hubConfig.setHttpName(DatabaseKind.JOB, "data-hub-JOBS");
        hubConfig.setDbName(DatabaseKind.STAGING, "data-hub-STAGING");
        hubConfig.setDbName(DatabaseKind.FINAL, "data-hub-FINAL");
        hubConfig.setDbName(DatabaseKind.JOB, "data-hub-JOBS");
        hubConfig.setDbName(DatabaseKind.MODULES, "data-hub-MODULES");
        hubConfig.setDbName(DatabaseKind.STAGING_TRIGGERS, "data-hub-staging-TRIGGERS");
        hubConfig.setDbName(DatabaseKind.STAGING_SCHEMAS, "data-hub-staging-SCHEMAS");
        hubConfig.setDbName(DatabaseKind.FINAL_TRIGGERS, "data-hub-final-TRIGGERS");
        hubConfig.setDbName(DatabaseKind.FINAL_SCHEMAS, "data-hub-final-SCHEMAS");
        AppConfig appConfig = hubConfig.getAppConfig();
        if (appConfig != null) {
            appConfig.setContentDatabaseName(hubConfig.getDbName(DatabaseKind.FINAL));
            appConfig.setTriggersDatabaseName(hubConfig.getDbName(DatabaseKind.FINAL_TRIGGERS));
            appConfig.setSchemasDatabaseName(hubConfig.getDbName(DatabaseKind.FINAL_SCHEMAS));
            appConfig.setModulesDatabaseName(hubConfig.getDbName(DatabaseKind.MODULES));
            Map customTokens = appConfig.getCustomTokens();
            customTokens.put("%%mlStagingDbName%%", hubConfig.getDbName(DatabaseKind.STAGING));
            customTokens.put("%%mlFinalDbName%%", hubConfig.getDbName(DatabaseKind.FINAL));
            customTokens.put("%%mlJobDbName%%", hubConfig.getDbName(DatabaseKind.JOB));
            customTokens.put("%%mlModulesDbName%%", hubConfig.getDbName(DatabaseKind.MODULES));
            customTokens.put("%%mlStagingAppserverName%%", hubConfig.getDbName(DatabaseKind.STAGING));
            customTokens.put("%%mlFinalAppserverName%%", hubConfig.getDbName(DatabaseKind.FINAL));
            customTokens.put("%%mlJobAppserverName%%", hubConfig.getDbName(DatabaseKind.JOB));
            customTokens.put("%%mlStagingTriggersDbName%%", hubConfig.getDbName(DatabaseKind.STAGING_TRIGGERS));
            customTokens.put("%%mlStagingSchemasDbName%%", hubConfig.getDbName(DatabaseKind.STAGING_SCHEMAS));
            customTokens.put("%%mlFinalTriggersDbName%%", hubConfig.getDbName(DatabaseKind.FINAL_TRIGGERS));
            customTokens.put("%%mlFinalSchemasDbName%%", hubConfig.getDbName(DatabaseKind.FINAL_SCHEMAS));
        }
    }

    protected static List<Command> buildCommandsForSecurityAdmin() {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add((Command)new DeployPrivilegesCommand());
        commands.add((Command)new DeployRolesCommand());
        commands.add((Command)new DeployHubAmpsCommand());
        return commands;
    }

    protected static List<Command> buildCommandsForReplica(HubConfig hubConfig) {
        List<Command> commands = HubDeployer.buildCommandsForDeveloperForReplica(hubConfig);
        commands.addAll(HubDeployer.buildCommandsForSecurityAdmin());
        return commands;
    }

    private static List<Command> buildCommandsForDeveloperForReplica(HubConfig hubConfig) {
        ArrayList<Command> commands = new ArrayList<Command>();
        DeployOtherDatabasesCommand deployOtherDatabasesCommand = new DeployOtherDatabasesCommand();
        HubDeployDatabaseCommandFactory dbCommandFactory = new HubDeployDatabaseCommandFactory(hubConfig);
        dbCommandFactory.setMergeEntityConfigFiles(true);
        dbCommandFactory.setRemoveSchemaAndTriggersDatabaseSettings(true);
        deployOtherDatabasesCommand.setDeployDatabaseCommandFactory((DeployDatabaseCommandFactory)dbCommandFactory);
        deployOtherDatabasesCommand.setResourceFilenamesIncludePattern(HubDeployer.buildPatternForDatabasesToUpdateIndexesFor());
        commands.add((Command)deployOtherDatabasesCommand);
        commands.add((Command)new DeployScheduledTasksCommand());
        DeployProtectedPathsCommand pathsCommand = new DeployProtectedPathsCommand();
        pathsCommand.setExecuteSortOrder(Integer.MAX_VALUE);
        commands.add((Command)pathsCommand);
        commands.add((Command)new DeployHubQueryRolesetsCommand());
        return commands;
    }

    protected static List<Command> buildCommandsForDeveloper(HubConfig hubConfig) {
        List<Command> commands = HubDeployer.buildCommandsForDeveloperForReplica(hubConfig);
        commands.add((Command)new DeployAlertConfigsCommand());
        commands.add((Command)new DeployAlertActionsCommand());
        commands.add((Command)new DeployAlertRulesCommand());
        commands.add((Command)new LoadUserArtifactsCommand(hubConfig));
        LoadUserModulesCommand loadUserModulesCommand = new LoadUserModulesCommand(hubConfig);
        loadUserModulesCommand.setForceLoad(true);
        commands.add((Command)loadUserModulesCommand);
        commands.add((Command)new GenerateFunctionMetadataCommand(hubConfig));
        commands.add((Command)new DeployTemporalAxesCommand());
        commands.add((Command)new DeployTemporalCollectionsCommand());
        commands.add((Command)new DeployTemporalCollectionsLSQTCommand());
        commands.add((Command)new DeployTriggersCommand());
        commands.add((Command)new LoadSchemasCommand());
        return commands;
    }

    protected static Pattern buildPatternForDatabasesToUpdateIndexesFor() {
        return Pattern.compile("(staging|final|job)-database.json");
    }
}

