/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface FlowService {
    public static FlowService on(DatabaseClient db) {
        return FlowService.on(db, null);
    }

    public static FlowService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class FlowServiceImpl
        implements FlowService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_updateFlow;
            private BaseProxy.DBFunctionRequest req_getFlow;
            private BaseProxy.DBFunctionRequest req_deleteFlow;
            private BaseProxy.DBFunctionRequest req_addStepToFlow;
            private BaseProxy.DBFunctionRequest req_getFlowsWithStepDetails;
            private BaseProxy.DBFunctionRequest req_getFlowWithLatestJobInfo;
            private BaseProxy.DBFunctionRequest req_getFlowsWithLatestJobInfo;
            private BaseProxy.DBFunctionRequest req_removeStepFromFlow;
            private BaseProxy.DBFunctionRequest req_createFlow;
            private BaseProxy.DBFunctionRequest req_getFullFlow;

            FlowServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/flow/", servDecl);
                this.req_updateFlow = this.baseProxy.request("updateFlow.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_getFlow = this.baseProxy.request("getFlow.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_deleteFlow = this.baseProxy.request("deleteFlow.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_addStepToFlow = this.baseProxy.request("addStepToFlow.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getFlowsWithStepDetails = this.baseProxy.request("getFlowsWithStepDetails.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getFlowWithLatestJobInfo = this.baseProxy.request("getFlowWithLatestJobInfo.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getFlowsWithLatestJobInfo = this.baseProxy.request("getFlowsWithLatestJobInfo.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_removeStepFromFlow = this.baseProxy.request("removeStepFromFlow.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_createFlow = this.baseProxy.request("createFlow.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getFullFlow = this.baseProxy.request("getFullFlow.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
            }

            @Override
            public JsonNode updateFlow(String name, String description, ArrayNode stepIds) {
                return this.updateFlow(this.req_updateFlow.on(this.dbClient), name, description, stepIds);
            }

            private JsonNode updateFlow(BaseProxy.DBFunctionRequest request, String name, String description, ArrayNode stepIds) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name)), BaseProxy.atomicParam((String)"description", (boolean)true, (String)BaseProxy.StringType.fromString((String)description)), BaseProxy.documentParam((String)"stepIds", (boolean)true, (BufferableContentHandle)BaseProxy.ArrayType.fromArrayNode((ArrayNode)stepIds))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getFlow(String name) {
                return this.getFlow(this.req_getFlow.on(this.dbClient), name);
            }

            private JsonNode getFlow(BaseProxy.DBFunctionRequest request, String name) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void deleteFlow(String name) {
                this.deleteFlow(this.req_deleteFlow.on(this.dbClient), name);
            }

            private void deleteFlow(BaseProxy.DBFunctionRequest request, String name) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name))}).responseNone();
            }

            @Override
            public JsonNode addStepToFlow(String flowName, String stepName, String stepDefinitionType) {
                return this.addStepToFlow(this.req_addStepToFlow.on(this.dbClient), flowName, stepName, stepDefinitionType);
            }

            private JsonNode addStepToFlow(BaseProxy.DBFunctionRequest request, String flowName, String stepName, String stepDefinitionType) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName)), BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName)), BaseProxy.atomicParam((String)"stepDefinitionType", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepDefinitionType))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getFlowsWithStepDetails() {
                return this.getFlowsWithStepDetails(this.req_getFlowsWithStepDetails.on(this.dbClient));
            }

            private JsonNode getFlowsWithStepDetails(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getFlowWithLatestJobInfo(String name) {
                return this.getFlowWithLatestJobInfo(this.req_getFlowWithLatestJobInfo.on(this.dbClient), name);
            }

            private JsonNode getFlowWithLatestJobInfo(BaseProxy.DBFunctionRequest request, String name) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getFlowsWithLatestJobInfo() {
                return this.getFlowsWithLatestJobInfo(this.req_getFlowsWithLatestJobInfo.on(this.dbClient));
            }

            private JsonNode getFlowsWithLatestJobInfo(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode removeStepFromFlow(String flowName, String stepNumber) {
                return this.removeStepFromFlow(this.req_removeStepFromFlow.on(this.dbClient), flowName, stepNumber);
            }

            private JsonNode removeStepFromFlow(BaseProxy.DBFunctionRequest request, String flowName, String stepNumber) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName)), BaseProxy.atomicParam((String)"stepNumber", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepNumber))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode createFlow(String name, String description) {
                return this.createFlow(this.req_createFlow.on(this.dbClient), name, description);
            }

            private JsonNode createFlow(BaseProxy.DBFunctionRequest request, String name, String description) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name)), BaseProxy.atomicParam((String)"description", (boolean)true, (String)BaseProxy.StringType.fromString((String)description))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getFullFlow(String flowName) {
                return this.getFullFlow(this.req_getFullFlow.on(this.dbClient), flowName);
            }

            private JsonNode getFullFlow(BaseProxy.DBFunctionRequest request, String flowName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName))}).responseSingle(false, Format.JSON));
            }
        }
        return new FlowServiceImpl(db, serviceDeclaration);
    }

    public JsonNode updateFlow(String var1, String var2, ArrayNode var3);

    public JsonNode getFlow(String var1);

    public void deleteFlow(String var1);

    public JsonNode addStepToFlow(String var1, String var2, String var3);

    public JsonNode getFlowsWithStepDetails();

    public JsonNode getFlowWithLatestJobInfo(String var1);

    public JsonNode getFlowsWithLatestJobInfo();

    public JsonNode removeStepFromFlow(String var1, String var2);

    public JsonNode createFlow(String var1, String var2);

    public JsonNode getFullFlow(String var1);
}

