/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface ArtifactService {
    public static ArtifactService on(DatabaseClient db) {
        return ArtifactService.on(db, null);
    }

    public static ArtifactService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class ArtifactServiceImpl
        implements ArtifactService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_getArtifactsWithProjectPaths;
            private BaseProxy.DBFunctionRequest req_setArtifact;
            private BaseProxy.DBFunctionRequest req_deleteArtifact;
            private BaseProxy.DBFunctionRequest req_clearUserArtifacts;
            private BaseProxy.DBFunctionRequest req_getList;
            private BaseProxy.DBFunctionRequest req_getArtifact;

            ArtifactServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/artifacts/", servDecl);
                this.req_getArtifactsWithProjectPaths = this.baseProxy.request("getArtifactsWithProjectPaths.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_setArtifact = this.baseProxy.request("setArtifact.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_deleteArtifact = this.baseProxy.request("deleteArtifact.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_clearUserArtifacts = this.baseProxy.request("clearUserArtifacts.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getList = this.baseProxy.request("getList.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getArtifact = this.baseProxy.request("getArtifact.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
            }

            @Override
            public JsonNode getArtifactsWithProjectPaths() {
                return this.getArtifactsWithProjectPaths(this.req_getArtifactsWithProjectPaths.on(this.dbClient));
            }

            private JsonNode getArtifactsWithProjectPaths(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode setArtifact(String artifactType, String artifactName, JsonNode artifact, String dirFileName) {
                return this.setArtifact(this.req_setArtifact.on(this.dbClient), artifactType, artifactName, artifact, dirFileName);
            }

            private JsonNode setArtifact(BaseProxy.DBFunctionRequest request, String artifactType, String artifactName, JsonNode artifact, String dirFileName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"artifactType", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactType)), BaseProxy.atomicParam((String)"artifactName", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactName)), BaseProxy.documentParam((String)"artifact", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)artifact)), BaseProxy.atomicParam((String)"dirFileName", (boolean)true, (String)BaseProxy.StringType.fromString((String)dirFileName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode deleteArtifact(String artifactType, String artifactName) {
                return this.deleteArtifact(this.req_deleteArtifact.on(this.dbClient), artifactType, artifactName);
            }

            private JsonNode deleteArtifact(BaseProxy.DBFunctionRequest request, String artifactType, String artifactName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"artifactType", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactType)), BaseProxy.atomicParam((String)"artifactName", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void clearUserArtifacts() {
                this.clearUserArtifacts(this.req_clearUserArtifacts.on(this.dbClient));
            }

            private void clearUserArtifacts(BaseProxy.DBFunctionRequest request) {
                request.responseNone();
            }

            @Override
            public JsonNode getList(String artifactType) {
                return this.getList(this.req_getList.on(this.dbClient), artifactType);
            }

            private JsonNode getList(BaseProxy.DBFunctionRequest request, String artifactType) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"artifactType", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactType))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getArtifact(String artifactType, String artifactName) {
                return this.getArtifact(this.req_getArtifact.on(this.dbClient), artifactType, artifactName);
            }

            private JsonNode getArtifact(BaseProxy.DBFunctionRequest request, String artifactType, String artifactName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"artifactType", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactType)), BaseProxy.atomicParam((String)"artifactName", (boolean)false, (String)BaseProxy.StringType.fromString((String)artifactName))}).responseSingle(false, Format.JSON));
            }
        }
        return new ArtifactServiceImpl(db, serviceDeclaration);
    }

    public JsonNode getArtifactsWithProjectPaths();

    public JsonNode setArtifact(String var1, String var2, JsonNode var3, String var4);

    public JsonNode deleteArtifact(String var1, String var2);

    public void clearUserArtifacts();

    public JsonNode getList(String var1);

    public JsonNode getArtifact(String var1, String var2);
}

