/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.ValuesListBuilder;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.ValuesListReadHandle;
import com.marklogic.client.query.ValuesListResults;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesListHandle
extends BaseHandle<InputStream, OperationNotSupported>
implements ValuesListReadHandle,
ValuesListResults {
    private static final Logger logger = LoggerFactory.getLogger(ValuesListHandle.class);
    private ValuesListBuilder.ValuesList valuesHolder;
    private Unmarshaller unmarshaller;
    String optionsName = null;

    public ValuesListHandle() {
        super.setFormat(Format.XML);
        try {
            JAXBContext jc = JaxbContextLoader.CACHED_CONTEXT;
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new MarkLogicBindingException((Exception)((Object)new JAXBException("JAXB context initialization failed")));
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("ValuesListHandle supports the XML format only");
        }
    }

    public ValuesListHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public String getOptionsName() {
        return this.optionsName;
    }

    public void setOptionsName(String name) {
        this.optionsName = name;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            this.valuesHolder = (ValuesListBuilder.ValuesList)this.unmarshaller.unmarshal((Reader)new InputStreamReader(content, StandardCharsets.UTF_8));
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall values list", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public HashMap<String, String> getValuesMap() {
        return this.valuesHolder.getValuesMap();
    }

    private static class JaxbContextLoader {
        private static final JAXBContext CACHED_CONTEXT;

        private JaxbContextLoader() {
        }

        static {
            try {
                CACHED_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ValuesListBuilder.ValuesList.class});
            }
            catch (JAXBException e) {
                throw new MarkLogicBindingException((Exception)((Object)e));
            }
        }
    }
}

