/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.ResourceNotResendableException;
import com.marklogic.client.admin.ExtensionMetadata;
import com.marklogic.client.admin.TransformExtensionsManager;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import com.marklogic.client.util.RequestParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformExtensionsImpl
extends AbstractLoggingManager
implements TransformExtensionsManager {
    private static final Logger logger = LoggerFactory.getLogger(TransformExtensionsImpl.class);
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    TransformExtensionsImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public <T> T listTransformsAs(Format format, Class<T> as) {
        return this.listTransformsAs(format, as, true);
    }

    @Override
    public <T> T listTransformsAs(Format format, Class<T> as, boolean refresh) {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!StructureReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to list transforms as " + as.getName());
        }
        Utilities.setHandleStructuredFormat(handle, format);
        this.listTransforms((StructureReadHandle)((Object)handle), refresh);
        return handle.get();
    }

    @Override
    public <T extends StructureReadHandle> T listTransforms(T listHandle) throws ForbiddenUserException, FailedRequestException {
        return this.listTransforms(listHandle, true);
    }

    @Override
    public <T extends StructureReadHandle> T listTransforms(T listHandle, boolean refresh) throws ForbiddenUserException, FailedRequestException {
        HandleImplementation listBase;
        Format listFormat;
        if (listHandle == null) {
            throw new IllegalArgumentException("Reading transform list with null handle");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading transform list");
        }
        if (Format.JSON != (listFormat = (listBase = HandleAccessor.checkHandle(listHandle, "transform")).getFormat()) && Format.XML != listFormat) {
            throw new IllegalArgumentException("list handle for unsupported format: " + ((Object)((Object)listFormat)).getClass().getName());
        }
        RequestParameters extraParams = null;
        if (!refresh) {
            extraParams = new RequestParameters();
            extraParams.put("refresh", "false");
        }
        listBase.receiveContent(this.services.getValues(this.requestLogger, "config/transforms", extraParams, listFormat.getDefaultMimetype(), listBase.receiveAs()));
        return listHandle;
    }

    @Override
    public <T> T readXQueryTransformAs(String transformName, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!TextReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to read transform source as " + as.getName());
        }
        this.readXQueryTransform(transformName, (TextReadHandle)((Object)handle));
        return handle.get();
    }

    @Override
    public <T> T readXSLTransformAs(String transformName, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!XMLReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to read transform source as " + as.getName());
        }
        this.readXSLTransform(transformName, (XMLReadHandle)((Object)handle));
        return handle.get();
    }

    @Override
    public <T> T readJavascriptTransformAs(String transformName, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!TextReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to read transform source as " + as.getName());
        }
        this.readJavascriptTransform(transformName, (TextReadHandle)((Object)handle));
        return handle.get();
    }

    @Override
    public <T extends TextReadHandle> T readJavascriptTransform(String transformName, T sourceHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readTransform(transformName, "application/javascript", sourceHandle);
    }

    @Override
    public <T extends TextReadHandle> T readXQueryTransform(String transformName, T sourceHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readTransform(transformName, "application/xquery", sourceHandle);
    }

    @Override
    public <T extends XMLReadHandle> T readXSLTransform(String transformName, T sourceHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readTransform(transformName, "application/xslt+xml", sourceHandle);
    }

    private <T extends AbstractReadHandle> T readTransform(String transformName, String sourceMimetype, T sourceHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (transformName == null) {
            throw new IllegalArgumentException("Reading transform with null name");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Reading transform source for {}", (Object)transformName);
        }
        HandleImplementation sourceBase = HandleAccessor.checkHandle(sourceHandle, "transform");
        sourceBase.receiveContent(this.services.getValue(this.requestLogger, "config/transforms", transformName, true, sourceMimetype, sourceBase.receiveAs()));
        return sourceHandle;
    }

    @Override
    public void writeXQueryTransformAs(String transformName, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeXQueryTransformAs(transformName, null, source);
    }

    @Override
    public void writeXQueryTransformAs(String transformName, ExtensionMetadata metadata, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (source == null) {
            throw new IllegalArgumentException("no source to write");
        }
        Class<?> as = source.getClass();
        TextWriteHandle sourceHandle = null;
        if (TextWriteHandle.class.isAssignableFrom(as)) {
            sourceHandle = (TextWriteHandle)source;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!TextWriteHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to write transform source as " + as.getName());
            }
            Utilities.setHandleContent(handle, source);
            sourceHandle = (TextWriteHandle)((Object)handle);
        }
        this.writeXQueryTransform(transformName, sourceHandle, metadata);
    }

    @Override
    public void writeXSLTransformAs(String transformName, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeXSLTransformAs(transformName, null, source);
    }

    @Override
    public void writeXSLTransformAs(String transformName, ExtensionMetadata metadata, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTextHandleTransformAs(transformName, metadata, source, "xquery");
    }

    @Override
    public void writeXQueryTransform(String transformName, TextWriteHandle sourceHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeXQueryTransform(transformName, sourceHandle, null);
    }

    @Override
    public void writeXQueryTransform(String transformName, TextWriteHandle sourceHandle, ExtensionMetadata metadata) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTransform(transformName, "application/xquery", sourceHandle, metadata);
    }

    @Override
    public void writeJavascriptTransformAs(String transformName, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeJavascriptTransformAs(transformName, null, source);
    }

    @Override
    public void writeJavascriptTransformAs(String transformName, ExtensionMetadata metadata, Object source) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTextHandleTransformAs(transformName, metadata, source, "javascript");
    }

    private void writeTextHandleTransformAs(String transformName, ExtensionMetadata metadata, Object source, String transformType) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (source == null) {
            throw new IllegalArgumentException("no source to write");
        }
        Class<?> as = source.getClass();
        TextWriteHandle sourceHandle = null;
        if (TextWriteHandle.class.isAssignableFrom(as)) {
            sourceHandle = (TextWriteHandle)source;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!TextWriteHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to write transform source as " + as.getName());
            }
            Utilities.setHandleContent(handle, source);
            sourceHandle = (TextWriteHandle)((Object)handle);
        }
        if (transformType.equals("javascript")) {
            this.writeJavascriptTransform(transformName, sourceHandle, metadata);
        } else if (transformType.equals("xquery")) {
            this.writeXQueryTransform(transformName, sourceHandle, metadata);
        }
    }

    @Override
    public void writeJavascriptTransform(String transformName, TextWriteHandle sourceHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTransform(transformName, "application/javascript", sourceHandle, null);
    }

    @Override
    public void writeJavascriptTransform(String transformName, TextWriteHandle sourceHandle, ExtensionMetadata metadata) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTransform(transformName, "application/javascript", sourceHandle, metadata);
    }

    @Override
    public void writeXSLTransform(String transformName, XMLWriteHandle sourceHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeXSLTransform(transformName, sourceHandle, null);
    }

    @Override
    public void writeXSLTransform(String transformName, XMLWriteHandle sourceHandle, ExtensionMetadata metadata) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.writeTransform(transformName, "application/xslt+xml", sourceHandle, metadata);
    }

    private void writeTransform(String transformName, String sourceMimetype, AbstractWriteHandle sourceHandle, ExtensionMetadata metadata) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (transformName == null) {
            throw new IllegalArgumentException("Writing transform with null name");
        }
        if (sourceHandle == null) {
            throw new IllegalArgumentException("Writing transform source with null handle");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Writing transform source for {}", (Object)transformName);
        }
        HandleImplementation sourceBase = HandleAccessor.checkHandle(sourceHandle, "transform");
        Format sourceFormat = sourceBase.getFormat();
        if ("application/xquery".equals(sourceMimetype)) {
            if (Format.TEXT != sourceFormat) {
                sourceBase.setFormat(Format.TEXT);
            }
        } else if ("application/xslt+xml".equals(sourceMimetype)) {
            if (Format.XML != sourceFormat) {
                sourceBase.setFormat(Format.XML);
            }
        } else if ("application/javascript".equals(sourceMimetype)) {
            if (Format.JSON != sourceFormat) {
                sourceBase.setFormat(Format.JSON);
            }
        } else {
            throw new MarkLogicInternalException("Unsupported mimetype for source: " + sourceMimetype);
        }
        if (!sourceMimetype.equals(sourceBase.getMimetype())) {
            sourceBase.setMimetype(sourceMimetype);
        }
        RequestParameters extraParams = metadata != null ? metadata.asParameters() : null;
        this.services.putValue(this.requestLogger, "config/transforms", transformName, extraParams, sourceMimetype, sourceBase);
    }

    @Override
    public void deleteTransform(String transformName) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (transformName == null) {
            throw new IllegalArgumentException("Deleting transform with null name");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Deleting transform for {}", (Object)transformName);
        }
        this.services.deleteValue(this.requestLogger, "config/transforms", transformName);
    }
}

