/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.marklogic.client.datamovement.NodeOperation;
import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JSONSplitter<T extends JSONWriteHandle>
implements Splitter<T> {
    private Visitor<T> visitor;
    private long count = 0L;
    private String splitFilename;
    private UriMaker uriMaker;

    public static JSONSplitter<StringHandle> makeArraySplitter() {
        ArrayVisitor arrayVisitor = new ArrayVisitor();
        return new JSONSplitter<StringHandle>(arrayVisitor);
    }

    public JSONSplitter(Visitor<T> visitor) {
        this.setVisitor(visitor);
    }

    public Visitor<T> getVisitor() {
        return this.visitor;
    }

    public void setVisitor(Visitor<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        this.visitor = visitor;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Stream<T> split(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        JsonParser jsonParser = new JsonFactory().createParser(input);
        return this.split(jsonParser);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        JsonParser jsonParser = new JsonFactory().createParser(input);
        return this.splitWriteOperations(jsonParser, splitFilename);
    }

    public Stream<T> split(JsonParser input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        HandleSpliterator handleSpliterator = new HandleSpliterator(this, input);
        return StreamSupport.stream(handleSpliterator, true);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(JsonParser input, String splitFilename) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        this.splitFilename = splitFilename;
        DocumentWriteOperationSpliterator spliterator = new DocumentWriteOperationSpliterator(this, input);
        return StreamSupport.stream(spliterator, true);
    }

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        this.uriMaker = uriMaker;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<JSONWriteHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(long var1, JSONWriteHandle var3);
    }

    private static class JsonContainerParser
    extends JsonParserDelegate {
        private int depth = 1;

        JsonContainerParser(JsonParser jsonParser) {
            super(jsonParser);
        }

        public boolean isClosed() {
            return this.depth > 0;
        }

        private void maintainDepth(JsonToken currentToken) {
            if (currentToken == null) {
                return;
            }
            switch (currentToken) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++this.depth;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --this.depth;
                }
            }
        }

        private void maintainDepth() throws IOException {
            JsonToken next = super.nextToken();
            this.maintainDepth(next);
        }

        public JsonToken nextToken() throws IOException {
            if (this.depth == 0) {
                throw new IllegalStateException("The JSON branch is closed");
            }
            this.maintainDepth();
            return super.getCurrentToken();
        }

        public Boolean nextBooleanValue() throws IOException {
            if (this.depth == 0) {
                return null;
            }
            this.maintainDepth();
            return super.getBooleanValue();
        }

        public String nextFieldName() throws IOException {
            if (this.depth == 0) {
                return null;
            }
            this.maintainDepth();
            return super.getText();
        }

        public int nextIntValue(int defaultValue) throws IOException {
            if (this.depth == 0) {
                return -1;
            }
            this.maintainDepth();
            return super.getIntValue();
        }

        public long nextLongValue(long defaultValue) throws IOException {
            if (this.depth == 0) {
                return -1L;
            }
            this.maintainDepth();
            return super.getLongValue();
        }

        public String nextTextValue() throws IOException {
            if (this.depth == 0) {
                return null;
            }
            this.maintainDepth();
            return super.getText();
        }

        public void close() {
            throw new UnsupportedOperationException("Current JSON branch cannot be closed.");
        }
    }

    private static class DocumentWriteOperationSpliterator<T extends JSONWriteHandle>
    extends JSONSpliterator<DocumentWriteOperation, T> {
        DocumentWriteOperationSpliterator(JSONSplitter<T> splitter, JsonParser jsonParser) {
            super(splitter, jsonParser);
        }

        @Override
        public boolean tryAdvance(Consumer<? super DocumentWriteOperation> action) {
            Object handle = this.getNextHandle();
            if (handle == null) {
                return false;
            }
            JSONSplitter splitter = this.getSplitter();
            if (splitter.getUriMaker() == null) {
                UriMakerImpl uriMaker = new UriMakerImpl();
                uriMaker.setSplitFilename(splitter.splitFilename);
                uriMaker.setExtension("json");
                splitter.setUriMaker(uriMaker);
            } else if (splitter.splitFilename != null) {
                splitter.getUriMaker().setSplitFilename(splitter.splitFilename);
            }
            this.getSplitter().count = this.getSplitter().getCount() + 1L;
            DocumentWriteOperation documentWriteOperation = this.getSplitter().getVisitor().makeDocumentWriteOperation(this.getSplitter().getUriMaker(), this.getSplitter().getCount(), handle);
            action.accept(documentWriteOperation);
            return true;
        }
    }

    private static class HandleSpliterator<T extends JSONWriteHandle>
    extends JSONSpliterator<T, T> {
        HandleSpliterator(JSONSplitter<T> splitter, JsonParser jsonParser) {
            super(splitter, jsonParser);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Object handle = this.getNextHandle();
            if (handle == null) {
                return false;
            }
            this.getSplitter().count = this.getSplitter().getCount() + 1L;
            action.accept(handle);
            return true;
        }
    }

    private static abstract class JSONSpliterator<U, T extends JSONWriteHandle>
    extends Spliterators.AbstractSpliterator<U> {
        private JsonParser jsonParser;
        private ArrayDeque<String> key = new ArrayDeque();
        private Visitor<T> visitor;
        private JSONSplitter<T> splitter;

        private JsonParser getJsonParser() {
            return this.jsonParser;
        }

        private void setJsonParser(JsonParser jsonParser) {
            this.jsonParser = jsonParser;
        }

        private void setSplitter(JSONSplitter<T> splitter) {
            if (splitter == null) {
                throw new IllegalArgumentException("JSONSplitter cannot be null");
            }
            this.splitter = splitter;
        }

        JSONSplitter<T> getSplitter() {
            return this.splitter;
        }

        JSONSpliterator(JSONSplitter<T> splitter, JsonParser jsonParser) {
            super(Long.MAX_VALUE, 1280);
            this.setSplitter(splitter);
            this.setJsonParser(jsonParser);
            this.visitor = splitter.getVisitor();
        }

        T getNextHandle() {
            try {
                while (this.jsonParser.nextToken() != null) {
                    JsonToken currentToken = this.jsonParser.currentToken();
                    block1 : switch (currentToken) {
                        case FIELD_NAME: {
                            this.key.pop();
                            this.key.push(this.jsonParser.getCurrentName());
                            break;
                        }
                        case START_OBJECT: {
                            NodeOperation operation = this.visitor.startObject(this.key.peek());
                            switch (operation) {
                                case DESCEND: {
                                    this.key.push(currentToken.asString());
                                    break block1;
                                }
                                case PROCESS: {
                                    JSONWriteHandle handle = (JSONWriteHandle)this.visitor.makeBufferedHandle((JsonParser)new JsonContainerParser(this.jsonParser));
                                    if (handle == null) break block1;
                                    return (T)handle;
                                }
                                case SKIP: {
                                    this.jsonParser.skipChildren();
                                    break block1;
                                }
                            }
                            throw new IllegalStateException("Unknown state");
                        }
                        case END_OBJECT: {
                            this.visitor.endObject(this.key.peek());
                            this.key.pop();
                            break;
                        }
                        case START_ARRAY: {
                            NodeOperation operation_array = this.visitor.startArray(this.key.peek());
                            switch (operation_array) {
                                case DESCEND: {
                                    break block1;
                                }
                                case PROCESS: {
                                    JSONWriteHandle handle = (JSONWriteHandle)this.visitor.makeBufferedHandle((JsonParser)new JsonContainerParser(this.jsonParser));
                                    if (handle == null) break block1;
                                    return (T)handle;
                                }
                                case SKIP: {
                                    this.jsonParser.skipChildren();
                                    break block1;
                                }
                            }
                            throw new IllegalStateException("Unknown state");
                        }
                        case END_ARRAY: {
                            this.visitor.endArray(this.key.peek());
                        }
                    }
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to traverse document", e);
            }
        }
    }

    public static class ArrayVisitor
    extends Visitor<StringHandle> {
        private int arrayDepth = 0;

        @Override
        public NodeOperation startObject(String containerKey) {
            if (this.arrayDepth > 0) {
                return NodeOperation.PROCESS;
            }
            return NodeOperation.DESCEND;
        }

        @Override
        public NodeOperation startArray(String containerKey) {
            this.incrementArrayDepth();
            if (this.arrayDepth > 1) {
                this.decrementArrayDepth();
                return NodeOperation.PROCESS;
            }
            return NodeOperation.DESCEND;
        }

        @Override
        public void endArray(String containerKey) {
            this.decrementArrayDepth();
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public void incrementArrayDepth() {
            ++this.arrayDepth;
        }

        public void decrementArrayDepth() {
            --this.arrayDepth;
        }

        @Override
        public StringHandle makeBufferedHandle(JsonParser containerParser) {
            if (containerParser == null) {
                throw new IllegalArgumentException("JsonParser cannot be null");
            }
            String content = this.serialize(containerParser);
            return new StringHandle(content).withFormat(Format.JSON);
        }
    }

    public static abstract class Visitor<T extends AbstractWriteHandle> {
        public NodeOperation startObject(String containerKey) {
            return NodeOperation.DESCEND;
        }

        public void endObject(String containerKey) {
        }

        public NodeOperation startArray(String containerKey) {
            return NodeOperation.DESCEND;
        }

        public void endArray(String containerKey) {
        }

        public abstract T makeBufferedHandle(JsonParser var1);

        public DocumentWriteOperation makeDocumentWriteOperation(UriMaker uriMaker, long count, T handle) {
            if (handle == null) {
                throw new IllegalArgumentException("Handle cannot be null");
            }
            String uri = uriMaker.makeUri(count, (JSONWriteHandle)handle);
            return new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, (AbstractWriteHandle)handle);
        }

        public String serialize(JsonParser containerParser) {
            if (containerParser == null) {
                throw new IllegalArgumentException("JsonParser cannot be null");
            }
            try {
                StringWriter stringWriter = new StringWriter();
                JsonGenerator jsonGenerator = new JsonFactory().createGenerator((Writer)stringWriter);
                jsonGenerator.copyCurrentStructure(containerParser);
                jsonGenerator.close();
                return stringWriter.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not serialize the document", e);
            }
        }
    }
}

