/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.Transaction;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.alerting.RuleManager;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.document.BinaryDocumentManager;
import com.marklogic.client.document.GenericDocumentManager;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.document.TextDocumentManager;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.pojo.PojoRepository;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.row.RowManager;
import com.marklogic.client.semantics.GraphManager;
import com.marklogic.client.semantics.SPARQLQueryManager;
import com.marklogic.client.util.RequestLogger;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Serializable;

public interface DatabaseClient
extends Closeable {
    public Transaction openTransaction() throws ForbiddenUserException, FailedRequestException;

    public Transaction openTransaction(String var1) throws ForbiddenUserException, FailedRequestException;

    public Transaction openTransaction(String var1, int var2) throws ForbiddenUserException, FailedRequestException;

    public GenericDocumentManager newDocumentManager();

    public BinaryDocumentManager newBinaryDocumentManager();

    public JSONDocumentManager newJSONDocumentManager();

    public TextDocumentManager newTextDocumentManager();

    public XMLDocumentManager newXMLDocumentManager();

    public DataMovementManager newDataMovementManager();

    public QueryManager newQueryManager();

    public RowManager newRowManager();

    public RuleManager newRuleManager();

    public ServerConfigurationManager newServerConfigManager();

    public GraphManager newGraphManager();

    public SPARQLQueryManager newSPARQLQueryManager();

    public <T, ID extends Serializable> PojoRepository<T, ID> newPojoRepository(Class<T> var1, Class<ID> var2);

    public <T extends ResourceManager> T init(String var1, T var2);

    public RequestLogger newLogger(OutputStream var1);

    public void release();

    public Object getClientImplementation();

    public ServerEvaluationCall newServerEval();

    public ConnectionType getConnectionType();

    public ConnectionResult checkConnection();

    public String getHost();

    public int getPort();

    public String getBasePath();

    public String getDatabase();

    public DatabaseClientFactory.SecurityContext getSecurityContext();

    @Override
    default public void close() {
        this.release();
    }

    public static interface ConnectionResult {
        public boolean isConnected();

        public Integer getStatusCode();

        public String getErrorMessage();
    }

    public static enum ConnectionType {
        DIRECT,
        GATEWAY;

    }
}

