/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.JacksonBaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JacksonDatabindHandle<T>
extends JacksonBaseHandle<T>
implements ResendableContentHandle<T, InputStream>,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle {
    private final Class<T> contentClass;
    private T content;

    public static ContentHandleFactory newFactory(Class<?> ... pojoClasses) {
        if (pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JacksonDatabindHandleFactory((Class[])pojoClasses);
    }

    public static ContentHandleFactory newFactory(ObjectMapper mapper, Class<?> ... pojoClasses) {
        if (mapper == null || pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JacksonDatabindHandleFactory(mapper, (Class[])pojoClasses);
    }

    public JacksonDatabindHandle(Class<T> contentClass) {
        this.contentClass = contentClass;
        this.setResendable(true);
    }

    public JacksonDatabindHandle(T content) {
        this(content.getClass());
        this.set((Class<?>)content);
    }

    public JacksonDatabindHandle<T> withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public JacksonDatabindHandle<T> withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public T get() {
        return this.content;
    }

    @Override
    public void set(T content) {
        this.content = content;
    }

    public JacksonDatabindHandle<T> with(T content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<T> getContentClass() {
        return this.contentClass;
    }

    @Override
    public JacksonDatabindHandle<T> newHandle() {
        return new JacksonDatabindHandle<Class<T>>(this.getContentClass()).withFormat(this.getFormat()).withMimetype(this.getMimetype());
    }

    public JacksonDatabindHandle<T>[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JacksonDatabindHandle[length];
    }

    @Override
    public ObjectMapper getMapper() {
        return super.getMapper();
    }

    @Override
    public void setMapper(ObjectMapper mapper) {
        super.setMapper(mapper);
    }

    @Override
    public T toContent(InputStream serialization) {
        Object object;
        if (serialization == null) {
            return null;
        }
        try {
            object = this.getMapper().readValue((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8), this.contentClass);
        }
        catch (JsonParseException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonMappingException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }

    @Override
    protected boolean hasContent() {
        return this.content != null;
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this.sendContent(this.get());
    }

    @Override
    protected OutputStreamSender sendContent(T content) {
        return new OutputStreamSenderImpl(this.getMapper(), content);
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.set(this.toContent(content));
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class JacksonDatabindHandleFactory
    implements ContentHandleFactory {
        private final Class<?>[] contentClasses;
        private final ObjectMapper mapper;
        private final Set<Class<?>> classSet;

        private JacksonDatabindHandleFactory(Class<?> ... contentClasses) {
            this((ObjectMapper)null, contentClasses);
        }

        private JacksonDatabindHandleFactory(ObjectMapper mapper, Class<?> ... contentClasses) {
            this.contentClasses = contentClasses;
            this.mapper = mapper;
            this.classSet = new HashSet(Arrays.asList(contentClasses));
        }

        @Override
        public Class<?>[] getHandledClasses() {
            return this.contentClasses;
        }

        @Override
        public boolean isHandled(Class<?> type) {
            return this.classSet.contains(type);
        }

        @Override
        public <C> ContentHandle<C> newHandle(Class<C> type) {
            if (!this.isHandled(type)) {
                return null;
            }
            JacksonDatabindHandle<Class<C>> handle = new JacksonDatabindHandle<Class<C>>(type);
            if (this.mapper != null) {
                handle.setMapper(this.mapper);
            }
            return handle;
        }
    }

    private static class OutputStreamSenderImpl<T>
    implements OutputStreamSender {
        private final ObjectMapper mapper;
        private T content;

        private OutputStreamSenderImpl(ObjectMapper mapper, T content) {
            if (content == null) {
                throw new IllegalStateException("No document to write");
            }
            this.mapper = mapper;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            this.mapper.writeValue((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), this.content);
        }
    }
}

