/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.document.DocumentUriTemplate;
import com.marklogic.client.io.Format;
import java.util.regex.Pattern;

public class DocumentUriTemplateImpl
implements DocumentUriTemplate {
    private static final Pattern DIRECTORY_CHECK = Pattern.compile("^[^?#]*$");
    private static final Pattern EXTENSION_CHECK = Pattern.compile("^\\.?\\w+$");
    private String directory;
    private String extension;
    private Format format;
    private String mimetype;
    private long length;

    public DocumentUriTemplateImpl(String extension) {
        this.setExtension(extension);
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(String directory) {
        if (!DIRECTORY_CHECK.matcher(directory).matches()) {
            throw new IllegalArgumentException("Directory is not valid: " + directory);
        }
        this.directory = directory;
    }

    @Override
    public DocumentUriTemplate withDirectory(String directory) {
        this.setDirectory(directory);
        return this;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(String extension) {
        if (!EXTENSION_CHECK.matcher(extension).matches()) {
            throw new IllegalArgumentException("Extension may contain only word characters after initial period: " + extension);
        }
        this.extension = extension;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public DocumentUriTemplate withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public long getByteLength() {
        return this.length;
    }

    @Override
    public void setByteLength(long length) {
        this.length = length;
    }
}

