/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.jdom;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.XMLOutputter;

public class JDOMHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements ResendableContentHandle<Document, InputStream>,
OutputStreamSender,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private Document content;
    private SAXBuilder builder;
    private XMLOutputter outputter;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JDOMHandle handle = this.isHandled(type) ? new JDOMHandle() : null;
                return handle;
            }
        };
    }

    public JDOMHandle() {
        this.setResendable(true);
        super.setFormat(Format.XML);
    }

    public JDOMHandle(Document content) {
        this();
        this.set(content);
    }

    @Override
    public JDOMHandle newHandle() {
        return new JDOMHandle();
    }

    public JDOMHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JDOMHandle[length];
    }

    public SAXBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.makeBuilder();
        }
        return this.builder;
    }

    public void setBuilder(SAXBuilder builder) {
        this.builder = builder;
    }

    protected SAXBuilder makeBuilder() {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }

    public XMLOutputter getOutputter() {
        if (this.outputter == null) {
            this.outputter = this.makeOutputter();
        }
        return this.outputter;
    }

    public void setOutputter(XMLOutputter outputter) {
        this.outputter = outputter;
    }

    protected XMLOutputter makeOutputter() {
        return new XMLOutputter();
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public JDOMHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<Document> getContentClass() {
        return Document.class;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JDOMHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public Document bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(Document content) {
        try {
            if (content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.sendContent(content).write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    public Document toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            Document document = this.getBuilder().build((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8));
            return document;
        }
        catch (JDOMException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.set(this.toContent(content));
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this.sendContent(this.get());
    }

    private OutputStreamSender sendContent(Document content) {
        return new OutputStreamSenderImpl(this.getOutputter(), content);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final XMLOutputter outputter;
        private final Document content;

        private OutputStreamSenderImpl(XMLOutputter outputter, Document content) {
            if (content == null) {
                throw new IllegalStateException("No document to write");
            }
            this.outputter = outputter;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            this.outputter.output(this.content, (Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        }
    }
}

