/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.dataservices.InputCaller;
import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.dataservices.impl.HandleProvider;
import com.marklogic.client.dataservices.impl.IOEndpointImpl;
import com.marklogic.client.dataservices.impl.InputCallerImpl;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEndpointImpl<I, O>
extends IOEndpointImpl<I, O>
implements InputCaller<I> {
    private static final Logger logger = LoggerFactory.getLogger(InputEndpointImpl.class);
    private final InputCallerImpl<I, O> caller;
    private final int batchSize;

    public InputEndpointImpl(DatabaseClient client, JSONWriteHandle apiDecl, HandleProvider<I, O> handleProvider) {
        this(client, new InputCallerImpl<I, O>(apiDecl, handleProvider));
    }

    private InputEndpointImpl(DatabaseClient client, InputCallerImpl<I, O> caller) {
        super(client, caller);
        this.caller = caller;
        this.batchSize = this.initBatchSize(caller);
    }

    private InputCallerImpl<I, O> getCaller() {
        return this.caller;
    }

    private int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void call(I[] input) {
        this.call(this.newCallContext(), input);
    }

    @Override
    public void call(IOEndpoint.CallContext callContext, I[] input) {
        InputCallerImpl callerImpl = this.getCaller();
        BufferableContentHandle<?, ?>[] inputHandles = callerImpl.bufferableInputHandleOn(input);
        callerImpl.arrayCall(this.getClient(), this.checkAllowedArgs(callContext), inputHandles);
    }

    @Deprecated
    public InputStream call(InputStream endpointState, SessionState session, InputStream endpointConstants, I[] input) {
        CallContextImpl callContext = ((CallContextImpl)this.newCallContext(true).withEndpointStateAs(endpointState).withSessionState(session)).withEndpointConstantsAs(endpointConstants);
        this.call(callContext, input);
        return callContext.getEndpointStateAsInputStream();
    }

    @Override
    public InputCaller.BulkInputCaller<I> bulkCaller() {
        return new BulkInputCallerImpl(this);
    }

    @Override
    public InputCaller.BulkInputCaller<I> bulkCaller(IOEndpoint.CallContext callContext) {
        return new BulkInputCallerImpl(this, this.getBatchSize(), this.checkAllowedArgs(callContext));
    }

    @Override
    public InputCaller.BulkInputCaller<I> bulkCaller(IOEndpoint.CallContext[] callContexts) {
        if (callContexts == null || callContexts.length == 0) {
            throw new IllegalArgumentException("CallContext cannot be null or empty");
        }
        return this.bulkCaller(callContexts, callContexts.length);
    }

    @Override
    public InputCaller.BulkInputCaller<I> bulkCaller(IOEndpoint.CallContext[] callContexts, int threadCount) {
        if (callContexts == null) {
            throw new IllegalArgumentException("CallContext cannot be null.");
        }
        if (threadCount > callContexts.length) {
            throw new IllegalArgumentException("Thread count cannot be more than the callContext count.");
        }
        switch (callContexts.length) {
            case 0: {
                throw new IllegalArgumentException("CallContext cannot be empty");
            }
            case 1: {
                return new BulkInputCallerImpl(this, this.getBatchSize(), this.checkAllowedArgs(callContexts[0]));
            }
        }
        return new BulkInputCallerImpl(this, this.getBatchSize(), this.checkAllowedArgs(callContexts), threadCount);
    }

    public static class BulkInputCallerImpl<I, O>
    extends IOEndpointImpl.BulkIOEndpointCallerImpl<I, O>
    implements InputCaller.BulkInputCaller<I> {
        private final InputEndpointImpl<I, O> endpoint;
        private final int batchSize;
        private final LinkedBlockingQueue<I> inputQueue;
        private InputCaller.BulkInputCaller.ErrorListener errorListener;

        public BulkInputCallerImpl(InputEndpointImpl<I, O> endpoint) {
            this(endpoint, ((InputEndpointImpl)endpoint).getBatchSize(), endpoint.checkAllowedArgs(endpoint.newCallContext()));
        }

        private BulkInputCallerImpl(InputEndpointImpl<I, O> endpoint, int batchSize, CallContextImpl<I, O> callContext) {
            super(endpoint, callContext);
            this.checkEndpoint(endpoint, "InputEndpointImpl");
            this.endpoint = endpoint;
            this.batchSize = batchSize;
            this.inputQueue = new LinkedBlockingQueue();
        }

        private BulkInputCallerImpl(InputEndpointImpl<I, O> endpoint, int batchSize, CallContextImpl<I, O>[] callContexts, int threadCount) {
            super(endpoint, callContexts, threadCount, 2 * callContexts.length);
            this.endpoint = endpoint;
            this.batchSize = batchSize;
            this.inputQueue = new LinkedBlockingQueue();
        }

        private InputEndpointImpl<I, O> getEndpoint() {
            return this.endpoint;
        }

        private int getBatchSize() {
            return this.batchSize;
        }

        private LinkedBlockingQueue<I> getInputQueue() {
            return this.inputQueue;
        }

        @Override
        public void accept(I input) {
            boolean hasBatch = this.queueInput(input, this.getInputQueue(), this.getBatchSize());
            if (hasBatch) {
                this.processInput();
            }
        }

        @Override
        public void acceptAll(I[] input) {
            boolean hasBatch = this.queueAllInput(input, this.getInputQueue(), this.getBatchSize());
            if (hasBatch) {
                this.processInput();
            }
        }

        private InputCaller.BulkInputCaller.ErrorListener getErrorListener() {
            return this.errorListener;
        }

        @Override
        public void setErrorListener(InputCaller.BulkInputCaller.ErrorListener errorListener) {
            this.errorListener = errorListener;
        }

        @Override
        public void awaitCompletion() {
            try {
                if (this.getInputQueue() != null) {
                    while (!this.getInputQueue().isEmpty()) {
                        this.processInput();
                    }
                }
                if (this.getCallerThreadPoolExecutor() != null) {
                    this.getCallerThreadPoolExecutor().shutdown();
                    this.getCallerThreadPoolExecutor().awaitTermination();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error occurred while awaiting termination " + throwable.getMessage());
            }
        }

        private void processInput() {
            I[] inputBatch = this.getInputBatch(this.getInputQueue(), this.getBatchSize());
            if (this.getCallContext() != null) {
                this.processInput(this.getCallContext(), inputBatch);
            } else if (this.getCallContextQueue() != null) {
                BulkCallableImpl bulkCallableImpl = new BulkCallableImpl(this, inputBatch);
                this.submitTask(bulkCallableImpl);
            } else {
                throw new IllegalArgumentException("Cannot process input without Callcontext.");
            }
        }

        private void processInput(CallContextImpl<I, O> callContext, I[] inputBatch) {
            logger.trace("input endpoint running endpoint={} count={} state={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointState()});
            InputCallerImpl callerImpl = ((InputEndpointImpl)this.getEndpoint()).getCaller();
            IOEndpoint.BulkIOEndpointCaller.ErrorDisposition error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY;
            BufferableHandle[] inputHandles = callerImpl.bufferableInputHandleOn(inputBatch);
            block9: for (int retryCount = 0; retryCount < 100 && error == IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY; ++retryCount) {
                Throwable throwable = null;
                try {
                    ((InputEndpointImpl)this.getEndpoint()).getCaller().arrayCall(callContext.getClient(), callContext, (BufferableContentHandle<?, ?>[])inputHandles);
                    this.incrementCallCount();
                    return;
                }
                catch (Throwable catchedThrowable) {
                    throwable = catchedThrowable;
                    if (throwable == null) continue;
                    if (this.getErrorListener() == null) {
                        logger.error("No error listener set. Stop all calls. " + this.getEndpoint().getEndpointPath(), throwable);
                        error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                        continue;
                    }
                    try {
                        error = retryCount < 99 ? this.getErrorListener().processError(retryCount, throwable, callContext, inputHandles) : IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.SKIP_CALL;
                    }
                    catch (Throwable throwable1) {
                        logger.error("Error Listener failed with ", throwable1);
                        error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                    }
                    switch (error) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP_CALL: {
                            return;
                        }
                        case STOP_ALL_CALLS: {
                            if (this.getCallerThreadPoolExecutor() == null) continue block9;
                            this.getCallerThreadPoolExecutor().shutdown();
                        }
                    }
                    continue;
                }
            }
        }

        private static class BulkCallableImpl<I, O>
        implements Callable<Boolean> {
            private final BulkInputCallerImpl<I, O> bulkInputCallerImpl;
            private final I[] inputBatch;

            BulkCallableImpl(BulkInputCallerImpl<I, O> bulkInputCallerImpl, I[] inputBatch) {
                this.bulkInputCallerImpl = bulkInputCallerImpl;
                this.inputBatch = inputBatch;
            }

            @Override
            public Boolean call() {
                try {
                    CallContextImpl callContext = this.bulkInputCallerImpl.getCallContextQueue().take();
                    ((BulkInputCallerImpl)this.bulkInputCallerImpl).processInput(callContext, this.inputBatch);
                    this.bulkInputCallerImpl.getCallContextQueue().put(callContext);
                }
                catch (Throwable throwable) {
                    throw new InternalError("Error occurred while processing CallContext - " + throwable.getMessage());
                }
                return true;
            }
        }
    }
}

