/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.dataservices.impl.BaseCallerImpl;
import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.dataservices.impl.IOCallerImpl;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.io.marker.BufferableHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IOEndpointImpl<I, O>
implements IOEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IOEndpointImpl.class);
    static final int DEFAULT_MAX_RETRIES = 100;
    static final int DEFAULT_BATCH_SIZE = 100;
    private final DatabaseClient client;
    private final IOCallerImpl<I, O> caller;

    public IOEndpointImpl(DatabaseClient client, IOCallerImpl<I, O> caller) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (caller == null) {
            throw new IllegalArgumentException("null caller");
        }
        this.client = client;
        this.caller = caller;
    }

    int initBatchSize(IOCallerImpl<I, O> caller) {
        JsonNode apiDeclaration = caller.getApiDeclaration();
        if (apiDeclaration.has("$bulk") && apiDeclaration.get("$bulk").isObject() && apiDeclaration.get("$bulk").has("inputBatchSize") && apiDeclaration.get("$bulk").get("inputBatchSize").isInt()) {
            return apiDeclaration.get("$bulk").get("inputBatchSize").asInt();
        }
        return 100;
    }

    DatabaseClient getClient() {
        return this.client;
    }

    private IOCallerImpl<I, O> getCaller() {
        return this.caller;
    }

    @Override
    public String getEndpointPath() {
        return this.getCaller().getEndpointPath();
    }

    @Override
    public boolean allowsEndpointState() {
        return this.getEndpointStateParamdef() != null;
    }

    BaseCallerImpl.ParamdefImpl getEndpointStateParamdef() {
        return this.getCaller().getEndpointStateParamdef();
    }

    @Override
    @Deprecated
    public boolean allowsWorkUnit() {
        return this.getEndpointConstantsParamdef() != null;
    }

    @Override
    public boolean allowsEndpointConstants() {
        return this.getEndpointConstantsParamdef() != null;
    }

    BaseCallerImpl.ParamdefImpl getEndpointConstantsParamdef() {
        return this.getCaller().getEndpointConstantsParamdef();
    }

    @Override
    public boolean allowsInput() {
        return this.getInputParamdef() != null;
    }

    BaseCallerImpl.ParamdefImpl getInputParamdef() {
        return this.getCaller().getInputParamdef();
    }

    @Override
    public boolean allowsSession() {
        return this.getSessionParamdef() != null;
    }

    BaseCallerImpl.ParamdefImpl getSessionParamdef() {
        return this.getCaller().getSessionParamdef();
    }

    @Override
    public SessionState newSessionState() {
        if (!this.allowsEndpointState()) {
            throw new IllegalStateException("endpoint does not support session state");
        }
        return this.getCaller().newSessionState();
    }

    @Override
    public CallContextImpl<I, O> newCallContext() {
        return this.newCallContext(false);
    }

    CallContextImpl<I, O> newCallContext(boolean legacyContext) {
        return new CallContextImpl(this, legacyContext);
    }

    CallContextImpl<I, O>[] checkAllowedArgs(IOEndpoint.CallContext[] callCtxts) {
        if (callCtxts == null || callCtxts.length == 0) {
            throw new IllegalArgumentException("null or empty contexts for call");
        }
        CallContextImpl[] contexts = new CallContextImpl[callCtxts.length];
        for (int i = 0; i < callCtxts.length; ++i) {
            contexts[i] = this.checkAllowedArgs(callCtxts[i]);
        }
        return contexts;
    }

    CallContextImpl<I, O> checkAllowedArgs(IOEndpoint.CallContext callCtxt) {
        if (!(callCtxt instanceof CallContextImpl)) {
            throw new IllegalArgumentException("Unknown implementation of call context");
        }
        CallContextImpl context = (CallContextImpl)callCtxt;
        if (context.getEndpointState() != null && !this.allowsEndpointState()) {
            throw new IllegalArgumentException("endpoint does not accept endpointState parameter");
        }
        if (context.getSessionState() != null && !this.allowsSession()) {
            throw new IllegalArgumentException("endpoint does not accept session parameter");
        }
        if (context.getEndpointConstants() != null && !this.allowsEndpointConstants()) {
            throw new IllegalArgumentException("endpoint does not accept " + context.getEndpointConstantsParamName() + " parameter");
        }
        return context;
    }

    static abstract class BulkIOEndpointCallerImpl<I, O>
    implements IOEndpoint.BulkIOEndpointCaller {
        private final IOEndpointImpl<I, O> endpoint;
        private WorkPhase phase = WorkPhase.INITIALIZING;
        private CallContextImpl<I, O> callContext;
        private CallerThreadPoolExecutor<I, O> callerThreadPoolExecutor;
        private LinkedBlockingQueue<CallContextImpl<I, O>> callContextQueue;
        private int threadCount;
        private long callCount = 0L;

        BulkIOEndpointCallerImpl(IOEndpointImpl<I, O> endpoint, CallContextImpl<I, O> callContext) {
            this.endpoint = endpoint;
            this.callContext = callContext;
            this.getSession();
        }

        BulkIOEndpointCallerImpl(IOEndpointImpl<I, O> endpoint, CallContextImpl<I, O>[] callContexts, int threadCount, int queueSize) {
            this.endpoint = endpoint;
            this.callerThreadPoolExecutor = new CallerThreadPoolExecutor(threadCount, queueSize, this);
            this.callContextQueue = new LinkedBlockingQueue<CallContextImpl<I, O>>(Arrays.asList(callContexts));
            this.threadCount = threadCount;
        }

        private void init(IOEndpointImpl<I, O> endpoint, int threadCount, int queueSize) {
        }

        long getCallCount() {
            return this.callCount;
        }

        void incrementCallCount() {
            ++this.callCount;
        }

        CallContextImpl<I, O> getCallContext() {
            return this.callContext;
        }

        CallerThreadPoolExecutor<I, O> getCallerThreadPoolExecutor() {
            return this.callerThreadPoolExecutor;
        }

        LinkedBlockingQueue<CallContextImpl<I, O>> getCallContextQueue() {
            return this.callContextQueue;
        }

        int getThreadCount() {
            return this.threadCount;
        }

        boolean allowsEndpointState() {
            return this.callContext.getEndpoint().allowsEndpointState();
        }

        @Override
        @Deprecated
        public InputStream getEndpointState() {
            this.checkCallContext();
            return new ByteArrayInputStream(this.callContext.getEndpointState().get());
        }

        @Override
        @Deprecated
        public void setEndpointState(byte[] endpointState) {
            this.checkCallContext();
            if (this.allowsEndpointState()) {
                this.callContext.withEndpointStateAs(endpointState);
            } else if (endpointState != null) {
                throw new IllegalArgumentException("endpoint state not accepted by endpoint: " + this.callContext.getEndpoint().getEndpointPath());
            }
        }

        @Override
        @Deprecated
        public void setEndpointState(InputStream endpointState) {
            this.setEndpointState(NodeConverter.InputStreamToBytes(endpointState));
        }

        @Override
        @Deprecated
        public void setEndpointState(BufferableHandle endpointState) {
            this.setEndpointState(endpointState == null ? null : endpointState.toBuffer());
        }

        boolean allowsEndpointConstants() {
            this.checkCallContext();
            return this.callContext.getEndpoint().allowsEndpointConstants();
        }

        @Override
        @Deprecated
        public InputStream getWorkUnit() {
            this.checkCallContext();
            return new ByteArrayInputStream(this.callContext.getEndpointConstants().get());
        }

        @Override
        @Deprecated
        public void setWorkUnit(byte[] workUnit) {
            this.checkCallContext();
            if (this.allowsEndpointConstants()) {
                this.callContext.withEndpointConstantsAs(workUnit);
            } else if (workUnit != null) {
                throw new IllegalArgumentException(this.callContext.getEndpointConstantsParamName() + " parameter not accepted by endpoint: " + this.callContext.getEndpoint().getEndpointPath());
            }
        }

        @Override
        @Deprecated
        public void setWorkUnit(InputStream workUnit) {
            this.setWorkUnit(NodeConverter.InputStreamToBytes(workUnit));
        }

        @Override
        @Deprecated
        public void setWorkUnit(BufferableHandle workUnit) {
            this.setWorkUnit(workUnit == null ? null : workUnit.toBuffer());
        }

        boolean allowsSession() {
            return this.callContext.getEndpoint().allowsSession();
        }

        SessionState getSession() {
            if (!this.allowsSession()) {
                return null;
            }
            this.checkCallContext();
            if (this.callContext.getSessionState() == null) {
                this.callContext.withSessionState(((IOEndpointImpl)this.callContext.getEndpoint()).getCaller().newSessionState());
            }
            return this.callContext.getSessionState();
        }

        boolean allowsInput() {
            return this.callContext.getEndpoint().allowsInput();
        }

        boolean queueInput(I input, BlockingQueue<I> queue, int batchSize) {
            if (input == null) {
                return false;
            }
            try {
                queue.put(input);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("InputStream was not added to the queue." + e.getMessage());
            }
            return this.checkQueue(queue, batchSize);
        }

        boolean queueAllInput(I[] input, BlockingQueue<I> queue, int batchSize) {
            if (input == null || input.length == 0) {
                return false;
            }
            try {
                for (I item : input) {
                    queue.put(item);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("InputStream was not added to the queue." + e.getMessage());
            }
            return this.checkQueue(queue, batchSize);
        }

        boolean checkQueue(BlockingQueue<I> queue, int batchSize) {
            if (queue.size() % batchSize > 0) {
                return false;
            }
            switch (this.getPhase()) {
                case INITIALIZING: {
                    this.setPhase(WorkPhase.RUNNING);
                    break;
                }
                case RUNNING: {
                    break;
                }
                case INTERRUPTING: 
                case INTERRUPTED: 
                case COMPLETED: {
                    throw new IllegalStateException("can only accept input when initializing or running and not when input is " + this.getPhase().name().toLowerCase());
                }
                default: {
                    throw new MarkLogicInternalException("unexpected state for " + this.callContext.getEndpoint().getEndpointPath() + " during loop: " + this.getPhase().name());
                }
            }
            return true;
        }

        I[] getInputBatch(BlockingQueue<I> queue, int batchSize) {
            ArrayList inputStreamList = new ArrayList();
            queue.drainTo(inputStreamList, batchSize);
            return inputStreamList.toArray(((IOEndpointImpl)this.endpoint).getCaller().newContentInputArray(inputStreamList.size()));
        }

        void processOutputBatch(O[] output, Consumer<O> outputListener) {
            if (output == null || output.length == 0) {
                return;
            }
            for (O value : output) {
                outputListener.accept(value);
            }
        }

        WorkPhase getPhase() {
            return this.phase;
        }

        void setPhase(WorkPhase phase) {
            this.phase = phase;
        }

        @Override
        public void interrupt() {
            if (this.phase == WorkPhase.RUNNING) {
                this.setPhase(WorkPhase.INTERRUPTING);
            }
        }

        private void checkCallContext() {
            if (this.callContext == null) {
                throw new InternalError("Can only call set and get methods for call state when using a single CallContext.");
            }
        }

        void submitTask(Callable<Boolean> callable) throws RejectedExecutionException {
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
            this.getCallerThreadPoolExecutor().execute(futureTask);
        }

        void checkEndpoint(IOEndpointImpl<I, O> endpoint, String endpointType) {
            if (this.getCallContext().getEndpoint() != endpoint) {
                throw new IllegalArgumentException("Endpoint must be " + endpointType);
            }
        }

        static class CallerThreadPoolExecutor<I, O>
        extends ThreadPoolExecutor {
            private Boolean awaitingTermination;
            private final BulkIOEndpointCallerImpl<I, O> bulkIOEndpointCaller;

            CallerThreadPoolExecutor(int threadCount, int queueSize, BulkIOEndpointCallerImpl<I, O> bulkIOEndpointCaller) {
                super(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
                this.bulkIOEndpointCaller = bulkIOEndpointCaller;
            }

            Boolean isAwaitingTermination() {
                return this.awaitingTermination;
            }

            synchronized void awaitTermination() throws InterruptedException {
                if (this.bulkIOEndpointCaller.getCallContextQueue().isEmpty() && this.getActiveCount() <= 1) {
                    this.shutdown();
                } else {
                    this.awaitingTermination = true;
                    this.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                }
            }
        }

        static enum WorkPhase {
            INITIALIZING,
            RUNNING,
            INTERRUPTING,
            INTERRUPTED,
            COMPLETED;

        }
    }
}

