/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.ExecCaller;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.dataservices.impl.ExecCallerImpl;
import com.marklogic.client.dataservices.impl.IOEndpointImpl;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecEndpointImpl<I, O>
extends IOEndpointImpl<I, O>
implements ExecCaller {
    private static final Logger logger = LoggerFactory.getLogger(ExecEndpointImpl.class);
    private final ExecCallerImpl<I, O> caller;

    public ExecEndpointImpl(DatabaseClient client, JSONWriteHandle apiDecl) {
        this(client, new ExecCallerImpl(apiDecl));
    }

    private ExecEndpointImpl(DatabaseClient client, ExecCallerImpl<I, O> caller) {
        super(client, caller);
        this.caller = caller;
    }

    private ExecCallerImpl<I, O> getCaller() {
        return this.caller;
    }

    @Override
    public void call() {
        this.call(this.newCallContext());
    }

    @Override
    public void call(IOEndpoint.CallContext callContext) {
        this.getCaller().call(this.getClient(), this.checkAllowedArgs(callContext));
    }

    @Deprecated
    public InputStream call(InputStream endpointState, SessionState session, InputStream endpointConstants) {
        CallContextImpl callContext = ((CallContextImpl)this.newCallContext(true).withEndpointStateAs(endpointState).withSessionState(session)).withEndpointConstantsAs(endpointConstants);
        this.call(callContext);
        return callContext.getEndpointStateAsInputStream();
    }

    @Override
    public ExecCaller.BulkExecCaller bulkCaller() {
        return new BulkExecCallerImpl(this);
    }

    @Override
    public ExecCaller.BulkExecCaller bulkCaller(IOEndpoint.CallContext callContext) {
        return new BulkExecCallerImpl(this, this.checkAllowedArgs(callContext));
    }

    @Override
    public ExecCaller.BulkExecCaller bulkCaller(IOEndpoint.CallContext[] callContexts) {
        if (callContexts == null || callContexts.length == 0) {
            throw new IllegalArgumentException("CallContext cannot be null or empty.");
        }
        return this.bulkCaller(callContexts, callContexts.length);
    }

    @Override
    public ExecCaller.BulkExecCaller bulkCaller(IOEndpoint.CallContext[] callContexts, int threadCount) {
        if (callContexts == null) {
            throw new IllegalArgumentException("CallContext cannot be null.");
        }
        if (threadCount > callContexts.length) {
            throw new IllegalArgumentException("Thread count cannot be more than the callContext count.");
        }
        switch (callContexts.length) {
            case 0: {
                throw new IllegalArgumentException("CallContext cannot be empty");
            }
            case 1: {
                return new BulkExecCallerImpl(this, this.checkAllowedArgs(callContexts[0]));
            }
        }
        return new BulkExecCallerImpl(this, (CallContextImpl[])this.checkAllowedArgs(callContexts), threadCount);
    }

    public static class BulkExecCallerImpl<I, O>
    extends IOEndpointImpl.BulkIOEndpointCallerImpl<I, O>
    implements ExecCaller.BulkExecCaller {
        private final ExecEndpointImpl<I, O> endpoint;
        private ExecCaller.BulkExecCaller.ErrorListener errorListener;
        private AtomicInteger aliveCallContextCount;

        public BulkExecCallerImpl(ExecEndpointImpl<I, O> endpoint) {
            this(endpoint, endpoint.checkAllowedArgs(endpoint.newCallContext()));
        }

        private BulkExecCallerImpl(ExecEndpointImpl<I, O> endpoint, CallContextImpl<I, O> callContext) {
            super(endpoint, callContext);
            this.checkEndpoint(endpoint, "ExecEndpointImpl");
            this.endpoint = endpoint;
        }

        private BulkExecCallerImpl(ExecEndpointImpl<I, O> endpoint, CallContextImpl<I, O>[] callContexts, int threadCount) {
            super(endpoint, callContexts, threadCount, threadCount);
            this.endpoint = endpoint;
            this.aliveCallContextCount = new AtomicInteger(threadCount);
        }

        private ExecEndpointImpl<I, O> getEndpoint() {
            return this.endpoint;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void awaitCompletion() {
            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.RUNNING);
            if (this.getCallContext() != null) {
                this.processOutput();
                return;
            }
            if (this.getCallContextQueue() == null || this.getCallContextQueue().isEmpty()) throw new IllegalArgumentException("Cannot process output without Callcontext.");
            try {
                for (int i = 0; i < this.getThreadCount(); ++i) {
                    BulkCallableImpl bulkCallableImpl = new BulkCallableImpl(this);
                    this.submitTask(bulkCallableImpl);
                }
                if (this.getCallerThreadPoolExecutor() == null) return;
                this.getCallerThreadPoolExecutor().awaitTermination();
                return;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error occurred while awaiting termination ", throwable);
            }
        }

        @Override
        public void setErrorListener(ExecCaller.BulkExecCaller.ErrorListener errorListener) {
            this.errorListener = errorListener;
        }

        private ExecCaller.BulkExecCaller.ErrorListener getErrorListener() {
            return this.errorListener;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean processExec(CallContextImpl<I, O> callContext) {
            IOEndpoint.BulkIOEndpointCaller.ErrorDisposition error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY;
            int retryCount = 0;
            while (retryCount < 100) {
                if (error != IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY) return false;
                Throwable throwable = null;
                try {
                    logger.trace("exec calling endpoint={} count={} state={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointState()});
                    boolean hasState = ((ExecEndpointImpl)this.getEndpoint()).getCaller().call(callContext.getClient(), callContext);
                    this.incrementCallCount();
                    return hasState;
                }
                catch (Throwable catchedThrowable) {
                    throwable = catchedThrowable;
                    if (throwable != null) {
                        if (this.getErrorListener() == null) {
                            logger.error("No error listener set. Stop all calls. " + this.getEndpoint().getEndpointPath(), throwable);
                            error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                        } else {
                            try {
                                error = retryCount < 99 ? this.getErrorListener().processError(retryCount, throwable, callContext) : IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.SKIP_CALL;
                            }
                            catch (Throwable throwable1) {
                                logger.error("Error Listener failed with ", throwable1);
                                error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                            }
                            switch (error) {
                                case RETRY: {
                                    break;
                                }
                                case SKIP_CALL: {
                                    if (!callContext.getEndpoint().allowsEndpointState()) return false;
                                    callContext.withEndpointState(null);
                                    return false;
                                }
                                case STOP_ALL_CALLS: {
                                    if (this.getCallerThreadPoolExecutor() == null) return false;
                                    this.getCallerThreadPoolExecutor().shutdown();
                                    return false;
                                }
                            }
                        }
                    }
                    ++retryCount;
                }
            }
            return false;
        }

        private void processOutput() {
            CallContextImpl callContext = this.getCallContext();
            if (callContext != null) {
                while (this.processOutput(callContext)) {
                }
            }
        }

        private boolean processOutput(CallContextImpl<I, O> callContext) {
            boolean continueCalling = this.processExec(callContext);
            switch (this.getPhase()) {
                case INTERRUPTING: {
                    this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INTERRUPTED);
                    logger.info("exec interrupted endpoint={} count={} work={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointConstants()});
                    return false;
                }
                case RUNNING: {
                    if (!continueCalling) {
                        if (this.getCallerThreadPoolExecutor() == null || this.aliveCallContextCount.get() == 0) {
                            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.COMPLETED);
                        }
                        logger.info("exec completed endpoint={} count={} work={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointConstants()});
                        return false;
                    }
                    return true;
                }
            }
            throw new MarkLogicInternalException("unexpected state for " + callContext.getEndpoint().getEndpointPath() + " during loop: " + this.getPhase().name());
        }

        private static class BulkCallableImpl<I, O>
        implements Callable<Boolean> {
            private final BulkExecCallerImpl<I, O> bulkExecCallerImpl;

            BulkCallableImpl(BulkExecCallerImpl<I, O> bulkExecCallerImpl) {
                this.bulkExecCallerImpl = bulkExecCallerImpl;
            }

            @Override
            public Boolean call() throws InterruptedException {
                boolean continueCalling;
                CallContextImpl callContext = this.bulkExecCallerImpl.getCallContextQueue().poll();
                boolean bl = continueCalling = callContext == null ? false : ((BulkExecCallerImpl)this.bulkExecCallerImpl).processOutput(callContext);
                if (continueCalling) {
                    this.bulkExecCallerImpl.getCallContextQueue().put(callContext);
                    this.bulkExecCallerImpl.submitTask(this);
                } else if (((BulkExecCallerImpl)this.bulkExecCallerImpl).aliveCallContextCount.decrementAndGet() == 0 && this.bulkExecCallerImpl.getCallerThreadPoolExecutor() != null) {
                    this.bulkExecCallerImpl.getCallerThreadPoolExecutor().shutdown();
                }
                return true;
            }
        }
    }
}

